/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.pruning;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.pruning.PLUG;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.pruning.TransitivePruner;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.Progress;
import java.io.File;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class SimpleDEE {
    public final SimpleConfSpace confSpace;
    public final EnergyMatrix emat;
    public final PruningMatrix pmat;
    public final PruningMatrix competitors;

    public static PruningMatrix read(SimpleConfSpace confSpace, File cacheFile) {
        return ObjectIO.readOrThrow(cacheFile, PruningMatrix.class, "pruning matrix", pmat -> pmat.matches(confSpace));
    }

    public SimpleDEE(SimpleConfSpace confSpace, EnergyMatrix emat, PruningMatrix pmat) {
        this(confSpace, emat, pmat, pmat);
    }

    public SimpleDEE(SimpleConfSpace confSpace, EnergyMatrix emat, PruningMatrix pmat, PruningMatrix competitors) {
        this.confSpace = confSpace;
        this.emat = emat;
        this.pmat = pmat;
        this.competitors = competitors;
    }

    private ResidueTemplate getTemplate(int pos, int rc) {
        return this.confSpace.positions.get((int)pos).resConfs.get((int)rc).template;
    }

    public void pruneSinglesByThreshold(double energyThreshold) {
        this.pmat.forEachUnprunedSingle((pos, rc) -> {
            if (this.emat.getOneBody(pos, rc) > energyThreshold) {
                this.pmat.pruneSingle(pos, rc);
            }
            return PruningMatrix.IteratorCommand.Continue;
        });
    }

    public void prunePairsByThreshold(double energyThreshold) {
        this.pmat.forEachUnprunedPair((pos1, rc1, pos2, rc2) -> {
            if (this.emat.getPairwise(pos1, rc1, pos2, rc2) > energyThreshold) {
                this.pmat.prunePair(pos1, rc1, pos2, rc2);
            }
            return PruningMatrix.IteratorCommand.Continue;
        });
    }

    public void pruneSinglesGoldstein(double energyDiffThreshold, boolean typeDependent) {
        this.pmat.forEachUnprunedSingle((candidatePos, candidateRc) -> {
            PruningMatrix.IteratorCommand result = this.competitors.forEachUnprunedSingleAt(candidatePos, (competitorPos, competitorRc) -> {
                if (competitorRc == candidateRc) {
                    return PruningMatrix.IteratorCommand.Continue;
                }
                if (typeDependent && !this.getTemplate((int)candidatePos, (int)candidateRc).name.equals(this.getTemplate((int)competitorPos, (int)competitorRc).name)) {
                    return PruningMatrix.IteratorCommand.Continue;
                }
                double energyDiffSum = 0.0 + this.emat.getOneBody(candidatePos, candidateRc) - this.emat.getOneBody(competitorPos, competitorRc);
                for (int witnessPos = 0; witnessPos < this.confSpace.positions.size(); ++witnessPos) {
                    if (witnessPos == candidatePos) continue;
                    double minEnergyDiff = Double.POSITIVE_INFINITY;
                    int numWitnessRCs = this.confSpace.positions.get((int)witnessPos).resConfs.size();
                    for (int witnessRc = 0; witnessRc < numWitnessRCs; ++witnessRc) {
                        if (this.pmat.isPairPruned(candidatePos, candidateRc, witnessPos, witnessRc)) continue;
                        double energyDiff = 0.0 + this.emat.getPairwise(candidatePos, candidateRc, witnessPos, witnessRc) - this.emat.getPairwise(competitorPos, competitorRc, witnessPos, witnessRc);
                        minEnergyDiff = Math.min(minEnergyDiff, energyDiff);
                    }
                    if ((energyDiffSum += minEnergyDiff) == Double.POSITIVE_INFINITY) break;
                }
                if (energyDiffSum > energyDiffThreshold) {
                    return PruningMatrix.IteratorCommand.Break;
                }
                return PruningMatrix.IteratorCommand.Continue;
            });
            if (result == PruningMatrix.IteratorCommand.Break) {
                this.pmat.pruneSingle(candidatePos, candidateRc);
            }
            return PruningMatrix.IteratorCommand.Continue;
        });
    }

    public void prunePairsGoldstein(double energyDiffThreshold, boolean typeDependent) {
        this.prunePairsGoldstein(energyDiffThreshold, typeDependent, Parallelism.makeCpu(1));
    }

    public void prunePairsGoldstein(double energyDiffThreshold, boolean typeDependent, Parallelism parallelism) {
        AtomicLong numPairs = new AtomicLong(0L);
        this.pmat.forEachUnprunedPair((pos1, rc1, pos2, rc2) -> {
            numPairs.incrementAndGet();
            return PruningMatrix.IteratorCommand.Continue;
        });
        Progress progress2 = new Progress(numPairs.get());
        try (TaskExecutor tasks = parallelism.makeTaskExecutor();){
            this.pmat.forEachUnprunedPair((candidatePos1, candidateRc1, candidatePos2, candidateRc2) -> {
                tasks.submit(() -> this.competitors.forEachUnprunedPairAt(candidatePos1, candidatePos2, (competitorPos1, competitorRc1, competitorPos2, competitorRc2) -> {
                    if (competitorRc1 == candidateRc1 && competitorRc2 == candidateRc2) {
                        return PruningMatrix.IteratorCommand.Continue;
                    }
                    if (!(!typeDependent || this.getTemplate((int)candidatePos1, (int)candidateRc1).name.equals(this.getTemplate((int)competitorPos1, (int)competitorRc1).name) && this.getTemplate((int)candidatePos2, (int)candidateRc2).name.equals(this.getTemplate((int)competitorPos2, (int)competitorRc2).name))) {
                        return PruningMatrix.IteratorCommand.Continue;
                    }
                    double energyDiffSum = 0.0 + this.emat.getOneBody(candidatePos1, candidateRc1) + this.emat.getOneBody(candidatePos2, candidateRc2) + this.emat.getPairwise(candidatePos1, candidateRc1, candidatePos2, candidateRc2) - this.emat.getOneBody(competitorPos1, competitorRc1) - this.emat.getOneBody(competitorPos2, competitorRc2) - this.emat.getPairwise(competitorPos1, competitorRc1, competitorPos2, competitorRc2);
                    for (int witnessPos = 0; witnessPos < this.confSpace.positions.size(); ++witnessPos) {
                        if (witnessPos == candidatePos1 || witnessPos == candidatePos2) continue;
                        double minEnergyDiff = Double.POSITIVE_INFINITY;
                        int numWitnessRCs = this.confSpace.positions.get((int)witnessPos).resConfs.size();
                        for (int witnessRc = 0; witnessRc < numWitnessRCs; ++witnessRc) {
                            if (this.pmat.isPairPruned(candidatePos1, candidateRc1, witnessPos, witnessRc) || this.pmat.isPairPruned(candidatePos2, candidateRc2, witnessPos, witnessRc)) continue;
                            double energyDiff = 0.0 + this.emat.getPairwise(candidatePos1, candidateRc1, witnessPos, witnessRc) + this.emat.getPairwise(candidatePos2, candidateRc2, witnessPos, witnessRc) - this.emat.getPairwise(competitorPos1, competitorRc1, witnessPos, witnessRc) - this.emat.getPairwise(competitorPos2, competitorRc2, witnessPos, witnessRc);
                            minEnergyDiff = Math.min(minEnergyDiff, energyDiff);
                        }
                        if ((energyDiffSum += minEnergyDiff) == Double.POSITIVE_INFINITY) break;
                    }
                    if (energyDiffSum > energyDiffThreshold) {
                        return PruningMatrix.IteratorCommand.Break;
                    }
                    return PruningMatrix.IteratorCommand.Continue;
                }), result -> {
                    if (result == PruningMatrix.IteratorCommand.Break) {
                        this.pmat.prunePair(candidatePos1, candidateRc1, candidatePos2, candidateRc2);
                    }
                    progress2.incrementProgress();
                });
                return PruningMatrix.IteratorCommand.Continue;
            });
        }
    }

    public void pruneTriplesGoldstein(double energyDiffThreshold, boolean typeDependent) {
        this.pruneTriplesGoldstein(energyDiffThreshold, typeDependent, Parallelism.makeCpu(1));
    }

    public void pruneTriplesGoldstein(double energyDiffThreshold, boolean typeDependent, Parallelism parallelism) {
        AtomicLong numTriples = new AtomicLong(0L);
        this.pmat.forEachUnprunedTriple((pos1, rc1, pos2, rc2, pos3, rc3) -> {
            numTriples.incrementAndGet();
            return PruningMatrix.IteratorCommand.Continue;
        });
        Progress progress2 = new Progress(numTriples.get());
        try (TaskExecutor tasks = parallelism.makeTaskExecutor();){
            this.pmat.forEachUnprunedTriple((candidatePos1, candidateRc1, candidatePos2, candidateRc2, candidatePos3, candidateRc3) -> {
                tasks.submit(() -> this.competitors.forEachUnprunedTripleAt(candidatePos1, candidatePos2, candidatePos3, (competitorPos1, competitorRc1, competitorPos2, competitorRc2, competitorPos3, competitorRc3) -> {
                    if (competitorRc1 == candidateRc1 && competitorRc2 == candidateRc2 && competitorRc3 == candidateRc3) {
                        return PruningMatrix.IteratorCommand.Continue;
                    }
                    if (!(!typeDependent || this.getTemplate((int)candidatePos1, (int)candidateRc1).name.equals(this.getTemplate((int)competitorPos1, (int)competitorRc1).name) && this.getTemplate((int)candidatePos2, (int)candidateRc2).name.equals(this.getTemplate((int)competitorPos2, (int)competitorRc2).name) && this.getTemplate((int)candidatePos3, (int)candidateRc3).name.equals(this.getTemplate((int)competitorPos3, (int)competitorRc3).name))) {
                        return PruningMatrix.IteratorCommand.Continue;
                    }
                    double energyDiffSum = 0.0 + this.emat.getOneBody(candidatePos1, candidateRc1) + this.emat.getOneBody(candidatePos2, candidateRc2) + this.emat.getOneBody(candidatePos3, candidateRc3) + this.emat.getPairwise(candidatePos1, candidateRc1, candidatePos2, candidateRc2) + this.emat.getPairwise(candidatePos1, candidateRc1, candidatePos3, candidateRc3) + this.emat.getPairwise(candidatePos2, candidateRc2, candidatePos3, candidateRc3) - this.emat.getOneBody(competitorPos1, competitorRc1) - this.emat.getOneBody(competitorPos2, competitorRc2) - this.emat.getOneBody(competitorPos3, competitorRc3) - this.emat.getPairwise(competitorPos1, competitorRc1, competitorPos2, competitorRc2) - this.emat.getPairwise(competitorPos1, competitorRc1, competitorPos3, competitorRc3) - this.emat.getPairwise(competitorPos2, competitorRc2, competitorPos3, competitorRc3);
                    for (int witnessPos = 0; witnessPos < this.confSpace.positions.size(); ++witnessPos) {
                        if (witnessPos == candidatePos1 || witnessPos == candidatePos2 || witnessPos == candidatePos3) continue;
                        double minEnergyDiff = Double.POSITIVE_INFINITY;
                        int numWitnessRCs = this.confSpace.positions.get((int)witnessPos).resConfs.size();
                        for (int witnessRc = 0; witnessRc < numWitnessRCs; ++witnessRc) {
                            if (this.pmat.isPairPruned(candidatePos1, candidateRc1, witnessPos, witnessRc) || this.pmat.isPairPruned(candidatePos2, candidateRc2, witnessPos, witnessRc) || this.pmat.isPairPruned(candidatePos3, candidateRc3, witnessPos, witnessRc)) continue;
                            double energyDiff = 0.0 + this.emat.getPairwise(candidatePos1, candidateRc1, witnessPos, witnessRc) + this.emat.getPairwise(candidatePos2, candidateRc2, witnessPos, witnessRc) + this.emat.getPairwise(candidatePos3, candidateRc3, witnessPos, witnessRc) - this.emat.getPairwise(competitorPos1, competitorRc1, witnessPos, witnessRc) - this.emat.getPairwise(competitorPos2, competitorRc2, witnessPos, witnessRc) - this.emat.getPairwise(competitorPos3, competitorRc3, witnessPos, witnessRc);
                            minEnergyDiff = Math.min(minEnergyDiff, energyDiff);
                        }
                        if ((energyDiffSum += minEnergyDiff) == Double.POSITIVE_INFINITY) break;
                    }
                    if (energyDiffSum > energyDiffThreshold) {
                        return PruningMatrix.IteratorCommand.Break;
                    }
                    return PruningMatrix.IteratorCommand.Continue;
                }), result -> {
                    if (result == PruningMatrix.IteratorCommand.Break) {
                        this.pmat.pruneTriple(candidatePos1, candidateRc1, candidatePos2, candidateRc2, candidatePos3, candidateRc3);
                    }
                    progress2.incrementProgress();
                });
                return PruningMatrix.IteratorCommand.Continue;
            });
        }
    }

    public static class Runner {
        private Double singlesThreshold = 100.0;
        private Double pairsThreshold = 100.0;
        private Double singlesGoldsteinDiffThreshold = null;
        private Double pairsGoldsteinDiffThreshold = null;
        private Double triplesGoldsteinDiffThreshold = null;
        private boolean typeDependent = false;
        private int numIterations = Integer.MAX_VALUE;
        private Double singlesPlugThreshold = null;
        private Double pairsPlugThreshold = null;
        private Double triplesPlugThreshold = null;
        private boolean singlesTransitivePruning = false;
        private boolean pairsTransitivePruning = false;
        private boolean triplesTransitivePruning = false;
        private boolean showProgress = false;
        private File cacheFile = null;
        private Parallelism parallelism = Parallelism.makeCpu(1);

        public Runner setSinglesThreshold(Double val) {
            this.singlesThreshold = val;
            return this;
        }

        public Runner setPairsThreshold(Double val) {
            this.pairsThreshold = val;
            return this;
        }

        public Runner setThreshold(Double val) {
            this.setSinglesThreshold(val);
            this.setPairsThreshold(val);
            return this;
        }

        public Runner setSinglesGoldsteinDiffThreshold(Double val) {
            this.singlesGoldsteinDiffThreshold = val;
            return this;
        }

        public Runner setPairsGoldsteinDiffThreshold(Double val) {
            this.pairsGoldsteinDiffThreshold = val;
            return this;
        }

        public Runner setTriplesGoldsteinDiffThreshold(Double val) {
            this.triplesGoldsteinDiffThreshold = val;
            return this;
        }

        public Runner setGoldsteinDiffThreshold(Double val) {
            this.setSinglesGoldsteinDiffThreshold(val);
            this.setPairsGoldsteinDiffThreshold(val);
            this.setTriplesGoldsteinDiffThreshold(val);
            return this;
        }

        public Runner setTypeDependent(boolean val) {
            this.typeDependent = val;
            this.singlesThreshold = null;
            this.pairsThreshold = null;
            return this;
        }

        public Runner setNumIterations(int val) {
            this.numIterations = val;
            return this;
        }

        public Runner setSinglesPlugThreshold(double val) {
            this.singlesPlugThreshold = val;
            return this;
        }

        public Runner setPairsPlugThreshold(double val) {
            this.pairsPlugThreshold = val;
            return this;
        }

        public Runner setTriplesPlugThreshold(double val) {
            this.triplesPlugThreshold = val;
            return this;
        }

        public Runner setPlugThreshold(double val) {
            this.setSinglesPlugThreshold(val);
            this.setPairsPlugThreshold(val);
            this.setTriplesPlugThreshold(val);
            return this;
        }

        public Runner setSinglesTransitivePruning(boolean val) {
            this.singlesTransitivePruning = val;
            return this;
        }

        public Runner setPairsTransitivePruning(boolean val) {
            this.pairsTransitivePruning = val;
            return this;
        }

        public Runner setTriplesTransitivePruning(boolean val) {
            this.triplesTransitivePruning = val;
            return this;
        }

        public Runner setTransitivePruning(boolean val) {
            this.setSinglesTransitivePruning(val);
            this.setPairsTransitivePruning(val);
            this.setTriplesTransitivePruning(val);
            return this;
        }

        public Runner setShowProgress(boolean val) {
            this.showProgress = val;
            return this;
        }

        public Runner setCacheFile(File val) {
            this.cacheFile = val;
            return this;
        }

        public Runner setParallelism(Parallelism val) {
            this.parallelism = val;
            return this;
        }

        public PruningMatrix run(SimpleConfSpace confSpace, EnergyMatrix emat) {
            if (this.cacheFile != null) {
                return ObjectIO.readOrMake(this.cacheFile, PruningMatrix.class, "pruning matrix", pmat -> pmat.matches(confSpace), context -> this.reallyRun(confSpace, emat));
            }
            return this.reallyRun(confSpace, emat);
        }

        private PruningMatrix reallyRun(SimpleConfSpace confSpace, EnergyMatrix emat) {
            if (this.showProgress) {
                System.out.println("Running DEE...");
            }
            Reporter reporter = new Reporter(confSpace);
            PruningMatrix pmat = new PruningMatrix(confSpace);
            Consumer<String> maybeReport = prefix -> {
                if (this.showProgress) {
                    reporter.updateCounts(pmat);
                    reporter.report((String)prefix);
                }
            };
            if (this.singlesThreshold != null || this.pairsThreshold != null) {
                if (this.typeDependent) {
                    throw new IllegalArgumentException("threshold pruning can't be used with type dependence");
                }
                SimpleDEE dee = new SimpleDEE(confSpace, emat, pmat);
                if (this.singlesThreshold != null) {
                    dee.pruneSinglesByThreshold(this.singlesThreshold);
                    maybeReport.accept("Threshold Singles");
                }
                if (this.pairsThreshold != null) {
                    dee.prunePairsByThreshold(this.pairsThreshold);
                    maybeReport.accept("Threshold Pairs");
                }
                this.transitivePruning(confSpace, pmat, maybeReport);
            }
            if (this.singlesGoldsteinDiffThreshold != null || this.pairsGoldsteinDiffThreshold != null || this.triplesGoldsteinDiffThreshold != null) {
                if (this.showProgress) {
                    System.out.println("Choosing competitor residue conformations...");
                }
                PruningMatrix competitors = new PruningMatrix(pmat);
                SimpleDEE dee = new SimpleDEE(confSpace, emat, competitors);
                if (this.singlesGoldsteinDiffThreshold != null) {
                    dee.pruneSinglesGoldstein(0.0, this.typeDependent);
                }
                if (this.pairsGoldsteinDiffThreshold != null) {
                    dee.prunePairsGoldstein(0.0, this.typeDependent, this.parallelism);
                }
                if (this.triplesGoldsteinDiffThreshold != null) {
                    dee.pruneTriplesGoldstein(0.0, this.typeDependent, this.parallelism);
                    maybeReport.accept("Goldstein Triples");
                }
                dee = new SimpleDEE(confSpace, emat, pmat, competitors);
                for (int i = 0; i < this.numIterations; ++i) {
                    int numPrunedThisRound;
                    if (this.showProgress) {
                        System.out.println("DEE iteration " + (i + 1) + "...");
                    }
                    int numPruned = reporter.numSinglesPruned + reporter.numPairsPruned + reporter.numTriplesPruned;
                    if (this.singlesGoldsteinDiffThreshold != null) {
                        dee.pruneSinglesGoldstein(this.singlesGoldsteinDiffThreshold, this.typeDependent);
                        maybeReport.accept("Goldstein Singles");
                    }
                    if (this.pairsGoldsteinDiffThreshold != null) {
                        dee.prunePairsGoldstein(this.pairsGoldsteinDiffThreshold, this.typeDependent, this.parallelism);
                        maybeReport.accept("Goldstein Pairs");
                    }
                    if (this.triplesGoldsteinDiffThreshold != null) {
                        dee.pruneTriplesGoldstein(this.triplesGoldsteinDiffThreshold, this.typeDependent, this.parallelism);
                        maybeReport.accept("Goldstein Triples");
                    }
                    if ((numPrunedThisRound = reporter.numSinglesPruned + reporter.numPairsPruned + reporter.numTriplesPruned - numPruned) <= 0) break;
                }
                this.transitivePruning(confSpace, pmat, maybeReport);
            }
            if (this.singlesPlugThreshold != null || this.pairsPlugThreshold != null || this.triplesPlugThreshold != null) {
                if (this.showProgress) {
                    System.out.println("Pruning with PLUG...");
                }
                try (TaskExecutor tasks = this.parallelism.makeTaskExecutor();){
                    PLUG plug = new PLUG(confSpace);
                    if (this.singlesPlugThreshold != null) {
                        plug.pruneSingles(pmat, this.singlesPlugThreshold, tasks);
                        maybeReport.accept("PLUG Singles");
                    }
                    if (this.pairsPlugThreshold != null) {
                        plug.prunePairs(pmat, this.pairsPlugThreshold, tasks);
                        maybeReport.accept("PLUG Pairs");
                    }
                    if (this.triplesPlugThreshold != null) {
                        plug.pruneTriples(pmat, this.triplesPlugThreshold, tasks);
                        maybeReport.accept("PLUG Triples");
                    }
                }
                this.transitivePruning(confSpace, pmat, maybeReport);
            }
            if (this.showProgress) {
                BigInteger allConfs = new RCs(confSpace).getNumConformations();
                BigInteger unprunedLower = pmat.calcUnprunedConfsLowerBound();
                BigInteger unprunedUpper = pmat.calcUnprunedConfsUpperBound();
                BigInteger prunedLower = allConfs.subtract(unprunedUpper);
                BigInteger prunedUpper = allConfs.subtract(unprunedLower);
                double percentPrunedLower = 100.0 * prunedLower.doubleValue() / allConfs.doubleValue();
                double percentPrunedUpper = 100.0 * prunedUpper.doubleValue() / allConfs.doubleValue();
                Log.log("Conformations defined by conformation space:                           %s", Log.formatBig(allConfs));
                Log.log("Conformations pruned (by singles and pairs, bounds):                   [%s,%s]", Log.formatBig(prunedLower), Log.formatBig(prunedUpper));
                Log.log("Conformations remaining after pruning (by singles and pairs, bounds):  [%s,%s]", Log.formatBig(unprunedLower), Log.formatBig(unprunedUpper));
                Log.log("Percent conformations pruned (by singles and pairs, bounds):           [%.6f,%.6f]", percentPrunedLower, percentPrunedUpper);
            }
            return pmat;
        }

        private void transitivePruning(SimpleConfSpace confSpace, PruningMatrix pmat, Consumer<String> maybeReport) {
            if (this.singlesTransitivePruning || this.pairsTransitivePruning || this.triplesTransitivePruning) {
                if (this.showProgress) {
                    System.out.println("Transitive Pruning...");
                }
                try (TaskExecutor tasks = this.parallelism.makeTaskExecutor();){
                    TransitivePruner pruner = new TransitivePruner(confSpace);
                    if (this.singlesTransitivePruning) {
                        pruner.pruneSingles(pmat, tasks);
                        maybeReport.accept("Transitive Singles");
                    }
                    if (this.pairsTransitivePruning) {
                        pruner.prunePairs(pmat, tasks);
                        maybeReport.accept("Transitive Pairs");
                    }
                    if (this.triplesTransitivePruning) {
                        pruner.pruneTriples(pmat, tasks);
                        maybeReport.accept("Transitive Triples");
                    }
                }
            }
        }
    }

    private static class Reporter {
        int numSingles;
        int numPairs;
        int numTriples;
        int numSinglesPruned = 0;
        int numPairsPruned = 0;
        int numTriplesPruned = 0;
        int numSinglesPrunedThisRound = 0;
        int numPairsPrunedThisRound = 0;
        int numTriplesPrunedThisRound = 0;

        public Reporter(SimpleConfSpace confSpace) {
            this.numSingles = confSpace.getNumResConfs();
            this.numPairs = confSpace.getNumResConfPairs();
            this.numTriples = confSpace.getNumResConfTriples();
        }

        public void updateCounts(PruningMatrix pmat) {
            int newNumSinglesPruned = pmat.countPrunedRCs();
            this.numSinglesPrunedThisRound = newNumSinglesPruned - this.numSinglesPruned;
            this.numSinglesPruned = newNumSinglesPruned;
            int newNumPairsPruned = pmat.countPrunedPairs();
            this.numPairsPrunedThisRound = newNumPairsPruned - this.numPairsPruned;
            this.numPairsPruned = newNumPairsPruned;
            int newNumTriplesPruned = pmat.countPrunedTriples();
            this.numTriplesPrunedThisRound = newNumTriplesPruned - this.numTriplesPruned;
            this.numTriplesPruned = newNumTriplesPruned;
        }

        public void report(String prefix) {
            System.out.println(String.format("%30s: pruned %d singles,  %d/%d (%.1f%%) total", prefix, this.numSinglesPrunedThisRound, this.numSinglesPruned, this.numSingles, Float.valueOf(100.0f * (float)this.numSinglesPruned / (float)this.numSingles)));
            System.out.println(String.format("%30s: pruned %d pairs,    %d/%d (%.1f%%) total", "", this.numPairsPrunedThisRound, this.numPairsPruned, this.numPairs, Float.valueOf(100.0f * (float)this.numPairsPruned / (float)this.numPairs)));
            System.out.println(String.format("%30s: pruned %d triples,  %d/%d (%.1f%%) total", "", this.numTriplesPrunedThisRound, this.numTriplesPruned, this.numTriples, Float.valueOf(100.0f * (float)this.numTriplesPruned / (float)this.numTriples)));
        }

        public boolean prunedAnythingThisRound() {
            return this.numSinglesPrunedThisRound > 0 || this.numPairsPrunedThisRound > 0 || this.numTriplesPrunedThisRound > 0;
        }
    }
}

