/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.restypes.InterResBondingTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class HardCodedResidueInfo {
    public static String[] possibleBBAtoms = new String[]{"N", "H", "CA", "C", "O", "OXT", "H1", "H2", "H3"};
    public static Set<String> possibleBBAtomsLookup;
    public static LinkedHashMap<String, String> three2one;
    public static LinkedHashMap<String, String> one2three;

    public static void initThree2One() {
        three2one = new LinkedHashMap();
        three2one.put("ALA", "A");
        three2one.put("CYS", "C");
        three2one.put("ASP", "D");
        three2one.put("GLU", "E");
        three2one.put("PHE", "F");
        three2one.put("GLY", "G");
        three2one.put("HIS", "H");
        three2one.put("ILE", "I");
        three2one.put("LYS", "K");
        three2one.put("LEU", "L");
        three2one.put("MET", "M");
        three2one.put("ASN", "N");
        three2one.put("PRO", "P");
        three2one.put("GLN", "Q");
        three2one.put("ARG", "R");
        three2one.put("SER", "S");
        three2one.put("THR", "T");
        three2one.put("VAL", "V");
        three2one.put("TRP", "W");
        three2one.put("TYR", "Y");
    }

    public static String getOneLet(String aa3Name) {
        String res = three2one.get(aa3Name);
        if (res == null) {
            res = "X";
        }
        return res;
    }

    public static boolean canMutateTo(ResidueTemplate templ) {
        if (templ.templateRes.coords == null) {
            return false;
        }
        return HardCodedResidueInfo.hasAminoAcidBB(templ.templateRes);
    }

    public static ArrayList<String> listBBAtomsForMut(ResidueTemplate newTemplate, ResidueTemplate oldTemplate) {
        if (!HardCodedResidueInfo.canMutateTo(newTemplate)) {
            throw new UnsupportedOperationException("ERROR: Can't currently mutate to " + newTemplate.name);
        }
        ArrayList<String> ans = new ArrayList<String>();
        for (String atName : possibleBBAtoms) {
            if (newTemplate.templateRes.getAtomIndexByName(atName) == -1 || oldTemplate.templateRes.getAtomIndexByName(atName) == -1) continue;
            ans.add(atName);
        }
        return ans;
    }

    public static int[][] findMutAlignmentAtoms(ResidueTemplate template1, ResidueTemplate template2) {
        int[] mutAtoms1 = HardCodedResidueInfo.getTemplateMutAtoms(template1);
        int[] mutAtoms2 = HardCodedResidueInfo.getTemplateMutAtoms(template2);
        if (template1.name.equalsIgnoreCase("PRO") || template2.name.equalsIgnoreCase("PRO")) {
            mutAtoms1 = HardCodedResidueInfo.getTemplateProMutAtoms(template1);
            mutAtoms2 = HardCodedResidueInfo.getTemplateProMutAtoms(template2);
        }
        int[][] nArrayArray = new int[][]{mutAtoms1, mutAtoms2};
        int n = nArrayArray.length;
        for (int i = 0; i < n; ++i) {
            int[] ma;
            for (int atNum : ma = nArrayArray[i]) {
                if (atNum != -1) continue;
                throw new UnsupportedOperationException("ERROR: Mutation from " + template1.name + " to " + template2.name + " not supported yet");
            }
        }
        return new int[][]{mutAtoms1, mutAtoms2};
    }

    private static int[] getTemplateMutAtoms(ResidueTemplate template) {
        int N = template.templateRes.getAtomIndexByName("N");
        int CA = template.templateRes.getAtomIndexByName("CA");
        int C = template.templateRes.getAtomIndexByName("C");
        return new int[]{CA, N, C};
    }

    private static int[] getTemplateProMutAtoms(ResidueTemplate template) {
        int N = template.templateRes.getAtomIndexByName("N");
        int CA = template.templateRes.getAtomIndexByName("CA");
        if (template.name.equalsIgnoreCase("PRO")) {
            int CD = template.templateRes.getAtomIndexByName("CD");
            return new int[]{CA, N, CD};
        }
        int H = template.templateRes.getAtomIndexByName("H");
        return new int[]{CA, N, H};
    }

    public static double bondLengthUpperBound(int elementNum1, int elementNum2) {
        if (Math.min(elementNum1, elementNum2) == 1) {
            return Math.max(elementNum1, elementNum2) == 16 ? 1.5 : 1.2;
        }
        switch (elementNum1) {
            case 35: {
                return 2.4;
            }
            case 16: {
                return elementNum2 == 16 || elementNum2 == 35 ? 2.4 : 2.2;
            }
            case 15: 
            case 17: {
                return elementNum2 == 35 ? 2.4 : 2.2;
            }
        }
        switch (elementNum2) {
            case 35: {
                return 2.4;
            }
            case 15: 
            case 16: 
            case 17: {
                return 2.2;
            }
        }
        return 1.7;
    }

    public static InterResBondingTemplate inferInterResBonding(Residue res) {
        if (HardCodedResidueInfo.hasAminoAcidBB(res)) {
            if (res.fullName.startsWith("CYX")) {
                return new InterResBondingTemplate.CysteineBondingTemplate();
            }
            return new InterResBondingTemplate.PeptideBondingTemplate();
        }
        if (HardCodedResidueInfo.hasNucleicAcidBB(res)) {
            return new InterResBondingTemplate.NucleotideBondingTemplate();
        }
        return new InterResBondingTemplate.NoBondingTemplate();
    }

    public static boolean hasAminoAcidBB(Residue res) {
        return res.getAtomIndexByName("N") >= 0 && res.getAtomIndexByName("CA") >= 0 && res.getAtomIndexByName("C") >= 0;
    }

    public static boolean hasNucleicAcidBB(Residue res) {
        return res.getAtomIndexByName("P") >= 0 && res.getAtomIndexByName("O5'") >= 0 && res.getAtomIndexByName("C5'") >= 0 && res.getAtomIndexByName("C4'") >= 0 && res.getAtomIndexByName("C3'") >= 0 && res.getAtomIndexByName("O3'") >= 0;
    }

    public static String getTemplateName(Residue res) {
        String resName = res.fullName.substring(0, 3).trim();
        if (resName.equalsIgnoreCase("HIS")) {
            int HDCount = 0;
            int HECount = 0;
            for (Atom at : res.atoms) {
                if (at.name.contains("HD")) {
                    ++HDCount;
                    continue;
                }
                if (!at.name.contains("HE")) continue;
                ++HECount;
            }
            if (HDCount == 1 && HECount == 2) {
                return "HIE";
            }
            if (HDCount == 2 && HECount == 1) {
                return "HID";
            }
            if (HDCount == 2 && HECount == 2) {
                return "HIP";
            }
            throw new RuntimeException("ERROR: Invalid protonation state for " + res.fullName + ".  The residue may be partially disordered--please check it and consider deleting or rebuilding it if so.  ");
        }
        if (resName.equalsIgnoreCase("CYS")) {
            if (res.getAtomIndexByName("HG") >= 0) {
                return "CYS";
            }
            return "CYX";
        }
        return resName;
    }

    static {
        three2one = null;
        one2three = null;
        HardCodedResidueInfo.initThree2One();
        one2three = new LinkedHashMap();
        for (String threeLet : three2one.keySet()) {
            one2three.put(three2one.get(threeLet), threeLet);
        }
        possibleBBAtomsLookup = new HashSet<String>();
        for (String name : possibleBBAtoms) {
            possibleBBAtomsLookup.add(name);
        }
    }
}

