/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.restypes.InterResBondingTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ResidueTemplate
implements Serializable {
    private static final long serialVersionUID = 4568917747972477569L;
    public String name;
    public Residue templateRes;
    public InterResBondingTemplate interResBonding;
    public int numDihedrals = 0;
    public int[][] dihedral4Atoms;
    public ArrayList<ArrayList<Integer>> dihedralMovingAtoms;
    public int[][] numRotamers = null;
    double[][][][] rotamericDihedrals;
    public int numberOfPhiPsiBins = -1;
    public double phiPsiResolution = -1.0;
    public String CAEquivalent = null;

    public static ResidueTemplate makeFromResidueConfs(Residue ... residues) {
        return ResidueTemplate.makeFromResidueConfs(Arrays.asList(residues));
    }

    public static ResidueTemplate makeFromResidueConfs(List<Residue> residues) {
        Residue firstRes = residues.get(0);
        ResidueTemplate oldTemplate = firstRes.template;
        Residue templateRes = new Residue(firstRes);
        templateRes.copyIntraBondsFrom(firstRes);
        ResidueTemplate newTemplate = new ResidueTemplate(templateRes, oldTemplate.name, oldTemplate.interResBonding, oldTemplate.CAEquivalent);
        newTemplate.setNumberOfPhiPsiBins(oldTemplate.numberOfPhiPsiBins);
        newTemplate.initializeRotamerArrays();
        newTemplate.dihedral4Atoms = oldTemplate.dihedral4Atoms;
        newTemplate.numDihedrals = oldTemplate.numDihedrals;
        newTemplate.setNumRotamers(residues.size());
        double[][] dihedrals = new double[residues.size()][newTemplate.numDihedrals];
        for (int i = 0; i < residues.size(); ++i) {
            Residue res = residues.get(i);
            assert (res.template.numDihedrals == oldTemplate.numDihedrals);
            for (int j = 0; j < res.getNumDihedrals(); ++j) {
                dihedrals[i][j] = res.getDihedralAngle(j);
            }
        }
        newTemplate.setRotamericDihedrals(dihedrals);
        newTemplate.computeDihedralMovingAtoms();
        return newTemplate;
    }

    public ResidueTemplate(Residue res, String name, InterResBondingTemplate templ, String CAEquivalent) {
        this.templateRes = res;
        this.name = name;
        this.CAEquivalent = CAEquivalent;
        this.interResBonding = templ;
    }

    public int[] getDihedralDefiningAtoms(int dihedralNum) {
        return this.dihedral4Atoms[dihedralNum];
    }

    public ArrayList<Integer> getDihedralRotatedAtoms(int dihedralNum) {
        return this.dihedralMovingAtoms.get(dihedralNum);
    }

    public void computeDihedralMovingAtoms() {
        this.dihedralMovingAtoms = new ArrayList();
        for (int dihedNum = 0; dihedNum < this.numDihedrals; ++dihedNum) {
            ArrayList<Integer> movingAtoms = new ArrayList<Integer>();
            Atom atom2 = this.templateRes.atoms.get(this.dihedral4Atoms[dihedNum][1]);
            Atom atom3 = this.templateRes.atoms.get(this.dihedral4Atoms[dihedNum][2]);
            for (Atom atomBeyond : atom3.bonds) {
                if (atomBeyond == atom2) continue;
                this.movingAtomsDFS(atomBeyond, movingAtoms, this.dihedral4Atoms[dihedNum]);
            }
            this.dihedralMovingAtoms.add(movingAtoms);
        }
    }

    private void movingAtomsDFS(Atom atom, ArrayList<Integer> movingAtoms, int[] dihedAtoms) {
        if (atom == null) {
            throw new RuntimeException("ERROR: Trying to define non-free dihedral in rotamer library (bonds to another residue)");
        }
        int atomIndex = this.templateRes.getAtomIndexByName(atom.name);
        if (atomIndex == dihedAtoms[0] || atomIndex == dihedAtoms[1]) {
            throw new RuntimeException("ERROR: Trying to define non-free dihedral in rotamer library (dihedral is in a ring)");
        }
        if (atomIndex == dihedAtoms[2]) {
            return;
        }
        if (movingAtoms.contains(atomIndex)) {
            return;
        }
        movingAtoms.add(atomIndex);
        for (Atom distalAtom : atom.bonds) {
            this.movingAtomsDFS(distalAtom, movingAtoms, dihedAtoms);
        }
    }

    public double getRotamericDihedrals(double phi, double psi, int rotNum, int dihedralNum) {
        return this.getRotamericDihedrals(phi, psi, rotNum)[dihedralNum];
    }

    public double getRotamericDihedrals(int rotNum, int dihedralNum) {
        return this.getRotamericDihedrals(0.0, 0.0, rotNum, dihedralNum);
    }

    public double[] getRotamericDihedrals(int rotNum) {
        return this.getRotamericDihedrals(0.0, 0.0, rotNum);
    }

    public double[] getRotamericDihedrals(double phi, double psi, int rotNum) {
        if (Double.isNaN(phi) || Double.isNaN(psi)) {
            if (this.numberOfPhiPsiBins > 1) {
                throw new RuntimeException("ERROR: Can't use Dunbrack library on residues w/o phi/psi defined");
            }
            return this.rotamericDihedrals[0][0][rotNum];
        }
        int phiBin = (int)Math.round(phi / this.phiPsiResolution) + this.numberOfPhiPsiBins / 2;
        int psiBin = (int)Math.round(psi / this.phiPsiResolution) + this.numberOfPhiPsiBins / 2;
        return this.rotamericDihedrals[phiBin][psiBin][rotNum];
    }

    public int getNumRotamers(double phi, double psi) {
        if (this.numberOfPhiPsiBins == -1) {
            throw new RuntimeException("ERROR: Rotamers not set up for residue " + this.name);
        }
        if (Double.isNaN(phi) || Double.isNaN(psi)) {
            if (this.numberOfPhiPsiBins > 1) {
                throw new RuntimeException("ERROR: Can't use Dunbrack library on residues w/o phi/psi defined");
            }
            return this.numRotamers[0][0];
        }
        int phiBin = (int)Math.round(phi / this.phiPsiResolution) + this.numberOfPhiPsiBins / 2;
        int psiBin = (int)Math.round(psi / this.phiPsiResolution) + this.numberOfPhiPsiBins / 2;
        return this.numRotamers[phiBin][psiBin];
    }

    public int getNumRotamers() {
        return this.getNumRotamers(0.0, 0.0);
    }

    public void setNumberOfPhiPsiBins(int numberOfPhiPsiBins) {
        this.numberOfPhiPsiBins = numberOfPhiPsiBins;
    }

    public void setRLphiPsiResolution(double phiPsiResolution) {
        this.phiPsiResolution = phiPsiResolution;
    }

    public void initializeRotamerArrays() {
        assert (this.numberOfPhiPsiBins > 0);
        this.numRotamers = new int[this.numberOfPhiPsiBins][];
        this.rotamericDihedrals = new double[this.numberOfPhiPsiBins][][][];
        for (int i = 0; i < this.numberOfPhiPsiBins; ++i) {
            this.numRotamers[i] = new int[this.numberOfPhiPsiBins];
            this.rotamericDihedrals[i] = new double[this.numberOfPhiPsiBins][][];
        }
    }

    public void setNumRotamers(int numRotamers, int phiBin, int psiBin) {
        this.numRotamers[phiBin][psiBin] = numRotamers;
    }

    public void setNumRotamers(int numRotamers) {
        this.setNumRotamers(numRotamers, 0, 0);
    }

    public void setNumDihedrals(int numDihedrals) {
        this.numDihedrals = numDihedrals;
    }

    public void setRotamericDihedrals(double[][] newRotamericDihedrals, int phiBin, int psiBin) {
        this.rotamericDihedrals[phiBin][psiBin] = newRotamericDihedrals;
    }

    public void setRotamericDihedrals(double[][] newRotamericDihedrals) {
        this.setRotamericDihedrals(newRotamericDihedrals, 0, 0);
    }

    public String toString() {
        return this.name + ":" + System.identityHashCode(this);
    }

    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append(" [");
        buf.append(String.join((CharSequence)",", this.templateRes.atoms.stream().map(atom -> atom.name).collect(Collectors.toList())));
        buf.append("]");
        return buf.toString();
    }
}

