/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.StringParsing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TemplateCoordsParser {
    public final List<ResidueTemplate> templates;

    public TemplateCoordsParser(List<ResidueTemplate> templates) {
        this.templates = templates;
    }

    public void parse(String text) {
        Iterator<String> lines = FileTools.parseLines(text).iterator();
        String curLine = lines.next();
        if (curLine == null) {
            return;
        }
        while (curLine.startsWith("#") || curLine.isEmpty()) {
            curLine = lines.next();
        }
        while (curLine != null) {
            String resName = StringParsing.getToken(curLine, 1);
            int numAtoms = Integer.parseInt(StringParsing.getToken(curLine, 2));
            ArrayList<AtomicCoord> curTemplateCoords = new ArrayList<AtomicCoord>();
            for (int i = 0; i < numAtoms; ++i) {
                curTemplateCoords.add(new AtomicCoord(this, lines.next()));
            }
            boolean foundRes = false;
            for (ResidueTemplate template : this.templates) {
                if (!template.name.equalsIgnoreCase(resName)) continue;
                Residue r = template.templateRes;
                if (r.atoms.size() != numAtoms) continue;
                boolean atomNamesMatch = true;
                for (AtomicCoord atCoord : curTemplateCoords) {
                    if (r.getAtomByName(atCoord.atomName) != null) continue;
                    atomNamesMatch = false;
                }
                if (!atomNamesMatch) continue;
                foundRes = true;
                r.coords = new double[3 * numAtoms];
                for (AtomicCoord atCoord : curTemplateCoords) {
                    atCoord.copyToResidue(r);
                }
            }
            if (!foundRes) {
                System.out.println("WARNING: Template coordinates for " + resName + " did not match any template");
            }
            curLine = lines.next();
            curLine = lines.next();
        }
    }

    public static String writeTemplateCoords(Residue res, String templateName) {
        StringBuilder sb = new StringBuilder();
        sb.append(templateName + " " + res.atoms.size() + "\n");
        for (Atom at : res.atoms) {
            double[] coords = at.getCoords();
            sb.append(at.name);
            for (double c : coords) {
                sb.append(" " + c);
            }
            sb.append("\n");
        }
        sb.append("ENDRES\n");
        return sb.toString();
    }

    private class AtomicCoord {
        String atomName;
        double[] coords = new double[3];

        AtomicCoord(TemplateCoordsParser templateCoordsParser, String line) {
            this.atomName = StringParsing.getToken(line, 1);
            for (int dim = 0; dim < 3; ++dim) {
                this.coords[dim] = Double.parseDouble(StringParsing.getToken(line, dim + 2));
            }
        }

        void copyToResidue(Residue r) {
            int rAtomIndex = r.getAtomIndexByName(this.atomName);
            System.arraycopy(this.coords, 0, r.coords, 3 * rAtomIndex, 3);
        }
    }
}

