/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.MapDBTools;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class RCDB
implements AutoCloseable {
    public final MultiStateConfSpace confSpace;
    public final MathContext mathContext;
    public final File file;
    private final DB db;
    private final Map<String, Table> tables = new HashMap<String, Table>();

    public RCDB(MultiStateConfSpace confSpace, MathContext mathContext) {
        this(confSpace, mathContext, null);
    }

    public RCDB(MultiStateConfSpace confSpace, MathContext mathContext, File file) {
        this.confSpace = confSpace;
        this.mathContext = mathContext;
        this.file = file;
        this.db = file != null ? DBMaker.fileDB((File)file).fileMmapEnableIfSupported().closeOnJvmShutdown().make() : DBMaker.memoryDB().make();
    }

    @Override
    public void close() {
        this.db.close();
    }

    public BigMath bigMath() {
        return new BigMath(this.mathContext);
    }

    public Table table(MultiStateConfSpace.State state, Sequence seq) {
        String id = String.format("%d[%s]", state.index, seq.toString(Sequence.Renderer.ResType));
        return this.tables.computeIfAbsent(id, key -> new Table(state, seq, id));
    }

    public void addZSumUpper(MultiStateConfSpace.State state, Sequence seq, int[] conf, int pos, BigDecimal zSumUpper) {
        this.table(state, seq).addZSumUpper(pos, conf[pos], zSumUpper);
    }

    public void subZSumUpper(MultiStateConfSpace.State state, Sequence seq, int[] conf, int pos, BigDecimal zSumUpper) {
        this.table(state, seq).subZSumUpper(pos, conf[pos], zSumUpper);
    }

    public void addZPath(MultiStateConfSpace.State state, Sequence seq, int[] conf, int pos, BigDecimal zPath, BigDecimal zSumUpper) {
        this.table(state, seq).addZPath(conf, pos, zPath, zSumUpper);
    }

    public MathTools.BigDecimalBounds getZSumBounds(MultiStateConfSpace.State state, Sequence seq, int pos, int rc) {
        MathTools.BigDecimalBounds zSumBounds = this.table(state, seq).getZSumBounds(pos, rc);
        BigMath upper = this.bigMath().set(zSumBounds.upper);
        this.forEachPartialSequence(seq, partialSeq -> {
            MathTools.BigDecimalBounds partialZSumBounds = this.table(state, (Sequence)partialSeq).getZSumBounds(pos, rc);
            upper.add(partialZSumBounds.upper);
        });
        return new MathTools.BigDecimalBounds(zSumBounds.lower, upper.get());
    }

    public MathTools.BigDecimalBounds getZSumBounds(MultiStateConfSpace.State state, Sequence seq, SimpleConfSpace.Position pos, SimpleConfSpace.ResidueConf rc) {
        return this.getZSumBounds(state, seq, pos.index, rc.index);
    }

    public MathTools.DoubleBounds getGBounds(MultiStateConfSpace.State state, Sequence seq, SimpleConfSpace.Position pos, SimpleConfSpace.ResidueConf rc, MathContext mathContext) {
        BoltzmannCalculator bcalc = new BoltzmannCalculator(mathContext);
        return bcalc.freeEnergyPrecise(this.getZSumBounds(state, seq, pos, rc));
    }

    private void forEachPartialSequence(Sequence seq, Consumer<Sequence> block) {
        Sequence parentSeq = seq.copy();
        for (int i = seq.countAssignments() - 1; i >= 0; --i) {
            parentSeq.rtIndices[i] = -1;
            block.accept(parentSeq);
        }
    }

    public void commit() {
        this.db.commit();
    }

    public class Table {
        public final MultiStateConfSpace.State state;
        public final Sequence seq;
        public final String id;
        private final int[][] rcIds;
        private final HTreeMap<Integer, MathTools.BigDecimalBounds> map;

        public Table(MultiStateConfSpace.State state, Sequence seq, String id) {
            this.state = state;
            this.seq = seq;
            this.id = id;
            this.rcIds = new int[state.confSpace.numPos()][];
            int nextId = 0;
            for (int posi = 0; posi < state.confSpace.numPos(); ++posi) {
                this.rcIds[posi] = new int[state.confSpace.numConf(posi)];
                for (int confi = 0; confi < state.confSpace.numConf(posi); ++confi) {
                    this.rcIds[posi][confi] = nextId++;
                }
            }
            this.map = RCDB.this.db.hashMap(id).keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)new MapDBTools.BigDecimalBoundsSerializer()).createOrOpen();
        }

        private int getId(int pos, int rc) {
            return this.rcIds[pos][rc];
        }

        public MathTools.BigDecimalBounds getZSumBounds(int pos, int rc) {
            MathTools.BigDecimalBounds sum = (MathTools.BigDecimalBounds)this.map.get((Object)this.getId(pos, rc));
            if (sum == null) {
                sum = new MathTools.BigDecimalBounds(BigDecimal.ZERO, BigDecimal.ZERO);
            }
            return sum;
        }

        private boolean isZero(MathTools.BigDecimalBounds bounds) {
            return MathTools.isZero(bounds.lower) && MathTools.isZero(bounds.upper);
        }

        public void update(int pos, int rc, Consumer<MathTools.BigDecimalBounds> updater) {
            MathTools.BigDecimalBounds sum = this.getZSumBounds(pos, rc);
            updater.accept(sum);
            if (this.isZero(sum)) {
                this.map.remove((Object)this.getId(pos, rc));
            } else {
                this.map.put((Object)this.getId(pos, rc), (Object)sum);
            }
        }

        public void addZSumUpper(int pos, int rc, BigDecimal zSumUpper) {
            if (!MathTools.isFinite(zSumUpper)) {
                throw new IllegalArgumentException("Z must be finite: " + String.valueOf(zSumUpper));
            }
            this.update(pos, rc, sum -> {
                sum.upper = RCDB.this.bigMath().set(sum.upper).add(zSumUpper).get();
            });
        }

        public void subZSumUpper(int pos, int rc, BigDecimal zSumUpper) {
            if (!MathTools.isFinite(zSumUpper)) {
                throw new IllegalArgumentException("Z must be finite: " + String.valueOf(zSumUpper));
            }
            this.update(pos, rc, sum -> {
                sum.upper = RCDB.this.bigMath().set(sum.upper).sub(zSumUpper).get();
            });
        }

        public void addZPath(int[] conf, int pos, BigDecimal zPath, BigDecimal zSumUpper) {
            if (!MathTools.isFinite(zPath) || !MathTools.isFinite(zSumUpper)) {
                throw new IllegalArgumentException("Z must be finite: " + String.valueOf(zPath) + ", " + String.valueOf(zSumUpper));
            }
            for (int posi = 0; posi < this.state.confSpace.numPos(); ++posi) {
                int rc = conf[posi];
                this.update(posi, rc, sum -> {
                    sum.lower = RCDB.this.bigMath().set(sum.lower).add(zPath).get();
                    sum.upper = RCDB.this.bigMath().set(sum.upper).add(zPath).get();
                });
            }
            this.update(pos, conf[pos], sum -> {
                sum.upper = RCDB.this.bigMath().set(sum.upper).sub(zSumUpper).get();
            });
        }
    }
}

