/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.structure.analysis.SmallAngleVoxel;
import edu.duke.cs.osprey.tools.Protractor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Function;

public class ClusterS1 {
    private final TreeSet<Double> angles = new TreeSet();

    public void add(double a) {
        this.angles.add(a);
    }

    public SmallAngleVoxel.Interval bounds() {
        SmallAngleVoxel.Interval bounds = new SmallAngleVoxel.Interval(this.angles.first());
        for (double a : this.angles) {
            bounds.expand(a);
        }
        return bounds;
    }

    public double mean(SmallAngleVoxel.Interval bounds) {
        double sum = 0.0;
        for (double a : this.angles) {
            sum += bounds.center + Protractor.getDeltaDegrees(bounds.center, a);
        }
        return Protractor.normalizeDegrees(sum / (double)this.angles.size());
    }

    public double mode(SmallAngleVoxel.Interval bounds, int numBuckets) {
        double min = bounds.min();
        double width = bounds.size();
        Function<Double, Integer> angleToBucket = a -> {
            double deltaMin = Protractor.getDeltaDegrees(bounds.center, a) - bounds.less;
            return (int)(deltaMin * (double)numBuckets / width);
        };
        Function<Integer, Double> bucketToAngle = i -> Protractor.normalizeDegrees(width * (double)i.intValue() / (double)numBuckets + min);
        int[] counts = new int[numBuckets];
        Arrays.fill(counts, 0);
        for (double a2 : this.angles) {
            int i2 = angleToBucket.apply(a2);
            if (i2 < 0 || i2 >= numBuckets) continue;
            int n = i2;
            counts[n] = counts[n] + 1;
        }
        int bucket = 0;
        int maxCount = 0;
        for (int i3 = 0; i3 < numBuckets; ++i3) {
            if (counts[i3] <= maxCount) continue;
            maxCount = counts[i3];
            bucket = i3;
        }
        return bucketToAngle.apply(bucket);
    }

    public double medoid() {
        double minScore = Double.POSITIVE_INFINITY;
        Double bestAngle = null;
        double[] fastAngles = new double[this.angles.size()];
        int i = 0;
        Iterator<Double> iterator2 = this.angles.iterator();
        while (iterator2.hasNext()) {
            double a = iterator2.next();
            fastAngles[i++] = a;
        }
        for (Object a1 : (Iterator<Double>)fastAngles) {
            double score = 0.0;
            for (double a2 : fastAngles) {
                double d = Protractor.getDistDegrees((double)a1, a2);
                score += d * d;
            }
            if (!(score < minScore)) continue;
            minScore = score;
            bestAngle = (double)a1;
        }
        assert (bestAngle != null);
        return bestAngle;
    }

    public class Stats {
        public final ClusterS1 cluster;
        public final SmallAngleVoxel.Interval bounds;
        public final double mean;
        public final double mode;

        public Stats(double modeIncludesPercent, int modeBuckets) {
            this.cluster = ClusterS1.this;
            this.bounds = ClusterS1.this.bounds();
            this.mean = ClusterS1.this.mean(this.bounds);
            this.mode = ClusterS1.this.mode(this.getInterval(this.mean, modeIncludesPercent), modeBuckets);
        }

        public SmallAngleVoxel.Interval getInterval(double center, double includePercent) {
            int numNeg = 0;
            int numPos = 0;
            for (double a : ClusterS1.this.angles) {
                double delta = Protractor.getDeltaDegrees(center, a);
                if (delta < 0.0) {
                    ++numNeg;
                    continue;
                }
                if (!(delta > 0.0)) continue;
                ++numPos;
            }
            double skipRatio = 1.0 - includePercent / 100.0;
            int numNegToSkip = (int)((double)numNeg * skipRatio);
            int numPosToSkip = (int)((double)numPos * skipRatio);
            SmallAngleVoxel.Interval interval = new SmallAngleVoxel.Interval(center);
            int count = 0;
            for (double a : ClusterS1.this.angles) {
                if (count++ <= numNegToSkip) continue;
                interval.less = Protractor.getDeltaDegrees(center, a);
                break;
            }
            count = 0;
            for (double a : ClusterS1.this.angles.descendingSet()) {
                if (count++ <= numPosToSkip) continue;
                interval.more = Protractor.getDeltaDegrees(center, a);
                break;
            }
            return interval;
        }
    }
}

