/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.tools.MathTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DegreesHistogram {
    public final int numAngles;
    public final Map<Long, Integer> buckets = new TreeMap<Long, Integer>();
    public static final String[] AngleLadder = new String[]{"-1        -1        -1        -1        -1        -1        -1        -1        -1                                                                                                                                                                                                       1         1         1         1         1         1         1         1        1 ", " 8         7         6         5         4         3         2         1         0        -9        -8        -7        -6        -5        -4        -3        -2        -1                   1         2         3         4         5         6         7         8         9         0         1         2         3         4         5         6         7        7 ", "[098765432109876543210987654321098765432109876543210987654321098765432109876543210987654321098765432109876543210987654321098765432109876543210987654321098765432109876543210987654321012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789]"};

    public DegreesHistogram(int numAngles) {
        if (numAngles > 7) {
            throw new IllegalArgumentException("only up to 7 angles supported");
        }
        this.numAngles = numAngles;
    }

    private static int getNumAngles(Collection<double[]> angles) {
        if (angles.isEmpty()) {
            return 0;
        }
        return angles.iterator().next().length;
    }

    public DegreesHistogram(Collection<double[]> angles) {
        this(DegreesHistogram.getNumAngles(angles));
        this.addAll(angles);
    }

    public void add(double[] angles) {
        this.buckets.merge(this.getIndex(angles), 1, (a, b) -> a + b);
    }

    public void addAll(Collection<double[]> angles) {
        for (double[] a : angles) {
            this.add(a);
        }
    }

    public long getIndex(double[] angles) {
        long i = 0L;
        for (int d = 0; d < this.numAngles; ++d) {
            if (d > 0) {
                i <<= 9;
            }
            i |= (long)((int)Math.floor(angles[d]) + 180);
        }
        return i;
    }

    public long getIndexDelta(int d) {
        long delta = 1L;
        for (int i = this.numAngles - 1; i > d; --i) {
            delta <<= 9;
        }
        return delta;
    }

    private int project(long index, int d) {
        return (int)(index >> 9 * (this.numAngles - d - 1)) & 0x1FF;
    }

    public int count() {
        int count = 0;
        for (int c : this.buckets.values()) {
            count += c;
        }
        return count;
    }

    public double[] makeDihedrals(long key) {
        double[] dihedrals = new double[this.numAngles];
        for (int d = this.numAngles - 1; d >= 0; --d) {
            long i = key & 0x1FFL;
            key >>= 9;
            dihedrals[d] = i - 180L;
        }
        return dihedrals;
    }

    public boolean hasBucket(double[] angles) {
        return this.buckets.containsKey(this.getIndex(angles));
    }

    public int[] getCounts(int d) {
        int[] out = new int[360];
        Arrays.fill(out, 0);
        for (Map.Entry<Long, Integer> bucket : this.buckets.entrySet()) {
            int n = this.project(bucket.getKey(), d);
            out[n] = out[n] + bucket.getValue();
        }
        return out;
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append("angles: ");
        buf.append(this.count());
        buf.append("   buckets filled: ");
        buf.append(this.buckets.size());
        buf.append("\n    ");
        buf.append(AngleLadder[0]);
        buf.append("\n    ");
        buf.append(AngleLadder[1]);
        buf.append("\n    ");
        buf.append(AngleLadder[2]);
        for (int d = 0; d < this.numAngles; ++d) {
            buf.append("\n ");
            buf.append(d);
            buf.append("  ");
            buf.append(this.dump(d));
        }
        return buf.toString();
    }

    public String dump(int d) {
        int[] counts = this.getCounts(d);
        int max = 0;
        for (int count : counts) {
            max = Math.max(max, count);
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int count : counts) {
            if (max <= 0) {
                buf.append(" ");
                continue;
            }
            double n = 1.0 * (double)count / (double)max;
            if (n <= 0.0) {
                buf.append(' ');
                continue;
            }
            if (n < 0.1) {
                buf.append('_');
                continue;
            }
            if (n < 0.5) {
                buf.append('.');
                continue;
            }
            if (n < 0.75) {
                buf.append('o');
                continue;
            }
            if (n < 1.0) {
                buf.append('8');
                continue;
            }
            if (n >= 1.0) {
                buf.append('|');
                continue;
            }
            if (Double.isNaN(n)) {
                buf.append('N');
                continue;
            }
            buf.append('?');
        }
        buf.append("]");
        return buf.toString();
    }

    public void filterDensityWindow(int radiusDegrees, int thresholdCount) {
        int widthDegrees = radiusDegrees * 2 + 1;
        int[] widths = new int[this.numAngles];
        Arrays.fill(widths, widthDegrees);
        ArrayList<Long> bucketsToRemove = new ArrayList<Long>();
        for (Map.Entry<Long, Integer> bucket : this.buckets.entrySet()) {
            int windowCount = 0;
            for (int[] indices : new MathTools.GridIterable(widths)) {
                long index = bucket.getKey();
                for (int d = 0; d < this.numAngles; ++d) {
                    index += this.getIndexDelta(d) * (long)(indices[d] - radiusDegrees);
                }
                windowCount += this.buckets.getOrDefault(index, 0).intValue();
            }
            if (windowCount >= thresholdCount) continue;
            bucketsToRemove.add(bucket.getKey());
        }
        Iterator<Map.Entry<Long, Integer>> iterator2 = bucketsToRemove.iterator();
        while (iterator2.hasNext()) {
            long key = (Long)((Object)iterator2.next());
            this.buckets.remove(key);
        }
    }
}

