/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import java.util.Arrays;
import java.util.Collection;

public class Histogram {
    public final int numData;
    public final int[] counts;
    public final double[] boundaries;

    public Histogram(Collection<Double> data, int numBuckets) {
        if (data.size() <= 0) {
            throw new IllegalArgumentException("no data");
        }
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("wrong number of buckets: " + numBuckets);
        }
        this.numData = data.size();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double d : data) {
            min = Math.min(min, d);
            max = Math.max(max, d);
        }
        this.counts = new int[numBuckets];
        this.boundaries = new double[numBuckets + 1];
        this.boundaries[0] = min;
        this.boundaries[numBuckets] = max;
        for (int i = 1; i < numBuckets; ++i) {
            this.boundaries[i] = min + (max - min) * (double)i / (double)numBuckets;
        }
        Arrays.fill(this.counts, 0);
        for (double d : data) {
            int n = this.findBucket(d);
            this.counts[n] = this.counts[n] + 1;
        }
    }

    private int findBucket(double d) {
        for (int i = 1; i < this.boundaries.length; ++i) {
            if (!(d < this.boundaries[i])) continue;
            return i - 1;
        }
        return this.counts.length - 1;
    }

    public String toString() {
        return this.toString(4, 1, 20);
    }

    public String toString(int size, int precision, int barLength) {
        int maxCount = 0;
        int countLength = 0;
        for (int count : this.counts) {
            maxCount = Math.max(maxCount, count);
            countLength = Math.max(countLength, Integer.toString(count).length());
        }
        String dataFormat = "%" + size + "." + precision + "f";
        String bucketFormat = "Bucket [" + dataFormat + "," + dataFormat + "] %" + countLength + "d  ";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.counts.length; ++i) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(String.format(bucketFormat, this.boundaries[i], this.boundaries[i + 1], this.counts[i]));
            int numSegments = this.counts[i] * barLength / maxCount;
            for (int j = 0; j < barLength; ++j) {
                if (j < numSegments) {
                    buf.append('-');
                    continue;
                }
                buf.append(' ');
            }
        }
        return buf.toString();
    }
}

