/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.confspace.VoxelShape;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomConnectivity;
import edu.duke.cs.osprey.structure.Probe;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.analysis.ClusterR1;
import edu.duke.cs.osprey.structure.analysis.ClusterS1;
import edu.duke.cs.osprey.structure.analysis.MeasurementLibrary;
import edu.duke.cs.osprey.structure.analysis.PDBScanner;
import edu.duke.cs.osprey.structure.analysis.SmallAngleVoxel;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Protractor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TemplateChooser {
    private static final MeasurementLibrary mlib = new MeasurementLibrary();

    public static void main(String[] args) {
        MeasuredRes mres;
        File dir = new File(args[0]);
        List<String> expectedTypes = Arrays.asList("ARG", "HIP", "HID", "HIE", "LYS", "ASP", "GLU", "CYS", "GLY", "PRO", "ALA", "VAL", "ILE", "LEU", "MET", "PHE", "TYR", "TRP", "SER", "THR", "ASN", "GLN");
        Map<String, List<MeasuredRes>> measurementsByType = TemplateChooser.measureResidues(dir, expectedTypes);
        Log.log("calculating modal values...", new Object[0]);
        Map<String, double[]> modesByType = TemplateChooser.calcModes(measurementsByType, expectedTypes);
        DistanceFunction measurementDist = (measurements, a, b) -> {
            double dist = 0.0;
            block4: for (int m = 0; m < measurements.size(); ++m) {
                switch (((MeasurementLibrary.Measurement)measurements.get((int)m)).space) {
                    case R: {
                        dist += Math.abs(a[m] - b[m]);
                        continue block4;
                    }
                    case S: {
                        dist += Protractor.getDistDegrees(a[m], b[m]) / 10.0;
                    }
                }
            }
            return 100.0 * dist / (double)measurements.size();
        };
        ResidueTemplateLibrary templateLib = new ResidueTemplateLibrary.Builder().build();
        Probe probe = new Probe();
        probe.matchTemplates(templateLib);
        Log.logf("building atom connectivity...", new Object[0]);
        AtomConnectivity connectivity = new AtomConnectivity.Builder().set15HasNonBonded(false).build();
        Log.log(" done!", new Object[0]);
        BiFunction<Residue, String, Double> rmsViolations = (res, resType) -> {
            res.assignTemplateSimple(templateLib, (String)resType);
            if (res.template == null) {
                return Double.POSITIVE_INFINITY;
            }
            ArrayList violations = new ArrayList();
            Runnable collectViolations = () -> probe.getInteractions((Residue)res, connectivity).stream().mapToDouble(inter -> inter.getViolation(0.0)).filter(v -> v > 0.0).forEach(v -> violations.add(v));
            if (res.template.getNumRotamers() <= 0) {
                collectViolations.run();
            } else {
                VoxelShape.Rect voxel = new VoxelShape.Rect();
                List<DegreeOfFreedom> dofs = ((VoxelShape)voxel).makeDihedralDOFs((Residue)res);
                for (int i = 0; i < res.template.getNumRotamers(); ++i) {
                    ObjectiveFunction.DofBounds dofBounds = ((VoxelShape)voxel).makeDihedralBounds(res.template, i);
                    for (int d = 0; d < dofs.size(); ++d) {
                        dofs.get(d).apply(dofBounds.getCenter(d));
                    }
                    collectViolations.run();
                }
            }
            if (violations.isEmpty()) {
                return 0.0;
            }
            double sum = 0.0;
            Iterator iterator2 = violations.iterator();
            while (iterator2.hasNext()) {
                double v = (Double)iterator2.next();
                sum += v * v;
            }
            return Math.sqrt(sum / (double)violations.size());
        };
        Log.log("finding ideal residues...", new Object[0]);
        HashMap idealResidues = new HashMap();
        TemplateChooser.scanResidues(dir, (filename, res, type) -> {
            if (res.getAtomByName("H3") != null || res.getAtomByName("OXT") != null) {
                return;
            }
            double[] measurements = mlib.measure(res, type);
            if (measurements == null) {
                return;
            }
            double rmsViolation = (Double)rmsViolations.apply(res, type);
            MeasuredRes oldMres = (MeasuredRes)idealResidues.get(type);
            if (oldMres == null) {
                idealResidues.put(type, new MeasuredRes(filename, res.getPDBResNumber(), measurements, rmsViolation));
            } else {
                double idealWeight = 1.0;
                double probeWeight = 12.0;
                List<MeasurementLibrary.Measurement> libMeasurements = mlib.get(type);
                double[] modes = (double[])modesByType.get(type);
                double oldDist = measurementDist.calc(libMeasurements, modes, oldMres.measurements) * 1.0 + oldMres.rmsViolation * 12.0;
                double newDist = measurementDist.calc(libMeasurements, modes, measurements) * 1.0 + rmsViolation * 12.0;
                if (newDist < oldDist) {
                    idealResidues.put(type, new MeasuredRes(filename, res.getPDBResNumber(), measurements, rmsViolation));
                }
            }
        });
        for (String type2 : expectedTypes) {
            mres = (MeasuredRes)idealResidues.get(type2);
            int count = measurementsByType.get(type2).size();
            List<MeasurementLibrary.Measurement> measurements2 = mlib.get(type2);
            double[] modes = modesByType.get(type2);
            double dist = measurementDist.calc(measurements2, modes, mres.measurements);
            ResidueTemplate template = templateLib.getTemplate(type2, true);
            double[] templateMeasurements = mlib.measure(template.templateRes, type2);
            double templateDist = measurementDist.calc(measurements2, modes, templateMeasurements);
            double templateRmsViolation = rmsViolations.apply(template.templateRes, type2);
            Log.log("%s: %s %s   n=%7d   thisd=%8.4f   currentd=%8.4f   thisRmsV=%5.3f   currentRmsV=%5.3f", type2, mres.filename, mres.resNum, count, dist, templateDist, mres.rmsViolation, templateRmsViolation);
            for (int m = 0; m < measurements2.size(); ++m) {
                MeasurementLibrary.Measurement measurement = measurements2.get(m);
                Log.logf("%30s  ", measurement.name);
                switch (measurement.space) {
                    case R: {
                        Log.logf("mode=%6.3f  this=%6.3f d=%6.3f  current=%6.3f d=%6.3f  delta=%6.3f", modes[m], mres.measurements[m], Math.abs(modes[m] - mres.measurements[m]), templateMeasurements[m], Math.abs(modes[m] - templateMeasurements[m]), Math.abs(mres.measurements[m] - templateMeasurements[m]));
                        break;
                    }
                    case S: {
                        Log.logf("mode=%6.1f  this=%6.1f d=%6.1f  current=%6.1f d=%6.1f  delta=%6.1f", modes[m], mres.measurements[m], Protractor.getDistDegrees(modes[m], mres.measurements[m]), templateMeasurements[m], Protractor.getDistDegrees(modes[m], templateMeasurements[m]), Protractor.getDistDegrees(mres.measurements[m], templateMeasurements[m]));
                    }
                }
                Log.log("", new Object[0]);
            }
        }
        Log.log("template coords:", new Object[0]);
        for (String type2 : expectedTypes) {
            mres = (MeasuredRes)idealResidues.get(type2);
            new PDBScanner(dir, new String[0]).scan(mres.filename, (file, mol) -> {
                Residue res = mol.getResByPDBResNumber(mres.resNum);
                Log.log("%s %d", TemplateChooser.getResType(res), res.atoms.size());
                for (Atom atom : res.atoms) {
                    int i3 = atom.indexInRes * 3;
                    Log.log("%s  %.3ff  %.3ff  %.3ff", atom.name, res.coords[i3], res.coords[i3 + 1], res.coords[i3 + 2]);
                }
                Log.log("ENDRES", new Object[0]);
            });
        }
    }

    public static Map<String, List<MeasuredRes>> measureResidues(File dir, Collection<String> types2) {
        return TemplateChooser.measureResidues(dir, types2, res -> true);
    }

    public static Map<String, List<MeasuredRes>> measureResidues(File dir, Collection<String> types2, Predicate<Residue> filter) {
        HashMap<String, List<MeasuredRes>> measurementsByType = new HashMap<String, List<MeasuredRes>>();
        TemplateChooser.scanResidues(dir, (filename, res, type) -> {
            if (!types2.contains(type)) {
                return;
            }
            double[] measurements = mlib.measure(res, type);
            if (measurements == null) {
                return;
            }
            if (!filter.test(res)) {
                return;
            }
            for (double measurement : measurements) {
                if (Double.isFinite(measurement)) continue;
                List<MeasurementLibrary.Measurement> libMeasurements = mlib.get(type);
                StringBuilder buf = new StringBuilder();
                buf.append(String.format("invalid measurements for %s %s %s, this is a bug!", filename, res.getPDBResNumber(), type));
                for (int m = 0; m < measurements.length; ++m) {
                    buf.append(String.format("\n\t%28s: %8.3f", libMeasurements.get((int)m).name, measurements[m]));
                }
                throw new Error(buf.toString());
            }
            measurementsByType.computeIfAbsent(type, t -> new ArrayList()).add(new MeasuredRes(filename, res.getPDBResNumber(), measurements, Double.NaN));
        });
        return measurementsByType;
    }

    public static Map<String, double[]> calcModes(Map<String, List<MeasuredRes>> measurementsByType, List<String> types2) {
        boolean foundAllExpected = true;
        HashMap<String, double[]> modesByType = new HashMap<String, double[]>();
        for (String type2 : types2) {
            List<MeasuredRes> measuredResidues = measurementsByType.get(type2);
            if (measuredResidues == null) {
                Log.log("%s: no samples! are the measurements wrong?", type2);
                foundAllExpected = false;
                continue;
            }
            Log.log("%s: %d samples", type2, measuredResidues.size());
            List<MeasurementLibrary.Measurement> measurements = mlib.get(type2);
            double[] modes = new double[measurements.size()];
            Arrays.fill(modes, Double.NaN);
            for (int m = 0; m < measurements.size(); ++m) {
                MeasurementLibrary.Measurement measurement = measurements.get(m);
                Log.logf("%30s  ", measurement.name);
                switch (measurement.space) {
                    case R: {
                        Object cluster = new ClusterR1();
                        for (MeasuredRes mres : measuredResidues) {
                            ((ClusterR1)cluster).add(mres.measurements[m]);
                        }
                        Object object = cluster;
                        Objects.requireNonNull(object);
                        Object stats = (ClusterR1)object.new ClusterR1.Stats(90.0, 10);
                        Object bounds90 = ((ClusterR1.Stats)stats).getInterval(((ClusterR1.Stats)stats).mode, 90.0);
                        Log.logf(" mean=%6.3f  mode=%6.3f  90%%bounds=[%6.3f,%6.3f]:%6.3f  100%%bounds=[%6.3f,%6.3f]:%6.3f", ((ClusterR1.Stats)stats).mean, ((ClusterR1.Stats)stats).mode, ((MathTools.DoubleBounds)bounds90).lower, ((MathTools.DoubleBounds)bounds90).upper, ((MathTools.DoubleBounds)bounds90).size(), ((ClusterR1.Stats)stats).bounds.lower, ((ClusterR1.Stats)stats).bounds.upper, ((ClusterR1.Stats)stats).bounds.size());
                        modes[m] = ((ClusterR1.Stats)stats).mode;
                        break;
                    }
                    case S: {
                        Object cluster = new ClusterS1();
                        for (MeasuredRes mres : measuredResidues) {
                            ((ClusterS1)cluster).add(mres.measurements[m]);
                        }
                        Object object = cluster;
                        Objects.requireNonNull(object);
                        Object stats = new ClusterS1.Stats((ClusterS1)object, 90.0, 40);
                        Object bounds90 = ((ClusterS1.Stats)stats).getInterval(((ClusterS1.Stats)stats).mode, 90.0);
                        Log.logf(" mean=%6.1f  mode=%6.1f  90%%bounds=[%6.1f,%6.1f]:%6.1f  100%%bounds=[%6.1f,%6.1f]:%6.1f", ((ClusterS1.Stats)stats).mean, ((ClusterS1.Stats)stats).mode, ((SmallAngleVoxel.Interval)bounds90).min(), ((SmallAngleVoxel.Interval)bounds90).max(), ((SmallAngleVoxel.Interval)bounds90).size(), ((ClusterS1.Stats)stats).bounds.min(), ((ClusterS1.Stats)stats).bounds.max(), ((ClusterS1.Stats)stats).bounds.size());
                        modes[m] = ((ClusterS1.Stats)stats).mode;
                    }
                }
                Log.log("", new Object[0]);
            }
            modesByType.put(type2, modes);
        }
        if (!foundAllExpected) {
            throw new NoSuchElementException("missing data for some residue types, aborting: " + String.valueOf(types2.stream().filter(type -> !measurementsByType.containsKey(type)).collect(Collectors.toList())));
        }
        return modesByType;
    }

    private static void scanResidues(File dir, ResidueScanner resScanner) {
        new PDBScanner(dir, new String[0]).scan((file, mol) -> {
            for (Residue res : mol.residues) {
                String type = TemplateChooser.getResType(res);
                if (type == null) {
                    System.err.println("error reading residue at " + file.getName() + " " + res.fullName + ", skipping it: unprotonated HIS");
                    continue;
                }
                resScanner.onResidue(file.getName(), res, type);
            }
        });
    }

    private static String getResType(Residue res) {
        String type = res.getType().toUpperCase();
        if (type.equals("HIS")) {
            boolean hasE;
            boolean hasD = res.getAtomByName("HD1") != null;
            boolean bl = hasE = res.getAtomByName("HE2") != null;
            if (hasD && hasE) {
                return "HIP";
            }
            if (hasD) {
                return "HID";
            }
            if (hasE) {
                return "HIE";
            }
            return null;
        }
        return type;
    }

    private static void addLinkMeasurements(String type, String a, String b, String c) {
        mlib.add(type, new MeasurementLibrary.BondAngle(a, b, c));
        mlib.add(type, new MeasurementLibrary.BondLength(b, c));
    }

    private static void addRingLinkMeasurements(String type, String a, String b, String c, String d) {
        mlib.add(type, new MeasurementLibrary.DihedralAngle(a, b, c, d));
        mlib.add(type, new MeasurementLibrary.BondAngle(b, c, d));
        mlib.add(type, new MeasurementLibrary.BondLength(c, d));
    }

    private static void addTetrahedralMeasurements(String type, String a, String b, String c, String d) {
        mlib.add(type, new MeasurementLibrary.TetrahedralInPlaneAngle(a, b, c, d));
        mlib.add(type, new MeasurementLibrary.TetrahedralOutOfPlaneAngle(a, b, c, d));
        mlib.add(type, new MeasurementLibrary.BondLength(b, d));
    }

    private static void addTrigonalMeasurements(String type, String a, String b, String c, String d) {
        TemplateChooser.addTetrahedralMeasurements(type, a, b, c, d);
    }

    private static void addTetrahedralH2Measurements(String type, String a, String b, String c) {
        String bpos = b.substring(1);
        String[] h = new String[]{"H" + bpos + "2", "H" + bpos + "3"};
        for (int i = 0; i < 2; ++i) {
            mlib.add(type, new MeasurementLibrary.TetrahedralInPlaneAngles2(a, b, c, h[0], h[1], i));
            mlib.add(type, new MeasurementLibrary.TetrahedralOutOfPlaneAngles2(a, b, c, h[0], h[1], i));
            mlib.add(type, new MeasurementLibrary.BondLength(b, h[i]));
        }
    }

    private static void addH2Measurements(String type, String a, String b, String c) {
        String cpos = c.substring(1);
        String[] h = new String[]{"H" + cpos + "1", "H" + cpos + "2"};
        mlib.add(type, new MeasurementLibrary.DeltaDihedralAngle(a, b, c, h[0], h[1]));
        for (int i = 0; i < 2; ++i) {
            mlib.add(type, new MeasurementLibrary.BondAngle(b, c, h[i]));
            mlib.add(type, new MeasurementLibrary.BondLength(c, h[i]));
        }
    }

    private static void addH3Measurements(String type, String a, String b, String c) {
        String cpos = c.substring(1);
        String[] h = new String[]{"H" + cpos + "1", "H" + cpos + "2", "H" + cpos + "3"};
        mlib.add(type, new MeasurementLibrary.DeltaDihedralAngle(a, b, c, h[0], h[1]));
        mlib.add(type, new MeasurementLibrary.DeltaDihedralAngle(a, b, c, h[1], h[2]));
        mlib.add(type, new MeasurementLibrary.DeltaDihedralAngle(a, b, c, h[2], h[0]));
        for (int i = 0; i < 3; ++i) {
            mlib.add(type, new MeasurementLibrary.BondAngle(b, c, h[i]));
            mlib.add(type, new MeasurementLibrary.BondLength(c, h[i]));
        }
    }

    private static void addBranchMeasurements(String type, String a, String b, String c1, String c2) {
        mlib.add(type, new MeasurementLibrary.BondAngle(a, b, c1));
        mlib.add(type, new MeasurementLibrary.BondAngle(a, b, c2));
        mlib.add(type, new MeasurementLibrary.BondAngle(c1, b, c2));
        mlib.add(type, new MeasurementLibrary.BondLength(b, c1));
        mlib.add(type, new MeasurementLibrary.BondLength(b, c2));
    }

    static {
        for (String type : Arrays.asList("ARG", "HIP", "HID", "HIE", "LYS", "ASP", "GLU", "CYS", "GLY", "PRO", "ALA", "VAL", "ILE", "LEU", "MET", "PHE", "TYR", "TRP", "SER", "THR", "ASN", "GLN")) {
            mlib.add(type, new MeasurementLibrary.BondAngle("N", "CA", "C"));
            mlib.add(type, new MeasurementLibrary.BondLength("N", "CA"));
            mlib.add(type, new MeasurementLibrary.BondLength("CA", "C"));
        }
        for (String type : Arrays.asList("ARG", "HIP", "HID", "HIE", "LYS", "ASP", "GLU", "CYS", "PRO", "ALA", "VAL", "ILE", "LEU", "MET", "PHE", "TYR", "TRP", "SER", "THR", "ASN", "GLN")) {
            TemplateChooser.addTetrahedralMeasurements(type, "N", "CA", "C", "CB");
            TemplateChooser.addTetrahedralMeasurements(type, "N", "CA", "C", "HA");
        }
        TemplateChooser.addTetrahedralH2Measurements("ARG", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("ARG", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralH2Measurements("ARG", "CB", "CG", "CD");
        TemplateChooser.addLinkMeasurements("ARG", "CB", "CG", "CD");
        TemplateChooser.addTetrahedralH2Measurements("ARG", "CG", "CD", "NE");
        TemplateChooser.addLinkMeasurements("ARG", "CG", "CD", "NE");
        TemplateChooser.addTrigonalMeasurements("ARG", "CD", "NE", "CZ", "HE");
        TemplateChooser.addLinkMeasurements("ARG", "CD", "NE", "CZ");
        TemplateChooser.addBranchMeasurements("ARG", "NE", "CZ", "NH1", "NH2");
        TemplateChooser.addH2Measurements("ARG", "NE", "CZ", "NH1");
        TemplateChooser.addH2Measurements("ARG", "NE", "CZ", "NH2");
        TemplateChooser.addTetrahedralH2Measurements("HIP", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("HIP", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("HIP", "CB", "CG", "ND1", "CD2");
        TemplateChooser.addTrigonalMeasurements("HIP", "CG", "ND1", "CE1", "HD1");
        TemplateChooser.addTrigonalMeasurements("HIP", "CG", "CD2", "NE2", "HD2");
        TemplateChooser.addRingLinkMeasurements("HIP", "CB", "CG", "ND1", "CE1");
        TemplateChooser.addTrigonalMeasurements("HIP", "ND1", "CE1", "NE2", "HE1");
        TemplateChooser.addRingLinkMeasurements("HIP", "CB", "CG", "CD2", "NE2");
        TemplateChooser.addTrigonalMeasurements("HIP", "CD2", "NE2", "CE1", "HE2");
        TemplateChooser.addRingLinkMeasurements("HIP", "CG", "ND1", "CE1", "NE2");
        TemplateChooser.addTetrahedralH2Measurements("HID", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("HID", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("HID", "CB", "CG", "ND1", "CD2");
        TemplateChooser.addTrigonalMeasurements("HID", "CG", "ND1", "CE1", "HD1");
        TemplateChooser.addTrigonalMeasurements("HID", "CG", "CD2", "NE2", "HD2");
        TemplateChooser.addRingLinkMeasurements("HID", "CB", "CG", "ND1", "CE1");
        TemplateChooser.addTrigonalMeasurements("HIP", "ND1", "CE1", "NE2", "HE1");
        TemplateChooser.addRingLinkMeasurements("HID", "CB", "CG", "CD2", "NE2");
        TemplateChooser.addRingLinkMeasurements("HID", "CG", "ND1", "CE1", "NE2");
        TemplateChooser.addTetrahedralH2Measurements("HIE", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("HIE", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("HIE", "CB", "CG", "ND1", "CD2");
        TemplateChooser.addTrigonalMeasurements("HIE", "CG", "CD2", "NE2", "HD2");
        TemplateChooser.addRingLinkMeasurements("HIE", "CB", "CG", "ND1", "CE1");
        TemplateChooser.addTrigonalMeasurements("HIE", "ND1", "CE1", "NE2", "HE1");
        TemplateChooser.addRingLinkMeasurements("HIE", "CB", "CG", "CD2", "NE2");
        TemplateChooser.addTrigonalMeasurements("HIE", "CD2", "NE2", "CE1", "HE2");
        TemplateChooser.addRingLinkMeasurements("HIE", "CG", "ND1", "CE1", "NE2");
        TemplateChooser.addTetrahedralH2Measurements("LYS", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("LYS", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralH2Measurements("LYS", "CB", "CG", "CD");
        TemplateChooser.addLinkMeasurements("LYS", "CB", "CG", "CD");
        TemplateChooser.addTetrahedralH2Measurements("LYS", "CG", "CD", "CE");
        TemplateChooser.addLinkMeasurements("LYS", "CG", "CD", "CE");
        TemplateChooser.addTetrahedralH2Measurements("LYS", "CD", "CE", "NZ");
        TemplateChooser.addLinkMeasurements("LYS", "CD", "CE", "NZ");
        TemplateChooser.addH3Measurements("LYS", "CD", "CE", "NZ");
        TemplateChooser.addTetrahedralH2Measurements("ASP", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("ASP", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("ASP", "CB", "CG", "OD1", "OD2");
        TemplateChooser.addTetrahedralH2Measurements("GLU", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("GLU", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralH2Measurements("GLU", "CB", "CG", "CD");
        TemplateChooser.addLinkMeasurements("GLU", "CB", "CG", "CD");
        TemplateChooser.addBranchMeasurements("GLU", "CG", "CD", "OE1", "OE2");
        TemplateChooser.addTetrahedralH2Measurements("CYS", "CA", "CB", "SG");
        TemplateChooser.addLinkMeasurements("CYS", "CA", "CB", "SG");
        TemplateChooser.addLinkMeasurements("CYS", "CB", "SG", "HG");
        TemplateChooser.addTetrahedralH2Measurements("GLY", "N", "CA", "C");
        TemplateChooser.addTetrahedralH2Measurements("PRO", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("PRO", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralH2Measurements("PRO", "CB", "CG", "CD");
        TemplateChooser.addLinkMeasurements("PRO", "CB", "CG", "CD");
        TemplateChooser.addTetrahedralH2Measurements("PRO", "CG", "CD", "N");
        TemplateChooser.addLinkMeasurements("PRO", "CG", "CD", "N");
        TemplateChooser.addH3Measurements("ALA", "N", "CA", "CB");
        TemplateChooser.addTetrahedralMeasurements("VAL", "CA", "CB", "CG1", "HB");
        TemplateChooser.addBranchMeasurements("VAL", "CA", "CB", "CG1", "CG2");
        TemplateChooser.addH3Measurements("VAL", "CA", "CB", "CG1");
        TemplateChooser.addH3Measurements("VAL", "CA", "CB", "CG2");
        TemplateChooser.addTetrahedralMeasurements("ILE", "CA", "CB", "CG1", "HB");
        TemplateChooser.addBranchMeasurements("ILE", "CA", "CB", "CG1", "CG2");
        TemplateChooser.addH3Measurements("ILE", "CA", "CB", "CG2");
        TemplateChooser.addTetrahedralH2Measurements("ILE", "CB", "CG1", "CD1");
        TemplateChooser.addLinkMeasurements("ILE", "CB", "CG1", "CD1");
        TemplateChooser.addH3Measurements("ILE", "CB", "CG1", "CD1");
        TemplateChooser.addTetrahedralH2Measurements("LEU", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("LEU", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralMeasurements("LEU", "CB", "CG", "CD1", "HG");
        TemplateChooser.addBranchMeasurements("LEU", "CB", "CG", "CD1", "CD2");
        TemplateChooser.addH3Measurements("LEU", "CB", "CG", "CD1");
        TemplateChooser.addH3Measurements("LEU", "CB", "CG", "CD2");
        TemplateChooser.addTetrahedralH2Measurements("MET", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("MET", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralH2Measurements("MET", "CB", "CG", "SD");
        TemplateChooser.addLinkMeasurements("MET", "CB", "CG", "SD");
        TemplateChooser.addLinkMeasurements("MET", "CG", "SD", "CE");
        TemplateChooser.addH3Measurements("MET", "CG", "SD", "CE");
        TemplateChooser.addTetrahedralH2Measurements("PHE", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("PHE", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("PHE", "CB", "CG", "CD1", "CD2");
        TemplateChooser.addTrigonalMeasurements("PHE", "CG", "CD1", "CE1", "HD1");
        TemplateChooser.addTrigonalMeasurements("PHE", "CG", "CD2", "CE2", "HD2");
        TemplateChooser.addRingLinkMeasurements("PHE", "CB", "CG", "CD1", "CE1");
        TemplateChooser.addRingLinkMeasurements("PHE", "CB", "CG", "CD2", "CE2");
        TemplateChooser.addTrigonalMeasurements("PHE", "CD1", "CE1", "CZ", "HE1");
        TemplateChooser.addTrigonalMeasurements("PHE", "CD2", "CE2", "CZ", "HE2");
        TemplateChooser.addRingLinkMeasurements("PHE", "CG", "CD1", "CE1", "CZ");
        TemplateChooser.addRingLinkMeasurements("PHE", "CG", "CD2", "CE2", "CZ");
        TemplateChooser.addTrigonalMeasurements("PHE", "CE1", "CZ", "CE2", "HZ");
        TemplateChooser.addTetrahedralH2Measurements("TYR", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("TYR", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("TYR", "CB", "CG", "CD1", "CD2");
        TemplateChooser.addTrigonalMeasurements("TYR", "CG", "CD1", "CE1", "HD1");
        TemplateChooser.addTrigonalMeasurements("TYR", "CG", "CD2", "CE2", "HD2");
        TemplateChooser.addRingLinkMeasurements("TYR", "CB", "CG", "CD1", "CE1");
        TemplateChooser.addRingLinkMeasurements("TYR", "CB", "CG", "CD2", "CE2");
        TemplateChooser.addTrigonalMeasurements("TYR", "CD1", "CE1", "CZ", "HE1");
        TemplateChooser.addTrigonalMeasurements("TYR", "CD2", "CE2", "CZ", "HE2");
        TemplateChooser.addRingLinkMeasurements("TYR", "CG", "CD1", "CE1", "CZ");
        TemplateChooser.addRingLinkMeasurements("TYR", "CG", "CD2", "CE2", "CZ");
        TemplateChooser.addTrigonalMeasurements("TYR", "CE1", "CZ", "CE2", "OH");
        TemplateChooser.addLinkMeasurements("TYR", "CZ", "OH", "HH");
        TemplateChooser.addTetrahedralH2Measurements("TRP", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("TRP", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("TRP", "CB", "CG", "CD1", "CD2");
        TemplateChooser.addTrigonalMeasurements("TRP", "CG", "CD1", "NE1", "HD1");
        TemplateChooser.addRingLinkMeasurements("TRP", "CB", "CG", "CD1", "NE1");
        TemplateChooser.addTrigonalMeasurements("TRP", "CD1", "NE1", "CE2", "HE1");
        TemplateChooser.addRingLinkMeasurements("TRP", "CB", "CG", "CD2", "CE2");
        TemplateChooser.addRingLinkMeasurements("TRP", "CB", "CG", "CD2", "CE3");
        TemplateChooser.addTrigonalMeasurements("TRP", "CD2", "CE3", "CZ3", "HE3");
        TemplateChooser.addRingLinkMeasurements("TRP", "CG", "CD1", "NE1", "CE2");
        TemplateChooser.addRingLinkMeasurements("TRP", "CD1", "NE1", "CE2", "CZ2");
        TemplateChooser.addTrigonalMeasurements("TRP", "CE2", "CZ2", "CH2", "HZ2");
        TemplateChooser.addRingLinkMeasurements("TRP", "NE1", "CE2", "CZ2", "CH2");
        TemplateChooser.addTrigonalMeasurements("TRP", "CZ2", "CH2", "CZ3", "HH2");
        TemplateChooser.addRingLinkMeasurements("TRP", "CG", "CD2", "CE3", "CZ3");
        TemplateChooser.addTrigonalMeasurements("TRP", "CE3", "CZ3", "CH2", "HZ3");
        TemplateChooser.addRingLinkMeasurements("TRP", "CD2", "CE3", "CZ3", "CH2");
        TemplateChooser.addTetrahedralH2Measurements("SER", "CA", "CB", "OG");
        TemplateChooser.addLinkMeasurements("SER", "CA", "CB", "OG");
        TemplateChooser.addLinkMeasurements("SER", "CB", "OG", "HG");
        TemplateChooser.addTetrahedralMeasurements("THR", "CA", "CB", "OG1", "HB");
        TemplateChooser.addBranchMeasurements("THR", "CA", "CB", "OG1", "CG2");
        TemplateChooser.addH3Measurements("THR", "CA", "CB", "CG2");
        TemplateChooser.addLinkMeasurements("THR", "CB", "OG1", "HG1");
        TemplateChooser.addTetrahedralH2Measurements("ASN", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("ASN", "CA", "CB", "CG");
        TemplateChooser.addBranchMeasurements("ASN", "CB", "CG", "OD1", "ND2");
        TemplateChooser.addH2Measurements("ASN", "CB", "CG", "ND2");
        TemplateChooser.addTetrahedralH2Measurements("GLN", "CA", "CB", "CG");
        TemplateChooser.addLinkMeasurements("GLN", "CA", "CB", "CG");
        TemplateChooser.addTetrahedralH2Measurements("GLN", "CB", "CG", "CD");
        TemplateChooser.addLinkMeasurements("GLN", "CB", "CG", "CD");
        TemplateChooser.addBranchMeasurements("GLN", "CG", "CD", "OE1", "NE2");
        TemplateChooser.addH2Measurements("GLN", "CG", "CD", "NE2");
    }

    private static interface DistanceFunction {
        public double calc(List<MeasurementLibrary.Measurement> var1, double[] var2, double[] var3);
    }

    private static interface ResidueScanner {
        public void onResidue(String var1, Residue var2, String var3);
    }

    public static class MeasuredRes {
        public final String filename;
        public final String resNum;
        public final double[] measurements;
        public final double rmsViolation;

        public MeasuredRes(String filename, String resNum, double[] measurements, double rmsViolation) {
            this.filename = filename;
            this.resNum = resNum;
            this.measurements = measurements;
            this.rmsViolation = rmsViolation;
        }
    }

    private static class VoxelLibrary {
        private final Map<String, List<Voxel>> voxels = new HashMap<String, List<Voxel>>();

        private VoxelLibrary() {
        }

        public List<Voxel> get(String type) {
            return this.voxels.computeIfAbsent(type.toUpperCase(), t -> new ArrayList());
        }

        public void add(String type, String name, double percent, double ... bounds) {
            this.add(type, new Voxel(name, percent, bounds));
        }

        public void add(String type, Voxel voxel) {
            this.get(type).add(voxel);
        }

        public Voxel find(String type, double[] p) {
            for (Voxel voxel : this.get(type)) {
                if (!voxel.contains(p)) continue;
                return voxel;
            }
            return null;
        }
    }

    private static class Voxel {
        public final String name;
        public final double percent;
        public final SmallAngleVoxel voxel;

        public Voxel(String name, double percent, SmallAngleVoxel voxel) {
            this.name = name;
            this.percent = percent;
            this.voxel = voxel;
        }

        public Voxel(String name, double percent, double ... bounds) {
            this(name, percent, SmallAngleVoxel.makeFromBounds(bounds));
        }

        public boolean contains(double[] dihedrals) {
            if (this.voxel == null) {
                return true;
            }
            return this.voxel.contains(dihedrals);
        }
    }

    private static interface ResidueVoxelScanner {
        public void onResidue(String var1, Residue var2, String var3, Voxel var4);
    }
}

