/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tests;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.ematrix.epic.EPICMatrix;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.IdealSeparableReference;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.voxq.VoxelsDeltaG;

public class VoxDeltaGPlayground {
    public static void main(String[] args) {
        ConfigFileParser cfp = ConfigFileParser.makeFromFilePaths(args);
        cfp.loadData();
        int[] conf1 = new int[]{5, 7, 12, 5, 0, 7, 4};
        String epicMatrixName = "1CC8.EPICMAT.dat";
        EPICMatrix epicMat1 = (EPICMatrix)ObjectIO.readObject(epicMatrixName, true);
        EPICMatrix epicMat2 = (EPICMatrix)ObjectIO.readObject(epicMatrixName, true);
        System.out.println("Testing IVS...");
        MoleculeModifierAndScorer mms1 = new MoleculeModifierAndScorer(epicMat1.internalEnergyFunction(new RCTuple(conf1), true), epicMat1.getConfSpace(), new RCTuple(conf1));
        CCDMinimizer ccdMin = new CCDMinimizer(mms1, false);
        DoubleMatrix1D center = ccdMin.minimize().dofValues;
        IdealSeparableReference mms2 = new IdealSeparableReference((EnergyFunction)epicMat2.internalEnergyFunction(new RCTuple(conf1), true), epicMat2.getConfSpace(), new RCTuple(conf1), center);
        System.out.println("SEP REF G: " + mms2.calcG());
        VoxelsDeltaG vdg = new VoxelsDeltaG(mms1, mms2, false);
        double dG = vdg.estDeltaG(0.05);
        System.out.println("delta G: " + dG + " from " + vdg.numSamplesNeeded() + " samples");
        dG = vdg.estDeltaG(0.05);
        System.out.println("delta G: " + dG + " from " + vdg.numSamplesNeeded() + " samples");
        dG = vdg.estDeltaG(0.05);
        System.out.println("delta G: " + dG + " from " + vdg.numSamplesNeeded() + " samples");
        System.out.println("New normalization");
        vdg = new VoxelsDeltaG(mms1, mms2, false);
        dG = vdg.estDeltaG(0.05);
        System.out.println("delta G: " + dG + " from " + vdg.numSamplesNeeded() + " samples");
        dG = vdg.estDeltaG(0.05);
        System.out.println("delta G: " + dG + " from " + vdg.numSamplesNeeded() + " samples");
        dG = vdg.estDeltaG(0.05);
        System.out.println("delta G: " + dG + " from " + vdg.numSamplesNeeded() + " samples");
        System.exit(0);
    }
}

