/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import ch.obermuhlner.math.big.BigDecimalMath;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.IOable;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigExp
implements Comparable<BigExp>,
IOable,
Serializable {
    public static final MathContext mathContext = new MathContext(16, RoundingMode.HALF_UP);
    public double fp;
    public int exp;
    private static final MathContext staticmc = new MathContext(16, RoundingMode.HALF_UP);
    private static final BigDecimal loge = BigDecimalMath.log10((BigDecimal)BigDecimalMath.e((MathContext)staticmc), (MathContext)staticmc);
    private static final double oologe = BigDecimal.ONE.divide(loge, staticmc).doubleValue();
    private static final double oologe100 = new BigDecimal("100.0").divide(loge, staticmc).doubleValue();
    private static final double oologe1000 = new BigDecimal("1000.0").divide(loge, staticmc).doubleValue();
    private static final double oologe10000 = new BigDecimal("10000.0").divide(loge, staticmc).doubleValue();
    public static final int NumBytes = 12;

    public BigExp(double fp, int exp) {
        this.fp = fp;
        this.exp = exp;
    }

    public BigExp(double fp) {
        this.set(fp);
    }

    public BigExp(BigExp other) {
        this.set(other);
    }

    public BigExp(BigDecimal bd) {
        this.set(bd);
    }

    public BigExp(BigInteger bi) {
        this.set(bi);
    }

    public void set(double fp) {
        this.fp = fp;
        this.exp = 0;
        this.normalize(false);
    }

    public void set(double fp, int exp) {
        this.fp = fp;
        this.exp = exp;
    }

    public void set(BigExp other) {
        this.set(other.fp, other.exp);
    }

    public void set(BigDecimal bd) {
        if (MathTools.isFinite(bd)) {
            String[] str = String.format("%.16e", bd).split("e");
            this.fp = Double.parseDouble(str[0]);
            this.exp = Integer.parseInt(str[1]);
        } else {
            this.fp = bd.doubleValue();
            this.exp = 0;
        }
    }

    public void set(BigInteger bi) {
        this.set(new BigDecimal(bi));
    }

    public BigExp normalize(boolean fully) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        if (this.fp == 0.0) {
                            this.exp = 0;
                            return this;
                        }
                        if (!Double.isFinite(this.fp)) {
                            this.exp = Integer.MAX_VALUE;
                            return this;
                        }
                        if (!(this.fp >= 1.0)) break block15;
                        while (this.fp > 1.0E100) {
                            this.fp *= 1.0E-100;
                            this.exp += 100;
                        }
                        if (!fully) break block16;
                        while (this.fp > 1.0E10) {
                            this.fp *= 1.0E-10;
                            this.exp += 10;
                        }
                        while (this.fp > 10.0) {
                            this.fp *= 0.1;
                            ++this.exp;
                        }
                        break block16;
                    }
                    if (!(this.fp > 0.0)) break block17;
                    while (this.fp < 1.0E-100) {
                        this.fp *= 1.0E100;
                        this.exp -= 100;
                    }
                    if (!fully) break block16;
                    while (this.fp < 1.0E-10) {
                        this.fp *= 1.0E10;
                        this.exp -= 10;
                    }
                    while (this.fp < 0.1) {
                        this.fp *= 10.0;
                        --this.exp;
                    }
                    break block16;
                }
                if (!(this.fp > -1.0)) break block18;
                while (this.fp > -1.0E-100) {
                    this.fp *= 1.0E100;
                    this.exp -= 100;
                }
                if (!fully) break block16;
                while (this.fp > -1.0E-10) {
                    this.fp *= 1.0E10;
                    this.exp -= 10;
                }
                while (this.fp > -0.1) {
                    this.fp *= 10.0;
                    --this.exp;
                }
                break block16;
            }
            while (this.fp < -1.0E100) {
                this.fp *= 1.0E-100;
                this.exp += 100;
            }
            if (fully) {
                while (this.fp < -1.0E10) {
                    this.fp *= 1.0E-10;
                    this.exp += 10;
                }
                while (this.fp < -10.0) {
                    this.fp *= 0.1;
                    ++this.exp;
                }
            }
        }
        return this;
    }

    public void mult(BigExp other) {
        this.fp *= other.fp;
        this.exp += other.exp;
        this.normalize(false);
    }

    public void mult(double other) {
        this.fp *= other;
        this.normalize(false);
    }

    public void mult(int other) {
        this.fp *= (double)other;
        this.normalize(false);
    }

    public void mult(long other) {
        this.fp *= (double)other;
        this.normalize(false);
    }

    public void div(BigExp other) {
        this.fp /= other.fp;
        this.exp -= other.exp;
        this.normalize(false);
    }

    public void div(double other) {
        this.fp /= other;
        this.normalize(false);
    }

    public void div(int other) {
        this.fp /= (double)other;
        this.normalize(false);
    }

    public void div(long other) {
        this.fp /= (double)other;
        this.normalize(false);
    }

    public void add(BigExp other) {
        this.set(this.toBigDecimal().add(other.toBigDecimal(), mathContext));
    }

    public void sub(BigExp other) {
        this.set(this.toBigDecimal().subtract(other.toBigDecimal(), mathContext));
    }

    public void negate() {
        this.fp = -this.fp;
    }

    public void abs() {
        this.fp = Math.abs(this.fp);
    }

    public double log() {
        return Math.log10(this.fp) + (double)this.exp;
    }

    public double ln() {
        return Math.log(this.fp) + (double)this.exp * oologe;
    }

    public static BigExp pow10(double val) {
        int exp = 0;
        while (val > 10000.0) {
            exp += 10000;
            val -= 10000.0;
        }
        while (val > 1000.0) {
            exp += 1000;
            val -= 1000.0;
        }
        while (val > 100.0) {
            exp += 100;
            val -= 100.0;
        }
        while (val < -10000.0) {
            exp -= 10000;
            val += 10000.0;
        }
        while (val < -1000.0) {
            exp -= 1000;
            val += 1000.0;
        }
        while (val < -100.0) {
            exp -= 100;
            val += 100.0;
        }
        double fp = Math.pow(10.0, val);
        if (!Double.isFinite(fp)) {
            throw new IllegalArgumentException("Value magnitude too large to exponentiate");
        }
        BigExp out = new BigExp(fp, exp);
        out.normalize(true);
        return out;
    }

    public static BigExp exp(double val) {
        int exp = 0;
        while (val > oologe10000) {
            exp += 10000;
            val -= oologe10000;
        }
        while (val > oologe1000) {
            exp += 1000;
            val -= oologe1000;
        }
        while (val > oologe100) {
            exp += 100;
            val -= oologe100;
        }
        while (val < -oologe10000) {
            exp -= 10000;
            val += oologe10000;
        }
        while (val < -oologe1000) {
            exp -= 1000;
            val += oologe1000;
        }
        while (val < -oologe100) {
            exp -= 100;
            val += oologe100;
        }
        double fp = Math.exp(val);
        if (!Double.isFinite(fp)) {
            throw new IllegalArgumentException("Value magnitude too large to exponentiate");
        }
        BigExp out = new BigExp(fp, exp);
        out.normalize(true);
        return out;
    }

    public void pow(double pow) {
        double e = (double)this.exp * pow;
        this.exp = (int)e;
        this.fp = Math.pow(this.fp, pow) * Math.pow(10.0, e - (double)this.exp);
        if (!Double.isFinite(this.fp)) {
            throw new IllegalArgumentException("Value magnitude and power too large");
        }
        this.normalize(true);
    }

    public void min(BigExp other) {
        if (this.compareTo(other) > 0) {
            this.set(other);
        }
    }

    public void max(BigExp other) {
        if (this.compareTo(other) < 0) {
            this.set(other);
        }
    }

    @Override
    public int compareTo(BigExp other) {
        this.normalize(true);
        other.normalize(true);
        double thisSign = this.sign();
        double otherSign = other.sign();
        if (thisSign > otherSign) {
            return 1;
        }
        if (thisSign < otherSign) {
            return -1;
        }
        int sign = (int)thisSign;
        if (this.exp > other.exp) {
            return sign;
        }
        if (this.exp < other.exp) {
            return -sign;
        }
        return Double.compare(this.fp, other.fp);
    }

    public boolean greaterThan(BigExp other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThan(BigExp other, double epsilon) {
        return !this.lessThanOrEqual(other, epsilon);
    }

    public boolean greaterThanOrEqual(BigExp other) {
        return this.compareTo(other) >= 0;
    }

    public boolean greaterThanOrEqual(BigExp other, double epsilon) {
        other = new BigExp(other);
        other.mult(1.0 - other.sign() * epsilon);
        return this.greaterThanOrEqual(other);
    }

    public boolean lessThan(BigExp other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThan(BigExp other, double epsilon) {
        return !this.greaterThanOrEqual(other, epsilon);
    }

    public boolean lessThanOrEqual(BigExp other) {
        return this.compareTo(other) <= 0;
    }

    public boolean lessThanOrEqual(BigExp other, double epsilon) {
        other = new BigExp(other);
        other.mult(1.0 + other.sign() * epsilon);
        return this.lessThanOrEqual(other);
    }

    public boolean isNaN() {
        return Double.isNaN(this.fp);
    }

    public boolean isFinite() {
        return Double.isFinite(this.fp);
    }

    public double sign() {
        return Math.signum(this.fp);
    }

    public boolean isPositive() {
        return this.fp > 0.0;
    }

    public boolean isNegative() {
        return this.fp < 0.0;
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(MathContext.UNLIMITED);
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        if (Double.isNaN(this.fp)) {
            return MathTools.BigNaN;
        }
        if (this.fp == Double.POSITIVE_INFINITY) {
            return MathTools.BigPositiveInfinity;
        }
        if (this.fp == Double.NEGATIVE_INFINITY) {
            return MathTools.BigNegativeInfinity;
        }
        this.normalize(true);
        BigDecimal bd = BigDecimal.valueOf(this.fp);
        return new BigDecimal(bd.unscaledValue(), bd.scale() - this.exp, mc);
    }

    public double toDouble() {
        return this.toBigDecimal(mathContext).doubleValue();
    }

    public int hashCode() {
        return HashCalculator.combineHashes(Double.hashCode(this.fp), Integer.hashCode(this.exp));
    }

    public boolean equals(Object other) {
        return other instanceof BigExp && this.equals((BigExp)other);
    }

    public boolean equals(BigExp other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return this.toString(6);
    }

    public String toString(int precision) {
        String[] parts = String.format("%." + precision + "e", this.fp).split("e");
        if (parts.length == 2) {
            return parts[0] + "e" + (Integer.parseInt(parts[1]) + this.exp);
        }
        return parts[0];
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeDouble(this.fp);
        out.writeInt(this.exp);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.fp = in.readDouble();
        this.exp = in.readInt();
    }

    public static BigExp read(DataInput in) throws IOException {
        BigExp out = new BigExp(0.0, 0);
        out.readFrom(in);
        return out;
    }

    public static class Bounds {
        public BigExp lower;
        public BigExp upper;

        public Bounds(BigExp lower, BigExp upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public Bounds(BigExp val) {
            this(val, val);
        }

        public Bounds() {
            this(new BigExp(Double.NEGATIVE_INFINITY), new BigExp(Double.POSITIVE_INFINITY));
        }

        public boolean isValid() {
            return this.lower.lessThanOrEqual(this.upper);
        }

        public boolean contains(BigExp query) {
            return query.greaterThanOrEqual(this.lower) && query.lessThanOrEqual(this.upper);
        }

        public boolean contains(Bounds query) {
            return query.lower.greaterThanOrEqual(this.lower) && query.upper.lessThanOrEqual(this.upper);
        }

        public String toString() {
            return String.format("[%s,%s]", this.lower, this.upper);
        }
    }
}

