/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileTools {
    public static FileInputStream openFile(File file) {
        return new FilePathRoot().open(file.getPath());
    }

    public static FileInputStream openFile(String path2) {
        return FileTools.openFile(new File(path2));
    }

    public static InputStream openResource(String path2) {
        return new ResourcePathRoot().open(path2);
    }

    public static InputStream openResource(String path2, Class<?> relativeTo) {
        return new ResourcePathRoot(relativeTo).open(path2);
    }

    public static String readFile(File file) {
        return new FilePathRoot().read(file);
    }

    public static String readFile(String path2) {
        return FileTools.readFile(new File(path2));
    }

    public static String readResource(String path2) {
        return new ResourcePathRoot().read(path2);
    }

    public static String readResource(String path2, Class<?> relativeTo) {
        return new ResourcePathRoot(relativeTo).read(path2);
    }

    private static String readStream(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (Charset)null);
    }

    private static byte[] readStreamBytes(InputStream in) throws IOException {
        return IOUtils.toByteArray((InputStream)in);
    }

    public static void writeFile(String text, String path2) {
        new FilePathRoot().write(text, path2);
    }

    public static void writeFile(String text, File file) {
        new FilePathRoot().write(text, file);
    }

    private static void writeStream(String text, OutputStream out) throws IOException {
        IOUtils.write((String)text, (OutputStream)out, (Charset)null);
    }

    public static byte[] readFileBytes(String path2) {
        return FileTools.readFileBytes(new File(path2));
    }

    public static byte[] readFileBytes(File file) {
        return new FilePathRoot().readBytes(file);
    }

    public static byte[] readResourceBytes(String path2) {
        return new ResourcePathRoot().readBytes(path2);
    }

    public static byte[] readResourceBytes(String path2, Class<?> relativeTo) {
        return new ResourcePathRoot(relativeTo).readBytes(path2);
    }

    public static void writeFileBytes(byte[] bytes, String path2) {
        new FilePathRoot().writeBytes(bytes, path2);
    }

    public static void writeFileBytes(byte[] bytes, File file) {
        new FilePathRoot().writeBytes(bytes, file);
    }

    private static void writeStreamBytes(byte[] bytes, OutputStream out) throws IOException {
        IOUtils.write((byte[])bytes, (OutputStream)out);
    }

    public static LineIterator parseLines(String text) {
        return new LineIterator(text);
    }

    public static Iterable<String> parseLinesFast(Reader reader) {
        return () -> new BufferedReader(reader).lines().iterator();
    }

    public static Iterable<String> parseLinesFast(String text) {
        return FileTools.parseLinesFast(new StringReader(text));
    }

    public static class FilePathRoot
    extends PathRoot {
        private static final long serialVersionUID = 882642923777325590L;
        private File rootFile;

        public FilePathRoot() {
            this((File)null);
        }

        public FilePathRoot(String rootPath) {
            this(new File(rootPath));
        }

        public FilePathRoot(File rootFile) {
            super("file");
            this.rootFile = rootFile;
        }

        @Override
        public String resolve(String path2) {
            File file = new File(path2);
            if (file.isAbsolute()) {
                return path2;
            }
            if (this.rootFile != null) {
                return new File(this.rootFile, path2).getAbsolutePath();
            }
            return path2;
        }

        public File resolve(File file) {
            return new File(this.resolve(file.getPath()));
        }

        @Override
        public String makeRelative(String path2) {
            if (!path2.startsWith(this.rootFile.getAbsolutePath())) {
                throw new IllegalArgumentException("can't make relative, file: " + path2 + " doesn't match root: " + this.rootFile.getAbsolutePath());
            }
            return path2.substring(this.rootFile.getAbsolutePath().length() + 1);
        }

        public File makeRelative(File file) {
            return new File(this.makeRelative(file.getAbsolutePath()));
        }

        @Override
        public FileInputStream open(String path2) {
            try {
                return new FileInputStream(this.resolve(path2));
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        public FileInputStream open(File file) {
            return this.open(file.getPath());
        }

        public String read(File file) {
            return this.read(file.getPath());
        }

        public byte[] readBytes(File file) {
            return this.readBytes(file.getPath());
        }

        public void write(String text, File file) {
            this.write(text, file.getPath());
        }

        public void write(String text, String path2) {
            try (FileOutputStream out = new FileOutputStream(this.resolve(path2));){
                FileTools.writeStream(text, out);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void writeBytes(byte[] bytes, File file) {
            this.writeBytes(bytes, file.getPath());
        }

        public void writeBytes(byte[] bytes, String path2) {
            try (FileOutputStream out = new FileOutputStream(this.resolve(path2));){
                FileTools.writeStreamBytes(bytes, out);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return "FileRoot:" + String.valueOf(this.rootFile);
        }
    }

    public static class ResourcePathRoot
    extends PathRoot {
        private static final long serialVersionUID = 6035021994505586535L;
        private String rootPath;

        public static ResourcePathRoot parentOf(String path2) {
            String parentPath = FilenameUtils.getPrefix((String)path2) + FilenameUtils.getPath((String)path2);
            return new ResourcePathRoot(parentPath);
        }

        public ResourcePathRoot() {
            this((String)null);
        }

        public ResourcePathRoot(String rootPath) {
            super("resource");
            if (rootPath != null && !rootPath.startsWith("/")) {
                throw new IllegalArgumentException("resource root path is not absolute: " + rootPath);
            }
            this.rootPath = rootPath;
        }

        public ResourcePathRoot(Class<?> rootClass) {
            this("/" + rootClass.getPackage().getName().replace('.', '/'));
        }

        @Override
        public String resolve(String path2) {
            if (path2.startsWith("/")) {
                return path2;
            }
            if (this.rootPath == null) {
                throw new IllegalArgumentException("can't resolve path: " + path2 + "\npath is not absolute and no relative root was set");
            }
            return this.rootPath + "/" + path2;
        }

        @Override
        public String makeRelative(String path2) {
            if (!path2.startsWith(this.rootPath)) {
                throw new IllegalArgumentException("can't make relative, " + path2 + " doesn't match root: " + this.rootPath);
            }
            return path2.substring(this.rootPath.length() + 1);
        }

        @Override
        public InputStream open(String path2) {
            URL url = FileTools.class.getResource(path2 = this.resolve(path2));
            if (url == null) {
                throw new RuntimeException("can't find resource on classpath: " + path2);
            }
            try {
                return url.openStream();
            }
            catch (IOException ex) {
                throw new RuntimeException("can't open resource: " + path2, ex);
            }
        }

        public File extractToTempFile(String path2) throws IOException {
            try (InputStream in = this.open(path2);){
                String filename = FilenameUtils.getName((String)path2);
                File file = File.createTempFile(FilenameUtils.getBaseName((String)filename) + ".", "." + FilenameUtils.getExtension((String)filename));
                file.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                File file2 = file;
                return file2;
            }
        }

        public String toString() {
            return "ResourceRoot:" + this.rootPath;
        }
    }

    public static class LineIterator
    implements Iterator<String>,
    Iterable<String> {
        private final BufferedReader reader;
        private String nextLine;
        private int lineNumber;

        public LineIterator(String text) {
            this.reader = new BufferedReader(new StringReader(text));
            this.nextLine = this.readLine();
            this.lineNumber = 1;
        }

        private String readLine() {
            try {
                return this.reader.readLine();
            }
            catch (IOException ex) {
                throw new Error("can't read line", ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        public String peek() {
            return this.nextLine;
        }

        @Override
        public String next() {
            String line = this.nextLine;
            this.nextLine = this.readLine();
            ++this.lineNumber;
            return line;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }
    }

    public static class Path {
        public final PathRoot root;
        public final String path;

        public static Path makeFile(File file) {
            if (file == null) {
                return null;
            }
            return new Path(new FilePathRoot(), file.getAbsolutePath());
        }

        public static Path makeFile(String path2) {
            if (path2 == null) {
                return null;
            }
            return new Path(new FilePathRoot(), path2);
        }

        public static Path makeResource(String path2) {
            if (path2 == null) {
                return null;
            }
            return new Path(new ResourcePathRoot(), path2);
        }

        public Path(PathRoot root, String path2) {
            this.root = root;
            this.path = path2;
        }

        public InputStream open() {
            return this.root.open(this.path);
        }

        public String read() {
            return this.root.read(this.path);
        }
    }

    public static abstract class PathRoot
    implements Serializable {
        private static final long serialVersionUID = 2265693476401349502L;
        private final String type;

        protected PathRoot(String type) {
            this.type = type;
        }

        public abstract String resolve(String var1);

        public abstract String makeRelative(String var1);

        public abstract InputStream open(String var1);

        public String read(String path2) {
            try {
                return FileTools.readStream(this.open(path2));
            }
            catch (IOException ex) {
                throw new RuntimeException("can't read " + this.type + ": " + path2, ex);
            }
        }

        public byte[] readBytes(String path2) {
            try {
                return FileTools.readStreamBytes(this.open(path2));
            }
            catch (IOException ex) {
                throw new RuntimeException("can't read " + this.type + ": " + path2, ex);
            }
        }
    }
}

