/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.EnumMap;

public class GLibC {
    public static RLimit getrlimit(RLimitResource resource) {
        NativeLib.RLimit rlimit = new NativeLib.RLimit();
        NativeLib.getrlimit(resource.ordinal(), rlimit);
        return new RLimit(rlimit);
    }

    public static EnumMap<RLimitResource, RLimit> getrlimits() {
        EnumMap<RLimitResource, RLimit> map = new EnumMap<RLimitResource, RLimit>(RLimitResource.class);
        for (RLimitResource resource : RLimitResource.values()) {
            map.put(resource, GLibC.getrlimit(resource));
        }
        return map;
    }

    private static class NativeLib {
        private NativeLib() {
        }

        public static native int getrlimit(int var0, RLimit var1);

        static {
            Native.register((String)"c");
        }

        @Structure.FieldOrder(value={"rlim_curr", "rlim_max"})
        public static class RLimit
        extends Structure {
            public NativeLong rlim_curr;
            public NativeLong rlim_max;
        }
    }

    static enum RLimitResource {
        CPU,
        FSIZE,
        DATA,
        STACK,
        CORE,
        RSS,
        NPROC,
        NOFILE,
        MEMLOCK,
        AS,
        LOCKS,
        SIGPENDING,
        MSGQUEUE,
        NICE,
        RTPRIO,
        RTTIME;

    }

    public static class RLimit {
        public long curr;
        public long max;

        private RLimit(NativeLib.RLimit n) {
            this.curr = n.rlim_curr.longValue();
            this.max = n.rlim_max.longValue();
        }
    }
}

