/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum IntEncoding {
    Byte(1, 255){

        @Override
        public void write(DataOutput out, int val) throws IOException {
            out.writeByte(val);
        }

        @Override
        public int read(DataInput in) throws IOException {
            return in.readUnsignedByte();
        }

        @Override
        public void write(ByteBuffer out, int val) {
            out.put((byte)val);
        }

        @Override
        public int read(ByteBuffer in) {
            return in.get() & 0xFF;
        }
    }
    ,
    Short(2, java.lang.Short.MAX_VALUE){

        @Override
        public void write(DataOutput out, int val) throws IOException {
            out.writeShort(val);
        }

        @Override
        public int read(DataInput in) throws IOException {
            return in.readUnsignedShort();
        }

        @Override
        public void write(ByteBuffer out, int val) {
            out.putShort((short)val);
        }

        @Override
        public int read(ByteBuffer in) {
            return in.getShort() & 0xFFFF;
        }
    }
    ,
    Int(4, Integer.MAX_VALUE){

        @Override
        public void write(DataOutput out, int val) throws IOException {
            out.writeInt(val);
        }

        @Override
        public int read(DataInput in) throws IOException {
            return in.readInt();
        }

        @Override
        public void write(ByteBuffer out, int val) {
            out.putInt(val);
        }

        @Override
        public int read(ByteBuffer in) {
            return in.getInt();
        }
    };

    public final int numBytes;
    public final int maxValue;

    private IntEncoding(int numBytes, int maxValue) {
        this.numBytes = numBytes;
        this.maxValue = maxValue;
    }

    public static IntEncoding get(int maxVal) {
        for (IntEncoding encoding : IntEncoding.values()) {
            if (maxVal > encoding.maxValue) continue;
            return encoding;
        }
        throw new Error("unpossible, unless I'm an idiot");
    }

    public abstract void write(DataOutput var1, int var2) throws IOException;

    public abstract int read(DataInput var1) throws IOException;

    public abstract void write(ByteBuffer var1, int var2);

    public abstract int read(ByteBuffer var1);
}

