/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

public class LZMA2 {
    private static final LZMA2Options options = new LZMA2Options();
    private static final Charset charset = StandardCharsets.UTF_8;

    public static byte[] compress(byte[] bytes) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream((OutputStream)new XZOutputStream((OutputStream)buf, (FilterOptions)options));){
            out.writeInt(bytes.length);
            out.write(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("can't compress", ex);
        }
        return buf.toByteArray();
    }

    public static byte[] compress(String text) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (XZOutputStream out = new XZOutputStream((OutputStream)buf, (FilterOptions)options);){
            byte[] bytes = text.getBytes(charset);
            byte[] lenbuf = String.format("%-12d", bytes.length).getBytes(charset);
            if (lenbuf.length != 12) {
                throw new Error("length encoded to unexpected size: " + lenbuf.length);
            }
            out.write(lenbuf);
            out.write(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("can't compress", ex);
        }
        return buf.toByteArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompressBytes(byte[] bytes) {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (DataInputStream in = new DataInputStream((InputStream)new XZInputStream((InputStream)bin));){
                int length = in.readInt();
                byte[] out = new byte[length];
                in.readFully(out);
                if (in.read() != -1) {
                    throw new IOException("Expected EOF, but it wasn't");
                }
                byArray = out;
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException("can't decompress", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String decompressString(byte[] bytes) {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(bytes);){
            String string;
            try (DataInputStream in = new DataInputStream((InputStream)new XZInputStream((InputStream)bin));){
                byte[] lenbuf = new byte[12];
                in.readFully(lenbuf);
                int length = Integer.parseInt(new String(lenbuf, charset).trim());
                byte[] out = new byte[length];
                in.readFully(out);
                if (in.read() != -1) {
                    throw new IOException("Expected EOF, but it wasn't");
                }
                string = new String(out, charset);
            }
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("can't decompress", ex);
        }
    }
}

