/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.jet.math.Functions;
import edu.duke.cs.osprey.ematrix.epic.SeriesFitter;
import java.io.Serializable;

public class MinVolEllipse
implements Serializable {
    DoubleMatrix2D A;
    DoubleMatrix1D c;
    DoubleMatrix1D nc;

    public MinVolEllipse(DoubleMatrix2D P, double tol, boolean speedup) {
        int d = P.rows();
        int N = P.columns();
        DoubleMatrix2D Q = DoubleFactory2D.dense.make(d + 1, N);
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < d; ++i) {
                Q.set(i, j, P.get(i, j));
            }
            Q.set(d, j, 1.0);
        }
        int count = 1;
        double err = 1.0;
        DoubleMatrix1D u = DoubleFactory1D.dense.make(N, 1.0 / (double)N);
        while (err > tol) {
            DoubleMatrix1D M = null;
            if (speedup) {
                DoubleMatrix2D X = MinVolEllipse.QuQt(Q, u);
                DoubleMatrix2D invX = null;
                try {
                    invX = Algebra.DEFAULT.inverse(X);
                }
                catch (Exception e) {
                    System.err.println("ERROR: Singular matrix in MinVolEllipse calculation");
                }
                M = MinVolEllipse.diagMult(Q.zMult(invX, null, 1.0, 0.0, true, false), Q);
            } else {
                DoubleMatrix2D udiag = DoubleFactory2D.dense.diagonal(u);
                DoubleMatrix2D Qt = Algebra.DEFAULT.transpose(Q);
                DoubleMatrix2D X = Algebra.DEFAULT.mult(Q, Algebra.DEFAULT.mult(udiag, Qt));
                DoubleMatrix2D invX = Algebra.DEFAULT.inverse(X);
                DoubleMatrix2D Mfull = Algebra.DEFAULT.mult(Qt, Algebra.DEFAULT.mult(invX, Q));
                M = DoubleFactory2D.dense.diagonal(Mfull);
            }
            int j = -1;
            double maximum = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < N; ++k) {
                if (!(M.get(k) > maximum)) continue;
                maximum = M.get(k);
                j = k;
            }
            double step_size = (maximum - (double)d - 1.0) / ((double)(d + 1) * (maximum - 1.0));
            DoubleMatrix1D new_u = u.copy().assign(Functions.mult((double)(1.0 - step_size)));
            new_u.set(j, new_u.get(j) + step_size);
            ++count;
            u.assign(Functions.mult((double)-1.0));
            u.assign(new_u, Functions.plus);
            err = Math.sqrt(u.zDotProduct(u));
            u = new_u;
        }
        DoubleMatrix2D Pt = Algebra.DEFAULT.transpose(P);
        this.c = Algebra.DEFAULT.mult(P, u);
        this.A = Algebra.DEFAULT.multOuter(this.c, this.c, null);
        this.A.assign(Functions.mult((double)-1.0));
        this.A.assign(MinVolEllipse.QuQt(P, u), Functions.plus);
        this.A = Algebra.DEFAULT.inverse(this.A);
        this.A.assign(Functions.mult((double)(1.0 / (double)d)));
        this.nc = this.c.copy();
        this.nc.assign(Functions.mult((double)-1.0));
    }

    public MinVolEllipse(DoubleMatrix2D P, double tol, MinVolEllipse[] littleEllipses, MinVolEllipse initEllipse) {
        DoubleMatrix2D invX;
        int d = P.rows();
        int N = P.columns();
        if (d == 1) {
            double maxPt = Double.NEGATIVE_INFINITY;
            double minPt = Double.POSITIVE_INFINITY;
            for (int p = 0; p < N; ++p) {
                maxPt = Math.max(maxPt, P.get(0, p));
                minPt = Math.min(minPt, P.get(0, p));
            }
            this.A = DoubleFactory2D.dense.make(1, 1, 4.0 / ((maxPt - minPt) * (maxPt - minPt)));
            this.c = DoubleFactory1D.dense.make(1, (maxPt + minPt) / 2.0);
            this.nc = DoubleFactory1D.dense.make(1, -(maxPt + minPt) / 2.0);
            return;
        }
        DoubleMatrix2D Q = DoubleFactory2D.dense.make(d + 1, N);
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < d; ++i) {
                Q.set(i, j, P.get(i, j));
            }
            Q.set(d, j, 1.0);
        }
        double err = 1.0;
        DoubleMatrix2D X = null;
        if (initEllipse != null) {
            DoubleMatrix2D[][] blocks = new DoubleMatrix2D[2][2];
            blocks[0][0] = initEllipse.A.copy();
            blocks[0][0].assign(Functions.mult((double)d));
            DoubleMatrix2D nccol = DoubleFactory2D.dense.make(initEllipse.nc.toArray(), d);
            blocks[0][1] = blocks[0][0].zMult(nccol, null);
            blocks[1][0] = Algebra.DEFAULT.transpose(blocks[0][1]);
            double lastBlock = Algebra.DEFAULT.mult(blocks[0][0], initEllipse.c).zDotProduct(initEllipse.c) + 1.0;
            blocks[1][1] = DoubleFactory2D.dense.make(1, 1, lastBlock);
            DoubleMatrix2D invX2 = DoubleFactory2D.dense.compose(blocks);
            X = MinVolEllipse.invertX(invX2);
        } else {
            DoubleMatrix1D u = DoubleFactory1D.dense.make(N, 1.0 / (double)N);
            X = MinVolEllipse.QuQt(Q, u);
        }
        while (err > tol) {
            invX = MinVolEllipse.invertX(X);
            DoubleMatrix1D M = MinVolEllipse.diagMult(Q.zMult(invX, null, 1.0, 0.0, true, false), Q);
            DoubleMatrix1D q = null;
            double maximum = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < N; ++k) {
                if (!(M.get(k) > maximum)) continue;
                maximum = M.get(k);
                q = Q.viewColumn(k);
            }
            for (MinVolEllipse ell : littleEllipses) {
                DoubleMatrix1D amax = DoubleFactory1D.dense.make(d + 1);
                double maxEllNorm = ell.maximizeQuadratic2(invX, amax);
                amax.set(d, 1.0);
                if (!(maxEllNorm > maximum)) continue;
                maximum = maxEllNorm;
                q = amax;
            }
            double step_size = (maximum - (double)d - 1.0) / ((double)(d + 1) * (maximum - 1.0));
            DoubleMatrix2D newX = X.copy().assign(Functions.mult((double)(1.0 - step_size)));
            DoubleMatrix2D dirTerm = Algebra.DEFAULT.multOuter(q, q, null);
            dirTerm.assign(Functions.mult((double)step_size));
            newX.assign(dirTerm, Functions.plus);
            err = maximum / (double)(d + 1) - 1.0;
            X = newX;
        }
        invX = MinVolEllipse.invertX(X);
        this.A = invX.viewPart(0, 0, d, d);
        DoubleMatrix2D invA = MinVolEllipse.invertX(this.A);
        DoubleMatrix1D lc = invX.viewPart(0, d, d, 1).viewColumn(0);
        this.nc = Algebra.DEFAULT.mult(invA, lc);
        double fac = (double)(d + 1) + lc.zDotProduct(this.nc) - invX.get(d, d);
        this.A.assign(Functions.mult((double)(1.0 / fac)));
        this.c = this.nc.copy();
        this.c.assign(Functions.mult((double)-1.0));
    }

    static DoubleMatrix2D invertX(DoubleMatrix2D X) {
        if (X.rows() != X.columns()) {
            throw new RuntimeException("ERROR: Can't invert square matrix");
        }
        if (X.rows() == 1) {
            if (Math.abs(X.get(0, 0)) < 1.0E-8) {
                return DoubleFactory2D.dense.make(1, 1, 0.0);
            }
            return DoubleFactory2D.dense.make(1, 1, 1.0 / X.get(0, 0));
        }
        EigenvalueDecomposition edec = new EigenvalueDecomposition(X);
        DoubleMatrix2D newD = edec.getD().copy();
        for (int m = 0; m < X.rows(); ++m) {
            if (Math.abs(newD.get(m, m)) < 1.0E-8) {
                newD.set(m, m, 0.0);
                continue;
            }
            newD.set(m, m, 1.0 / newD.get(m, m));
        }
        DoubleMatrix2D invX = Algebra.DEFAULT.mult(edec.getV(), newD).zMult(edec.getV(), null, 1.0, 0.0, false, true);
        return invX;
    }

    double getScaledDistFromCenter(DoubleMatrix1D x) {
        if (x == null) {
            System.out.println("woah...");
        }
        DoubleMatrix1D xrel = x.copy().assign(this.nc, Functions.plus);
        return xrel.zDotProduct(Algebra.DEFAULT.mult(this.A, xrel));
    }

    double getScaling(DoubleMatrix1D x) {
        double co1 = x.zDotProduct(Algebra.DEFAULT.mult(this.A, x));
        double co2 = -2.0 * x.zDotProduct(Algebra.DEFAULT.mult(this.A, this.c));
        double co3 = this.c.zDotProduct(Algebra.DEFAULT.mult(this.A, this.c)) - 1.0;
        if (co1 == 0.0 && co2 == 0.0) {
            if (co3 >= -1.0E-10) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        double soln1 = MinVolEllipse.quadraticFormula(co1, co2, co3, true, false);
        double soln2 = MinVolEllipse.quadraticFormula(co1, co2, co3, false, false);
        if (Double.isNaN(co1) || Double.isNaN(co2) || Double.isNaN(co3)) {
            System.out.print("NaN in getScaling! co's: " + co1 + " " + co2 + " " + co3 + " A:");
            System.out.print(this.A);
            System.out.print("x: ");
            System.out.print(x);
            System.out.print("c: ");
            System.out.println(this.c);
        }
        if (soln1 > 0.0 && soln2 > 0.0) {
            return Math.max(soln1, soln2);
        }
        if (!(soln1 > 0.0) && !(soln2 > 0.0)) {
            return 0.0;
        }
        if (soln1 > 0.0) {
            return soln1;
        }
        return soln2;
    }

    boolean isPointInside(DoubleMatrix1D x) {
        return this.getScaledDistFromCenter(x) < 1.0;
    }

    static DoubleMatrix2D QuQt(DoubleMatrix2D Q, DoubleMatrix1D u) {
        int m = Q.rows();
        int n = Q.columns();
        if (u.size() != n) {
            throw new Error("Size mismatch in QuQt: " + n + " columns in Q, u length=" + u.size());
        }
        DoubleMatrix2D ans = DoubleFactory2D.dense.make(m, m);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double s = 0.0;
                for (int k = 0; k < n; ++k) {
                    s += Q.getQuick(i, k) * Q.getQuick(j, k) * u.get(k);
                }
                ans.setQuick(i, j, s);
            }
        }
        return ans;
    }

    static DoubleMatrix1D diagMult(DoubleMatrix2D A, DoubleMatrix2D B) {
        int m = A.rows();
        int n = A.columns();
        if (B.rows() != n || B.columns() != m) {
            throw new Error("Size mismatch in diagMult: A is " + m + "x" + n + ", B is " + B.rows() + "x" + B.columns());
        }
        DoubleMatrix1D ans = DoubleFactory1D.dense.make(m);
        for (int i = 0; i < m; ++i) {
            double s = 0.0;
            for (int k = 0; k < n; ++k) {
                s += A.getQuick(i, k) * B.getQuick(k, i);
            }
            ans.setQuick(i, s);
        }
        return ans;
    }

    DoubleMatrix2D homMatrix() {
        int n = this.c.size();
        DoubleMatrix2D ans = DoubleFactory2D.dense.make(n + 1, n + 1);
        DoubleMatrix1D Qnc = this.A.zMult(this.nc, null);
        for (int a = 0; a < n; ++a) {
            for (int b = 0; b < n; ++b) {
                ans.setQuick(a, b, this.A.get(a, b));
            }
            ans.setQuick(a, n, Qnc.get(a));
            ans.setQuick(n, a, Qnc.get(a));
        }
        ans.setQuick(n, n, Qnc.zDotProduct(this.nc) - 1.0);
        return ans;
    }

    static double[] flattenMatrix(DoubleMatrix2D M, boolean removeLast, boolean coeffForm) {
        int count = 0;
        int n = M.rows();
        int paramCount = SeriesFitter.getNumParamsForOrder(n, 2);
        if (removeLast) {
            --paramCount;
        }
        double[] ans = new double[paramCount];
        block0: for (int a = 0; a < n; ++a) {
            for (int b = 0; b <= a; ++b) {
                ans[count] = b == a ? M.get(a, a) : (!coeffForm ? M.get(a, b) + M.get(b, a) : M.get(a, b));
                if (++count == paramCount) continue block0;
            }
        }
        return ans;
    }

    static DoubleMatrix2D unflattenMatrix(double[] serCoeffs, int nd, boolean removeLast, boolean coeffForm) {
        int count = 0;
        DoubleMatrix2D hess = DoubleFactory2D.dense.make(nd, nd);
        for (int a = 0; a < nd; ++a) {
            for (int b = 0; b <= a; ++b) {
                if (b == a) {
                    if (removeLast && a == nd - 1) {
                        hess.set(a, a, 1.0);
                    } else {
                        hess.set(a, a, serCoeffs[count]);
                    }
                } else {
                    double co = serCoeffs[count];
                    if (!coeffForm) {
                        co /= 2.0;
                    }
                    hess.set(a, b, co);
                    hess.set(b, a, co);
                }
                ++count;
            }
        }
        return hess;
    }

    double maximizeQuadratic2(DoubleMatrix2D augMatrix, DoubleMatrix1D amax) {
        CholeskyDecomposition chol = new CholeskyDecomposition(this.A);
        DoubleMatrix2D C = null;
        DoubleMatrix2D invC = null;
        if (chol.isSymmetricPositiveDefinite()) {
            C = chol.getL();
            invC = Algebra.DEFAULT.inverse(C);
        } else {
            EigenvalueDecomposition edec = new EigenvalueDecomposition(this.A);
            DoubleMatrix2D sqrtD = edec.getD().copy();
            DoubleMatrix2D sqrtDinv = sqrtD.copy();
            for (int m = 0; m < this.A.rows(); ++m) {
                double eigVal = sqrtD.get(m, m);
                if (eigVal < 0.0) {
                    if (eigVal < -1.0E-8) {
                        System.err.println("ERROR: Non-positive-semidefinite A matrix in ellipse!");
                    }
                    eigVal = 0.0;
                }
                sqrtD.set(m, m, Math.sqrt(eigVal));
                if (eigVal > 1.0E-8) {
                    sqrtDinv.set(m, m, 1.0 / Math.sqrt(eigVal));
                    continue;
                }
                sqrtDinv.set(m, m, 0.0);
            }
            DoubleMatrix2D V = edec.getV();
            C = Algebra.DEFAULT.mult(V, sqrtD);
            invC = Algebra.DEFAULT.mult(sqrtDinv, Algebra.DEFAULT.transpose(V));
        }
        int n = this.c.size();
        DoubleMatrix2D M = augMatrix.viewPart(0, 0, n, n);
        DoubleMatrix1D g = augMatrix.viewPart(0, n, n, 1).viewColumn(0).copy();
        g.assign(Functions.mult((double)2.0));
        DoubleMatrix2D Qball = Algebra.DEFAULT.mult(invC, M.zMult(invC, null, 1.0, 0.0, false, true));
        Qball.assign(Functions.mult((double)-2.0));
        DoubleMatrix1D cball = Algebra.DEFAULT.mult(Algebra.DEFAULT.mult(invC, M), this.c);
        cball.assign(Functions.mult((double)-2.0));
        cball.assign(Algebra.DEFAULT.mult(invC, g), Functions.minus);
        double lambda = 0.0;
        EigenvalueDecomposition edec = new EigenvalueDecomposition(Qball);
        DoubleMatrix1D eigVals = edec.getRealEigenvalues();
        DoubleMatrix1D lvec = null;
        for (int m = 0; m < n; ++m) {
            if (!(eigVals.get(m) < lambda)) continue;
            lambda = eigVals.get(m);
            lvec = edec.getV().viewColumn(m);
        }
        if (lambda >= 0.0) {
            System.err.println("ERROR: maximizeQuadratic2 used with convex obj function...");
        }
        DoubleMatrix1D y = null;
        DoubleMatrix2D ncball = DoubleFactory2D.dense.make(cball.toArray(), n);
        ncball.assign(Functions.mult((double)-1.0));
        boolean useBisection = true;
        DoubleMatrix2D qi = null;
        DoubleMatrix1D x0 = null;
        double discr = -42.0;
        if (Algebra.DEFAULT.norm2(cball) < 1.0E-8) {
            y = lvec;
            useBisection = false;
        } else if (Math.abs(cball.zDotProduct(lvec)) < 1.0E-8) {
            double qc;
            DoubleMatrix2D newD = edec.getD().copy();
            for (int m = 0; m < n; ++m) {
                if (Math.abs(newD.get(m, m) - lambda) < 1.0E-8) {
                    newD.set(m, m, 0.0);
                    continue;
                }
                newD.set(m, m, 1.0 / (newD.get(m, m) - lambda));
            }
            qi = Algebra.DEFAULT.mult(edec.getV(), newD).zMult(edec.getV(), null, 1.0, 0.0, false, true);
            x0 = Algebra.DEFAULT.mult(qi, ncball).viewColumn(0);
            double qb = 2.0 * lvec.zDotProduct(x0);
            double a1 = MinVolEllipse.quadraticFormula(1.0, qb, qc = x0.zDotProduct(x0) - 1.0, true, false);
            if (!Double.isNaN(a1)) {
                double a2 = MinVolEllipse.quadraticFormula(1.0, qb, qc, false, true);
                double a = a1;
                if (a2 * a2 > a1 * a1) {
                    a = a2;
                }
                y = lvec.copy();
                y.assign(Functions.mult((double)a));
                y.assign(x0, Functions.plus);
                useBisection = false;
            }
        }
        if (useBisection) {
            double top = Math.sqrt(Algebra.DEFAULT.norm2(cball)) - lambda;
            double bottom = -lambda;
            double bisecPrecision = 1.0E-10;
            for (double mid : new double[]{top *= 1.0000000001, bottom * 1.0000000001}) {
                DoubleMatrix2D Qshifted = Qball.copy().assign(DoubleFactory2D.dense.diagonal(DoubleFactory1D.dense.make(n, mid)), Functions.plus);
                y = Algebra.DEFAULT.solve(Qshifted, ncball).viewColumn(0);
                double check = y.zDotProduct(y);
                if (check > 1.0 != (mid == top)) continue;
                System.err.println("ERROR IN maximizeQuadratic2 bisection: root not bracketed!");
                DoubleMatrix1D checkncball = Algebra.DEFAULT.mult(Qshifted, y);
                DoubleMatrix1D checkncball0 = Algebra.DEFAULT.mult(Qshifted, x0);
                double d = 0.0;
            }
            double mid = 0.0;
            while (top - bottom > bisecPrecision * Math.max(Math.abs(top), Math.abs(bottom))) {
                mid = (top + bottom) / 2.0;
                DoubleMatrix2D Qshifted = Qball.copy().assign(DoubleFactory2D.dense.diagonal(DoubleFactory1D.dense.make(n, mid)), Functions.plus);
                y = Algebra.DEFAULT.solve(Qshifted, ncball).viewColumn(0);
                if (y.zDotProduct(y) > 1.0) {
                    bottom = mid;
                    continue;
                }
                top = mid;
            }
        }
        DoubleMatrix1D x = this.c.copy();
        x = invC.zMult(y, x, 1.0, 1.0, true);
        for (int a = 0; a < n; ++a) {
            amax.set(a, x.get(a));
        }
        amax.set(n, 1.0);
        return augMatrix.zMult(amax, null).zDotProduct(amax);
    }

    static double quadraticFormula(double a, double b, double c, boolean firstRoot, boolean errorOnComplex) {
        double discr = b * b - 4.0 * a * c;
        if (a == 0.0) {
            if (b == 0.0) {
                throw new RuntimeException("ERROR: Can't solve equation " + c + "=0 by quadratic formula");
            }
            return -c / b;
        }
        if (discr < 0.0) {
            if (errorOnComplex) {
                throw new RuntimeException("ERROR: Negative discrimant in quadratic formula");
            }
            return Double.NaN;
        }
        if (b > 0.0) {
            if (firstRoot) {
                return (-b - Math.sqrt(discr)) / (2.0 * a);
            }
            return 2.0 * c / (-b - Math.sqrt(discr));
        }
        if (firstRoot) {
            return (-b + Math.sqrt(discr)) / (2.0 * a);
        }
        return 2.0 * c / (-b + Math.sqrt(discr));
    }

    public DoubleMatrix2D getA() {
        return this.A.copy();
    }

    public DoubleMatrix1D getC() {
        return this.c.copy();
    }

    public DoubleMatrix1D getNC() {
        return this.nc.copy();
    }
}

