/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.Factory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.io.FileUtils;

public class ObjectIO {
    public static Object readObject(String fileName, boolean allowNull) {
        Object inObj = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
            inObj = in.readObject();
            in.close();
        }
        catch (Exception e) {
            if (allowNull) {
                return null;
            }
            throw new RuntimeException("ERROR: Failed to read object from file " + fileName + "\n" + e.getMessage());
        }
        return inObj;
    }

    public static <T> T read(String path2, Class<T> type) throws BadFileException {
        return ObjectIO.read(new File(path2), type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T read(File file, Class<T> type) throws BadFileException {
        if (!file.exists()) {
            return null;
        }
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
            Object castObj;
            Object obj = in.readObject();
            if (obj == null) {
                throw new BadFileException(file, "file contained no data");
            }
            if (!type.isAssignableFrom(obj.getClass())) {
                throw new BadFileException(file, "file did not contain a " + type.getName());
            }
            Object object = castObj = obj;
            return (T)object;
        }
        catch (StackOverflowError ex) {
            throw new Error("stack overflow, consider increasing -Xss", ex);
        }
        catch (InvalidClassException | OptionalDataException | ClassNotFoundException ex) {
            throw new BadFileException(file, "Osprey version doesn't match file", ex);
        }
        catch (IOException ex) {
            throw new BadFileException(file, "file is unreadable or corrupt", ex);
        }
    }

    public static void writeObject(Object outObj, String outFile) {
        try {
            FileOutputStream fout = new FileOutputStream(outFile);
            ObjectOutputStream out = new ObjectOutputStream(fout);
            out.writeObject(outObj);
            out.close();
        }
        catch (StackOverflowError ex) {
            throw new Error("Stack overflow in deepCopy.  Consider increasing -Xss");
        }
        catch (Exception ex) {
            throw new Error("can't write object", ex);
        }
    }

    public static void write(Object obj, String path2) throws CantWriteException {
        ObjectIO.write(obj, new File(path2));
    }

    public static void write(Object obj, File file) throws CantWriteException {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(obj);
        }
        catch (InvalidClassException | NotSerializableException ex) {
            throw new Error("Can't write file data, classes not configured for serialization. This is a bug", ex);
        }
        catch (StackOverflowError ex) {
            throw new Error("stack overflow, consider increasing -Xss", ex);
        }
        catch (IOException ex) {
            throw new CantWriteException(file, (Throwable)ex);
        }
    }

    public static <T> T readOrMake(File file, Class<T> type, String name, Factory<T, Void> factory) {
        return (T)ObjectIO.readOrMake(file, type, name, thing -> true, factory);
    }

    public static <T> T readOrMake(File file, Class<T> type, String name, Validator<T> validator, Factory<T, Void> factory) {
        T thing;
        try {
            thing = ObjectIO.read(file, type);
            if (thing != null) {
                System.out.println("read " + name + " from file: " + file.getAbsolutePath());
                if (validator.isValid(thing)) {
                    return thing;
                }
                System.out.println("WARNING: " + name + " from file is invalid, will create new one");
            }
        }
        catch (BadFileException ex) {
            ex.printStackTrace(System.out);
            System.out.println("WARNING: can't read " + name + ", will create new one");
        }
        thing = factory.make(null);
        try {
            ObjectIO.write(thing, file);
            System.out.println("wrote " + name + " to file: " + file.getAbsolutePath());
        }
        catch (CantWriteException ex) {
            ex.printStackTrace(System.out);
            System.out.println("WARNING: can't write " + name + ", will have to be created again next time");
        }
        return thing;
    }

    public static <T> T readOrThrow(File file, Class<T> type, String name, Validator<T> validator) {
        try {
            T thing = ObjectIO.read(file, type);
            if (thing == null) {
                throw new RuntimeException("file not found: " + file.getAbsolutePath());
            }
            System.out.println("read " + name + " from file: " + file.getAbsolutePath());
            if (!validator.isValid(thing)) {
                throw new RuntimeException(name + " from file is invalid");
            }
            return thing;
        }
        catch (BadFileException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object deepCopy(Object oldObj) {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object ans = ois.readObject();
            oos.close();
            ois.close();
            return ans;
        }
        catch (StackOverflowError ex) {
            throw new Error("Stack overflow in deepCopy.  Consider increasing -Xss");
        }
        catch (Exception ex) {
            throw new Error("can't deep-copy object", ex);
        }
    }

    public static File[] getFilesInDir(String path2) {
        File[] listOfFiles = null;
        File loc = new File(path2);
        if (loc.isDirectory()) {
            listOfFiles = loc.listFiles();
        }
        return listOfFiles;
    }

    public static void delete(String path2) {
        try {
            File loc = new File(path2);
            if (loc.exists()) {
                if (loc.isDirectory()) {
                    FileUtils.deleteDirectory((File)loc);
                } else {
                    loc.delete();
                }
            }
        }
        catch (IOException ex) {
            throw new Error("can't delete file: " + path2, ex);
        }
    }

    public static void makeDir(String path2, boolean deleteExisting) {
        File dir = new File(path2);
        if (deleteExisting && dir.exists()) {
            ObjectIO.delete(path2);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static String formatBigDecimal(BigDecimal x, int decimalPoints) {
        DecimalFormat formatter = new DecimalFormat("0.0E0");
        ((NumberFormat)formatter).setRoundingMode(RoundingMode.CEILING);
        ((NumberFormat)formatter).setMinimumFractionDigits(decimalPoints);
        return formatter.format(x);
    }

    public static class BadFileException
    extends Exception {
        private static final long serialVersionUID = -9191066141220686516L;
        private static final String MsgFormat = "Can't load file data from %s: %s";

        public BadFileException(File file, String msg) {
            super(String.format(MsgFormat, file.getAbsolutePath(), msg));
        }

        public BadFileException(File file, String msg, Throwable cause) {
            super(String.format(MsgFormat, file.getAbsolutePath(), msg), cause);
        }
    }

    public static class CantWriteException
    extends Exception {
        private static final long serialVersionUID = 8152920955998224621L;
        private static final String MsgFormat = "Can't write file data to %s";

        public CantWriteException(File file, Throwable cause) {
            super(String.format(MsgFormat, file.getAbsolutePath()), cause);
        }
    }

    public static interface Validator<T> {
        public boolean isValid(T var1);
    }
}

