/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrefixTreeSet<T> {
    private Map<T, Node> roots = new HashMap<T, Node>();

    public void add(List<T> sequence) {
        Map<T, Node> nodes = this.roots;
        Iterator<T> iter = sequence.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            boolean isLastItem = !iter.hasNext();
            Node node = nodes.get(item);
            if (node == null) {
                node = new Node(this, item, isLastItem);
                nodes.put(item, node);
            }
            nodes = node.children;
        }
    }

    public boolean contains(List<T> sequence) {
        if (sequence.isEmpty()) {
            return false;
        }
        Map<T, Node> nodes = this.roots;
        Iterator<T> iter = sequence.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            boolean isLastItem = !iter.hasNext();
            Node node = nodes.get(item);
            if (node == null) {
                return false;
            }
            if (isLastItem) {
                return node.isLeaf;
            }
            nodes = node.children;
        }
        throw new Error("unpossible");
    }

    private class Node {
        public final T value;
        public final boolean isLeaf;
        public Map<T, Node> children = new HashMap();

        public Node(PrefixTreeSet prefixTreeSet, T value2, boolean isLeaf) {
            this.value = value2;
            this.isLeaf = isLeaf;
        }
    }
}

