/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.Stopwatch;
import edu.duke.cs.osprey.tools.TimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Profiler {
    private Map<String, Stopwatch> stopwatches = new LinkedHashMap<String, Stopwatch>();
    private Stopwatch current = null;

    public Profiler() {
    }

    public Profiler(String name) {
        this();
        this.start(name);
    }

    public Stopwatch getOrMake(String name) {
        Stopwatch stopwatch = this.stopwatches.get(name);
        if (stopwatch == null) {
            stopwatch = new Stopwatch();
            this.stopwatches.put(name, stopwatch);
        }
        return stopwatch;
    }

    public void start(String name) {
        this.stop();
        this.current = this.getOrMake(name);
        this.current.start();
    }

    public void resume(String name) {
        this.stop();
        this.current = this.getOrMake(name);
        this.current.resume();
    }

    public void stop() {
        if (this.current != null) {
            this.current.stop();
            this.current = null;
        }
    }

    public String makeReport(TimeUnit timeUnit) {
        this.stop();
        StringBuilder buf = new StringBuilder();
        buf.append("profiling:");
        long totalNs = 0L;
        for (Map.Entry<String, Stopwatch> entry : this.stopwatches.entrySet()) {
            buf.append(String.format("   %s: %8s", entry.getKey(), entry.getValue().getTime(timeUnit)));
            totalNs += entry.getValue().getTimeNs();
        }
        buf.append(String.format("   %s: %8s", "total", TimeFormatter.format(totalNs, timeUnit)));
        buf.append(String.format(" %10.2f ops", Float.valueOf(1.0E9f / (float)totalNs)));
        return buf.toString();
    }
}

