/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;

public class Protractor {
    public static double getAngleRadians(double[] vec1, double[] vec2) {
        double costh = VectorAlgebra.dot(vec1, vec2) / (VectorAlgebra.norm(vec1) * VectorAlgebra.norm(vec2));
        if (costh > 1.0) {
            costh = 1.0;
        } else if (costh < -1.0) {
            costh = -1.0;
        }
        return Math.acos(costh);
    }

    public static double getAngleDegrees(double[] vec1, double[] vec2) {
        return Math.toDegrees(Protractor.getAngleRadians(vec1, vec2));
    }

    public static double getAngleDegrees(double[] A, double[] B, double[] C) {
        return Math.toDegrees(Protractor.getAngleRadians(A, B, C));
    }

    public static double getAngleRadians(double[] A, double[] B, double[] C) {
        double[] BA = VectorAlgebra.subtract(A, B);
        double[] BC = VectorAlgebra.subtract(C, B);
        return Protractor.getAngleRadians(BA, BC);
    }

    public static double getLongitudeRadians(double[] pt, double[] northPole, double[] london) {
        double[] ptComp = VectorAlgebra.perpendicularComponent(pt, northPole);
        if (VectorAlgebra.normsq(ptComp) < 1.0E-14) {
            return 0.0;
        }
        double[] londonComp = VectorAlgebra.perpendicularComponent(london, northPole);
        double ans = Protractor.getAngleRadians(ptComp, londonComp);
        if (VectorAlgebra.dot(VectorAlgebra.cross(london, pt), northPole) < 0.0) {
            return -ans;
        }
        return ans;
    }

    public static double measureBondAngle(double[] coords, int[] indices) {
        return Protractor.measureBondAngle(coords, indices[0], indices[1], indices[2]);
    }

    public static double measureBondAngle(double[] coords, int a, int b, int c) {
        return Protractor.measureBondAngle(coords, a, coords, b, coords, c);
    }

    public static double measureBondAngle(double[][] coords) {
        return Protractor.measureBondAngle(coords[0], 0, coords[1], 0, coords[2], 0);
    }

    public static double measureBondAngle(double[] acoords, int aindex, double[] bcoords, int bindex, double[] ccoords, int cindex) {
        int a3 = aindex * 3;
        int b3 = bindex * 3;
        int c3 = cindex * 3;
        double bax = acoords[a3] - bcoords[b3];
        double bay = acoords[a3 + 1] - bcoords[b3 + 1];
        double baz = acoords[a3 + 2] - bcoords[b3 + 2];
        double bcx = ccoords[c3] - bcoords[b3];
        double bcy = ccoords[c3 + 1] - bcoords[b3 + 1];
        double bcz = ccoords[c3 + 2] - bcoords[b3 + 2];
        double cos = bax * bcx + bay * bcy + baz * bcz;
        cos /= Math.sqrt(bax * bax + bay * bay + baz * baz);
        if ((cos /= Math.sqrt(bcx * bcx + bcy * bcy + bcz * bcz)) <= -1.0) {
            return -180.0;
        }
        if (cos >= 1.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.acos(cos));
    }

    public static double measureDihedral(double[] coords, int[] indices) {
        return Protractor.measureDihedral(coords, indices[0], indices[1], indices[2], indices[3]);
    }

    public static double measureDihedral(double[] coords, int a, int b, int c, int d) {
        return Protractor.measureDihedral(coords, a, coords, b, coords, c, coords, d);
    }

    public static double measureDihedral(double[][] coords) {
        return Protractor.measureDihedral(coords[0], 0, coords[1], 0, coords[2], 0, coords[3], 0);
    }

    public static double[] measureDihedralSinCos(double[][] coords) {
        return Protractor.measureDihedralSinCos(coords[0], 0, coords[1], 0, coords[2], 0, coords[3], 0);
    }

    public static double measureDihedral(double[] acoords, int aindex, double[] bcoords, int bindex, double[] ccoords, int cindex, double[] dcoords, int dindex) {
        double[] sincos = Protractor.measureDihedralSinCos(acoords, aindex, bcoords, bindex, ccoords, cindex, dcoords, dindex);
        double angleRadians = Math.atan2(sincos[0], sincos[1]);
        return Protractor.normalizeDegrees(Math.toDegrees(angleRadians));
    }

    public static double[] measureDihedralSinCos(double[] coords, int aindex, int bindex, int cindex, int dindex) {
        return Protractor.measureDihedralSinCos(coords, aindex, coords, bindex, coords, cindex, coords, dindex);
    }

    public static double[] measureDihedralSinCos(double[] acoords, int aindex, double[] bcoords, int bindex, double[] ccoords, int cindex, double[] dcoords, int dindex) {
        int a3 = aindex * 3;
        int b3 = bindex * 3;
        int c3 = cindex * 3;
        int d3 = dindex * 3;
        double bax = acoords[a3] - bcoords[b3];
        double bay = acoords[a3 + 1] - bcoords[b3 + 1];
        double baz = acoords[a3 + 2] - bcoords[b3 + 2];
        double bcx = ccoords[c3] - bcoords[b3];
        double bcy = ccoords[c3 + 1] - bcoords[b3 + 1];
        double bcz = ccoords[c3 + 2] - bcoords[b3 + 2];
        double dcx = ccoords[c3] - dcoords[d3];
        double dcy = ccoords[c3 + 1] - dcoords[d3 + 1];
        double dcz = ccoords[c3 + 2] - dcoords[d3 + 2];
        double dx = bay * bcz - baz * bcy;
        double dy = baz * bcx - bax * bcz;
        double dz = bax * bcy - bay * bcx;
        double gx = bcz * dcy - bcy * dcz;
        double gy = bcx * dcz - bcz * dcx;
        double gz = bcy * dcx - bcx * dcy;
        double bi = dx * dx + dy * dy + dz * dz;
        double bk = gx * gx + gy * gy + gz * gz;
        double norm = Math.sqrt(bi * bk);
        double cos = (dx * gx + dy * gy + dz * gz) / norm;
        double vx = gy * dz - gz * dy;
        double vy = gz * dx - gx * dz;
        double vz = gx * dy - gy * dx;
        double sin = Math.sqrt(vx * vx + vy * vy + vz * vz) / norm;
        double bcdotv = bcx * vx + bcy * vy + bcz * vz;
        cos = -cos;
        if (bcdotv < 0.0) {
            sin = -sin;
        }
        return new double[]{sin, cos};
    }

    @Deprecated
    public static double[] getHalfAngleSinCos(double sinTheta, double cosTheta) {
        double s2 = (1.0 - cosTheta) / 2.0;
        double c2 = (1.0 + cosTheta) / 2.0;
        if (s2 < 0.0) {
            s2 = 0.0;
        }
        if (c2 < 0.0) {
            c2 = 0.0;
        }
        double[] ans = new double[]{Math.sqrt(s2), Math.sqrt(c2)};
        if (sinTheta < 0.0) {
            ans[1] = ans[1] * -1.0;
        }
        return ans;
    }

    public static double[] getPhiPsi(Residue res) {
        double[] ans = new double[2];
        if (res.indexInMolecule == 0 || res.indexInMolecule == res.molec.residues.size() - 1) {
            return new double[]{Double.NaN, Double.NaN};
        }
        Residue prevRes = (Residue)res.molec.residues.get(res.indexInMolecule - 1);
        Residue nextRes = (Residue)res.molec.residues.get(res.indexInMolecule + 1);
        double[] CLast = prevRes.getCoordsByAtomName("C");
        double[] NCur = res.getCoordsByAtomName("N");
        double[] CACur = res.getCoordsByAtomName("CA");
        double[] CCur = res.getCoordsByAtomName("C");
        double[] NNext = nextRes.getCoordsByAtomName("N");
        if (CLast == null || NCur == null || CACur == null || CCur == null || NNext == null) {
            return new double[]{Double.NaN, Double.NaN};
        }
        ans[0] = Protractor.measureDihedral(new double[][]{CLast, NCur, CACur, CCur});
        ans[1] = Protractor.measureDihedral(new double[][]{NCur, CACur, CCur, NNext});
        return ans;
    }

    public static double normalizeDegrees(double angleDegrees) {
        if (!Double.isFinite(angleDegrees)) {
            throw new IllegalArgumentException("can't normalize angle: " + angleDegrees);
        }
        while (angleDegrees <= -180.0) {
            angleDegrees += 360.0;
        }
        while (angleDegrees > 180.0) {
            angleDegrees -= 360.0;
        }
        assert (angleDegrees > -180.0);
        assert (angleDegrees <= 180.0);
        return angleDegrees;
    }

    public static double normalizeMinusPiToPi(double angleRadians) {
        if (!Double.isFinite(angleRadians)) {
            throw new IllegalArgumentException("can't normalize angle: " + angleRadians);
        }
        while (angleRadians <= -Math.PI) {
            angleRadians += Math.PI * 2;
        }
        while (angleRadians > Math.PI) {
            angleRadians -= Math.PI * 2;
        }
        assert (angleRadians > -Math.PI);
        assert (angleRadians <= Math.PI);
        return angleRadians;
    }

    public static double getDistDegrees(double a, double b) {
        return Math.abs(Protractor.getDeltaDegrees(a, b));
    }

    public static double getDeltaDegrees(double a, double b) {
        return Protractor.normalizeDegrees(b - a);
    }

    public static double getFrameDegrees(double[] axis, double[] zero, double[] v) {
        double degrees = Protractor.getAngleDegrees(v, zero);
        if (VectorAlgebra.dot(VectorAlgebra.cross(axis, zero), v) < 0.0) {
            degrees = -degrees;
        }
        return degrees;
    }

    public static double measureBondLength(double[] coords, int aindex, int bindex) {
        return Protractor.measureBondLength(coords, aindex, coords, bindex);
    }

    public static double measureBondLength(double[] acoords, int aindex, double[] bcoords, int bindex) {
        int a3 = aindex * 3;
        int b3 = bindex * 3;
        double dx = acoords[a3] - bcoords[b3];
        double dy = acoords[a3 + 1] - bcoords[b3 + 1];
        double dz = acoords[a3 + 2] - bcoords[b3 + 2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static class TetrahedralGeometry {
        public double[] ba = new double[3];
        public double[] bc = new double[3];
        public double[] bd = new double[3];
        public double[] center = new double[3];
        public double[] inPlaneAxis = new double[3];
        public double[] outOfPlaneAxis = new double[3];
        public double[] baflat = new double[3];
        public double[] bcflat = new double[3];
        public double[] bdflat = new double[3];
        public double inPlaneDegrees = Double.NaN;
        public double outOfPlaneDegrees = Double.NaN;

        public void update(double[] coords, int aindex, int bindex, int cindex, int dindex) {
            this.update(coords, aindex, coords, bindex, coords, cindex, coords, dindex);
        }

        public void update(double[] acoords, int aindex, double[] bcoords, int bindex, double[] ccoords, int cindex, double[] dcoords, int dindex) {
            int a3 = aindex * 3;
            int b3 = bindex * 3;
            int c3 = cindex * 3;
            int d3 = dindex * 3;
            this.center[0] = bcoords[b3];
            this.center[1] = bcoords[b3 + 1];
            this.center[2] = bcoords[b3 + 2];
            this.ba[0] = acoords[a3] - this.center[0];
            this.ba[1] = acoords[a3 + 1] - this.center[1];
            this.ba[2] = acoords[a3 + 2] - this.center[2];
            this.bc[0] = ccoords[c3] - this.center[0];
            this.bc[1] = ccoords[c3 + 1] - this.center[1];
            this.bc[2] = ccoords[c3 + 2] - this.center[2];
            this.bd[0] = dcoords[d3] - this.center[0];
            this.bd[1] = dcoords[d3 + 1] - this.center[1];
            this.bd[2] = dcoords[d3 + 2] - this.center[2];
            VectorAlgebra.copy(VectorAlgebra.cross(this.ba, this.bc), this.outOfPlaneAxis);
            VectorAlgebra.normalizeInPlace(this.outOfPlaneAxis);
            VectorAlgebra.copy(VectorAlgebra.perpendicularComponent(this.ba, this.outOfPlaneAxis), this.baflat);
            VectorAlgebra.copy(VectorAlgebra.perpendicularComponent(this.bc, this.outOfPlaneAxis), this.bcflat);
            VectorAlgebra.copy(VectorAlgebra.perpendicularComponent(this.bd, this.outOfPlaneAxis), this.bdflat);
            VectorAlgebra.copy(VectorAlgebra.normalize(this.baflat), this.inPlaneAxis);
            VectorAlgebra.addInPlace(this.inPlaneAxis, VectorAlgebra.normalize(this.bcflat));
            VectorAlgebra.scaleInPlace(this.inPlaneAxis, -0.5);
            VectorAlgebra.normalizeInPlace(this.inPlaneAxis);
            this.inPlaneDegrees = Protractor.getFrameDegrees(this.outOfPlaneAxis, this.inPlaneAxis, this.bdflat);
            this.outOfPlaneDegrees = Protractor.getAngleDegrees(this.bd, this.outOfPlaneAxis);
            this.outOfPlaneDegrees -= 90.0;
        }

        public Angles getAngles() {
            return new Angles(this.inPlaneDegrees, this.outOfPlaneDegrees);
        }

        public static class Angles {
            public final double inPlaneDegrees;
            public final double outOfPlaneDegrees;

            public Angles(double inPlaneDegrees, double outOfPlaneDegrees) {
                this.inPlaneDegrees = inPlaneDegrees;
                this.outOfPlaneDegrees = outOfPlaneDegrees;
            }
        }
    }
}

