/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.plug.LPChecks;
import edu.duke.cs.osprey.plug.PolytopeMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import edu.duke.cs.osprey.tupexp.TupleExpander;
import java.util.ArrayList;
import org.apache.commons.math3.optim.linear.LinearConstraint;

public class BasicPruningTupleExpander
extends TupleExpander {
    PruningMatrix pruneMat;
    PolytopeMatrix plugMat;

    public BasicPruningTupleExpander(PruningMatrix pruneMat, PolytopeMatrix plugMat) {
        super(pruneMat.getNumPos(), pruneMat.getNumConfAtPos(), pruneMat.getPruningInterval(), new LUTESettings());
        this.pruneMat = pruneMat;
        this.plugMat = plugMat;
        if (plugMat != null) {
            throw new RuntimeException("ERROR: Expected rejectInf to be on...");
        }
    }

    @Override
    public double scoreAssignmentList(int[] assignmentList) {
        if (this.isPruned(new RCTuple(assignmentList))) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.plugMat != null) {
            ArrayList<LinearConstraint> fullPolytope = this.plugMat.getFullPolytope(new RCTuple(assignmentList));
            if (fullPolytope == null) {
                return Double.POSITIVE_INFINITY;
            }
            if (!LPChecks.polytopeHasFeasiblePt(fullPolytope)) {
                return Double.POSITIVE_INFINITY;
            }
        }
        return 0.0;
    }

    @Override
    public boolean isPruned(RCTuple tup) {
        return this.pruneMat.isPruned(tup);
    }

    @Override
    public void pruneTuple(RCTuple tup) {
        this.pruneMat.markAsPruned(tup);
    }

    @Override
    public ArrayList<RCTuple> higherOrderPrunedTuples(RCTuple tup) {
        if (tup.pos.size() != 2) {
            throw new RuntimeException("ERROR: higherOrderPrunedTuples is meant to take an RC pair as argument");
        }
        HigherTupleFinder<Boolean> htf = this.pruneMat.getHigherOrderTerms(tup.pos.get(0), tup.RCs.get(0), tup.pos.get(1), tup.RCs.get(1));
        if (htf != null) {
            ArrayList<RCTuple> otherTups = htf.listInteractionsWithValue(true);
            for (RCTuple otherTup : otherTups) {
                for (int i = 0; i < 2; ++i) {
                    otherTup.pos.add(tup.pos.get(i));
                    otherTup.RCs.add(tup.RCs.get(i));
                }
            }
            return otherTups;
        }
        return new ArrayList<RCTuple>();
    }
}

