/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.tupexp.TupleIndexMatrix;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.ConjugateGradient;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;

public class CGTupleFitter {
    RealLinearOperator AtA;
    RealVector Atb;
    int numSamp;
    int numTup;
    TupleIndexMatrix tupIndMat;
    ArrayList<int[]> samples;
    ArrayList<Double> weights;

    public CGTupleFitter() {
    }

    public CGTupleFitter(TupleIndexMatrix tim, ArrayList<int[]> samp, int numTuples, double[] trueVals, final ArrayList<Double> weights) {
        this.samples = samp;
        this.numSamp = this.samples.size();
        this.numTup = numTuples;
        this.tupIndMat = tim;
        this.weights = weights;
        this.AtA = new RealLinearOperator(){

            public int getRowDimension() {
                return CGTupleFitter.this.numTup;
            }

            public int getColumnDimension() {
                return CGTupleFitter.this.numTup;
            }

            public RealVector operate(RealVector rv) throws DimensionMismatchException {
                double[] Arv = new double[CGTupleFitter.this.numSamp];
                for (int s = 0; s < CGTupleFitter.this.numSamp; ++s) {
                    ArrayList<Integer> sampTup = CGTupleFitter.this.tupIndMat.calcSampleTuples(CGTupleFitter.this.samples.get(s));
                    for (int t : sampTup) {
                        int n = s;
                        Arv[n] = Arv[n] + rv.getEntry(t);
                    }
                }
                double[] ans = new double[CGTupleFitter.this.numTup];
                for (int s = 0; s < CGTupleFitter.this.numSamp; ++s) {
                    ArrayList<Integer> sampTup = CGTupleFitter.this.tupIndMat.calcSampleTuples(CGTupleFitter.this.samples.get(s));
                    Iterator<Integer> iterator2 = sampTup.iterator();
                    while (iterator2.hasNext()) {
                        int t;
                        int n = t = iterator2.next().intValue();
                        ans[n] = ans[n] + Arv[s] * (Double)weights.get(s);
                    }
                }
                return new ArrayRealVector(ans, false);
            }
        };
        double[] atb = new double[this.numTup];
        for (int s = 0; s < this.numSamp; ++s) {
            ArrayList<Integer> sampTup = this.tupIndMat.calcSampleTuples(this.samples.get(s));
            Iterator<Integer> iterator2 = sampTup.iterator();
            while (iterator2.hasNext()) {
                int t;
                int n = t = iterator2.next().intValue();
                atb[n] = atb[n] + trueVals[s] * weights.get(s);
            }
        }
        this.Atb = new ArrayRealVector(atb);
    }

    double[] doFit() {
        ConjugateGradient cg = new ConjugateGradient(100000, 1.0E-6, false);
        long startTime = System.currentTimeMillis();
        RealVector ans = cg.solve(this.AtA, this.Atb);
        System.out.println("Conjugate gradient fitting time (ms): " + (System.currentTimeMillis() - startTime));
        return ans.toArray();
    }
}

