/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.voxq;

public abstract class BoltzmannIntegrator1D {
    double a;
    double b;
    int numSlices = 50;

    public BoltzmannIntegrator1D(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public abstract double f(double var1);

    private double evalBoltz(double x) {
        return Math.exp(-this.f(x) / 0.593050165);
    }

    public double doIntegral() {
        double sliceWidth = (this.b - this.a) / (double)this.numSlices;
        double num = this.evalBoltz(this.a) + this.evalBoltz(this.b);
        double denom = 2.0;
        for (int slice = 1; slice < this.numSlices; ++slice) {
            double weight = 4.0;
            if (slice % 2 == 0) {
                weight = 2.0;
            }
            num += weight * this.evalBoltz(this.a + (double)slice * sliceWidth);
            denom += weight;
        }
        double integ = num * (this.b - this.a) / denom;
        return integ;
    }
}

