/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.voxq;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.epic.EPICMatrix;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.IdealSeparableReference;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.voxq.VoxelsDeltaG;

public class VoxelGCalculator {
    EnergyMatrix emat;
    EPICMatrix epicMat1;
    EPICMatrix epicMat2;

    public VoxelGCalculator(SearchProblem sp) {
        if (!sp.useEPIC) {
            throw new RuntimeException("ERROR NEED EPIC FOR BAR+LUTE");
        }
        this.epicMat1 = sp.epicMat;
        this.epicMat2 = (EPICMatrix)ObjectIO.deepCopy(this.epicMat1);
        this.emat = sp.emat;
    }

    public double calcG(int[] assignmentList) {
        MoleculeModifierAndScorer mms1 = new MoleculeModifierAndScorer(this.epicMat1.internalEnergyFunction(new RCTuple(assignmentList), true), this.epicMat1.getConfSpace(), new RCTuple(assignmentList));
        CCDMinimizer ccdMin = new CCDMinimizer(mms1, false);
        DoubleMatrix1D center = ccdMin.minimize().dofValues;
        IdealSeparableReference mms2 = new IdealSeparableReference((EnergyFunction)this.epicMat2.internalEnergyFunction(new RCTuple(assignmentList), true), this.epicMat2.getConfSpace(), new RCTuple(assignmentList), center);
        VoxelsDeltaG vdg = new VoxelsDeltaG(mms2, mms1, false);
        double E = vdg.estDeltaG(0.05);
        E += mms2.calcG();
        double voxelVolume = this.computeVoxelVolume(mms1.getConstraints());
        return E += 0.593050165 * Math.log(voxelVolume);
    }

    double computeVoxelVolume(DoubleMatrix1D[] voxelBounds) {
        double vol = 1.0;
        for (int dim = 0; dim < voxelBounds[0].size(); ++dim) {
            vol *= voxelBounds[1].get(dim) - voxelBounds[0].get(dim);
        }
        return vol;
    }
}

