/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.feature.Standardizer;
import smile.math.Math;
import smile.sort.QuickSelect;

public class RobustStandardizer
extends Standardizer {
    public RobustStandardizer() {
    }

    public RobustStandardizer(boolean copy) {
        super(copy);
    }

    @Override
    public void learn(Attribute[] attributes, double[][] data) {
        int n = data.length;
        int p = data[0].length;
        this.mu = new double[p];
        this.std = new double[p];
        double[] x = new double[n];
        for (int j = 0; j < p; ++j) {
            if (attributes[j].getType() != Attribute.Type.NUMERIC) {
                this.mu[j] = Double.NaN;
                continue;
            }
            for (int i = 0; i < n; ++i) {
                x[i] = data[i][j];
            }
            this.mu[j] = QuickSelect.median((double[])x);
            this.std[j] = QuickSelect.q3((double[])x) - QuickSelect.q1((double[])x);
            if (!Math.isZero((double)this.std[j])) continue;
            throw new IllegalArgumentException("Column " + j + " has constant values between Q1 and Q3.");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RobustStandardizer(");
        if (this.mu != null) {
            sb.append("\n");
            for (int i = 0; i < this.mu.length; ++i) {
                sb.append(String.format("  [%.4f, %.4f]%n", this.mu[i], this.std[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

