/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.util.HashSet;

public class ConfusionMatrix {
    private int[][] matrix;

    public ConfusionMatrix(int[] truth, int[] prediction) {
        int i;
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        HashSet<Integer> ySet = new HashSet<Integer>();
        for (i = 0; i < truth.length; ++i) {
            ySet.add(truth[i]);
            ySet.add(prediction[i]);
        }
        this.matrix = new int[ySet.size()][ySet.size()];
        for (i = 0; i < truth.length; ++i) {
            int[] nArray = this.matrix[truth[i]];
            int n = prediction[i];
            nArray[n] = nArray[n] + 1;
        }
        ySet.clear();
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ROW=truth and COL=predicted\n");
        for (int i = 0; i < this.matrix.length; ++i) {
            sb.append(String.format("class %2d |", i));
            for (int j = 0; j < this.matrix.length; ++j) {
                sb.append(String.format("%8d |", this.matrix[i][j]));
            }
            sb.append("\n");
        }
        return sb.toString().trim();
    }
}

