/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import smile.clustering.Clustering;
import smile.clustering.HierarchicalClustering;
import smile.clustering.linkage.WardLinkage;
import smile.math.Math;

public class BIRCH
implements Clustering<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int B;
    private double T;
    private int d;
    private Node root;
    private double[][] centroids;

    public BIRCH(int d, int B, double T) {
        this.d = d;
        this.B = B;
        this.T = T;
    }

    public void add(double[] x) {
        if (this.root == null) {
            this.root = new Node();
            this.root.add(new Leaf(x));
            this.root.update(x);
        } else {
            this.root.add(x);
        }
    }

    public int getBrachingFactor() {
        return this.B;
    }

    public double getMaxRadius() {
        return this.T;
    }

    public int dimension() {
        return this.d;
    }

    public int partition(int k) {
        return this.partition(k, 0);
    }

    public int partition(int k, int minPts) {
        int i;
        ArrayList<Leaf> leaves = new ArrayList<Leaf>();
        ArrayList<double[]> centers = new ArrayList<double[]>();
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.offer(this.root);
        Node node = (Node)queue.poll();
        while (node != null) {
            if (node.numChildren == 0) {
                if (node.n >= minPts) {
                    double[] x = new double[this.d];
                    for (i = 0; i < this.d; ++i) {
                        x[i] = node.sum[i] / (double)node.n;
                    }
                    centers.add(x);
                    leaves.add((Leaf)node);
                } else {
                    Leaf leaf = (Leaf)node;
                    leaf.y = Integer.MAX_VALUE;
                }
            } else {
                for (int i2 = 0; i2 < node.numChildren; ++i2) {
                    queue.offer(node.children[i2]);
                }
            }
            node = (Node)queue.poll();
        }
        int n = centers.size();
        this.centroids = (double[][])centers.toArray((T[])new double[n][]);
        if (n > k) {
            double[][] proximity = new double[n][];
            for (i = 0; i < n; ++i) {
                proximity[i] = new double[i + 1];
                for (int j = 0; j < i; ++j) {
                    proximity[i][j] = Math.distance((double[])this.centroids[i], (double[])this.centroids[j]);
                }
            }
            WardLinkage linkage = new WardLinkage(proximity);
            HierarchicalClustering hc = new HierarchicalClustering(linkage);
            int[] y = hc.partition(k);
            for (int i3 = 0; i3 < n; ++i3) {
                ((Leaf)leaves.get((int)i3)).y = y[i3];
            }
        } else {
            for (int i4 = 0; i4 < n; ++i4) {
                ((Leaf)leaves.get((int)i4)).y = i4;
            }
        }
        return n;
    }

    @Override
    public int predict(double[] x) {
        if (this.centroids == null) {
            throw new IllegalStateException("Call partition() first!");
        }
        Leaf leaf = this.root.search(x);
        return leaf.y;
    }

    public double[][] centroids() {
        if (this.centroids == null) {
            throw new IllegalStateException("Call partition() first!");
        }
        return this.centroids;
    }

    class Leaf
    extends Node {
        int y;

        Leaf(double[] x) {
            this.n = 1;
            System.arraycopy(x, 0, this.sum, 0, BIRCH.this.d);
        }

        @Override
        void add(double[] x) {
            ++this.n;
            for (int i = 0; i < BIRCH.this.d; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + x[i];
            }
        }
    }

    class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int n = 0;
        double[] sum;
        int numChildren;
        Node[] children;
        Node parent;

        Node() {
            this.sum = new double[BIRCH.this.d];
            this.parent = null;
            this.numChildren = 0;
            this.children = new Node[BIRCH.this.B];
        }

        double distance(double[] x) {
            double dist = 0.0;
            for (int i = 0; i < BIRCH.this.d; ++i) {
                double d = this.sum[i] / (double)this.n - x[i];
                dist += d * d;
            }
            return Math.sqrt((double)dist);
        }

        double distance(Node node) {
            double dist = 0.0;
            for (int i = 0; i < BIRCH.this.d; ++i) {
                double d = this.sum[i] / (double)this.n - node.sum[i] / (double)node.n;
                dist += d * d;
            }
            return Math.sqrt((double)dist);
        }

        Leaf search(double[] x) {
            int index = 0;
            double smallest = this.children[0].distance(x);
            for (int i = 1; i < this.numChildren; ++i) {
                double dist = this.children[i].distance(x);
                if (!(dist < smallest)) continue;
                index = i;
                smallest = dist;
            }
            if (this.children[index].numChildren == 0) {
                return (Leaf)this.children[index];
            }
            return this.children[index].search(x);
        }

        void update(double[] x) {
            ++this.n;
            for (int i = 0; i < BIRCH.this.d; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + x[i];
            }
        }

        void add(double[] x) {
            this.update(x);
            int index = 0;
            double smallest = this.children[0].distance(x);
            for (int i = 1; i < this.numChildren; ++i) {
                double dist = this.children[i].distance(x);
                if (!(dist < smallest)) continue;
                index = i;
                smallest = dist;
            }
            if (this.children[index] instanceof Leaf) {
                if (smallest > BIRCH.this.T) {
                    this.add(new Leaf(x));
                } else {
                    this.children[index].add(x);
                }
            } else {
                this.children[index].add(x);
            }
        }

        void add(Node node) {
            if (this.numChildren < BIRCH.this.B) {
                this.children[this.numChildren++] = node;
                node.parent = this;
            } else {
                if (this.parent == null) {
                    this.parent = new Node();
                    this.parent.add(this);
                    BIRCH.this.root = this.parent;
                } else {
                    this.parent.n = 0;
                    Arrays.fill(this.parent.sum, 0.0);
                }
                this.parent.add(this.split(node));
                for (int i = 0; i < this.parent.numChildren; ++i) {
                    this.parent.n += this.parent.children[i].n;
                    for (int j = 0; j < BIRCH.this.d; ++j) {
                        int n = j;
                        this.parent.sum[n] = this.parent.sum[n] + this.parent.children[i].sum[j];
                    }
                }
            }
        }

        Node split(Node node) {
            int j;
            int i;
            double farest = 0.0;
            int c1 = 0;
            int c2 = 0;
            double[][] dist = new double[this.numChildren + 1][this.numChildren + 1];
            for (int i2 = 0; i2 < this.numChildren; ++i2) {
                for (int j2 = i2 + 1; j2 < this.numChildren; ++j2) {
                    dist[i2][j2] = this.children[i2].distance(this.children[j2]);
                    dist[j2][i2] = dist[i2][j2];
                    if (!(farest < dist[i2][j2])) continue;
                    c1 = i2;
                    c2 = j2;
                    farest = dist[i2][j2];
                }
                dist[i2][this.numChildren] = this.children[i2].distance(node);
                dist[this.numChildren][i2] = dist[i2][this.numChildren];
                if (!(farest < dist[i2][this.numChildren])) continue;
                c1 = i2;
                c2 = this.numChildren;
                farest = dist[i2][this.numChildren];
            }
            int nc = this.numChildren;
            Node[] child = this.children;
            this.numChildren = 0;
            this.n = 0;
            Arrays.fill(this.sum, 0.0);
            Node brother = new Node();
            for (i = 0; i < nc; ++i) {
                if (dist[i][c1] < dist[i][c2]) {
                    this.add(child[i]);
                    continue;
                }
                brother.add(child[i]);
            }
            if (dist[nc][c1] < dist[nc][c2]) {
                this.add(node);
            } else {
                brother.add(node);
            }
            for (i = 0; i < this.numChildren; ++i) {
                this.n += this.children[i].n;
                for (j = 0; j < BIRCH.this.d; ++j) {
                    int n = j;
                    this.sum[n] = this.sum[n] + this.children[i].sum[j];
                }
            }
            for (i = 0; i < brother.numChildren; ++i) {
                brother.n += brother.children[i].n;
                for (j = 0; j < BIRCH.this.d; ++j) {
                    int n = j;
                    brother.sum[n] = brother.sum[n] + brother.children[i].sum[j];
                }
            }
            return brother;
        }
    }
}

