/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.feature.FeatureTransform;
import smile.math.Math;

public class Scaler
extends FeatureTransform {
    protected double[] lo;
    protected double[] hi;

    public Scaler() {
    }

    public Scaler(boolean copy) {
        super(copy);
    }

    @Override
    public void learn(Attribute[] attributes, double[][] data) {
        this.lo = Math.colMin((double[][])data);
        this.hi = Math.colMax((double[][])data);
        for (int i = 0; i < this.lo.length; ++i) {
            if (attributes[i].getType() != Attribute.Type.NUMERIC) {
                this.lo[i] = Double.NaN;
                continue;
            }
            int n = i;
            this.hi[n] = this.hi[n] - this.lo[i];
            if (!Math.isZero((double)this.hi[i])) continue;
            this.hi[i] = 1.0;
        }
    }

    @Override
    public double[] transform(double[] x) {
        if (x.length != this.lo.length) {
            throw new IllegalArgumentException(String.format("Invalid vector size %d, expected %d", x.length, this.lo.length));
        }
        double[] y = this.copy ? new double[x.length] : x;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(this.lo[i])) continue;
            double yi = (x[i] - this.lo[i]) / this.hi[i];
            if (yi < 0.0) {
                yi = 0.0;
            }
            if (yi > 1.0) {
                yi = 1.0;
            }
            y[i] = yi;
        }
        return y;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Scaler(");
        if (this.lo != null) {
            sb.append("\n");
            for (int i = 0; i < this.lo.length; ++i) {
                sb.append(String.format("  [%.4f, %.4f]%n", this.lo[i], this.hi[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

