/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.Arrays;
import smile.feature.FeatureRanking;
import smile.math.Math;

public class SumSquaresRatio
implements FeatureRanking {
    @Override
    public double[] rank(double[][] x, int[] y) {
        int j;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        int[] labels = Math.unique((int[])y);
        Arrays.sort(labels);
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] < 0) {
                throw new IllegalArgumentException("Negative class label: " + labels[i]);
            }
            if (i <= 0 || labels[i] - labels[i - 1] <= 1) continue;
            throw new IllegalArgumentException("Missing class: " + labels[i] + 1);
        }
        int k = labels.length;
        if (k < 2) {
            throw new IllegalArgumentException("Only one class.");
        }
        int n = x.length;
        int p = x[0].length;
        int[] nc = new int[k];
        double[] mu = new double[p];
        double[][] condmu = new double[k][p];
        for (int i = 0; i < n; ++i) {
            int yi;
            int n2 = yi = y[i];
            nc[n2] = nc[n2] + 1;
            for (j = 0; j < p; ++j) {
                int n3 = j;
                mu[n3] = mu[n3] + x[i][j];
                double[] dArray = condmu[yi];
                int n4 = j;
                dArray[n4] = dArray[n4] + x[i][j];
            }
        }
        for (int j2 = 0; j2 < p; ++j2) {
            int n5 = j2;
            mu[n5] = mu[n5] / (double)n;
            for (int i = 0; i < k; ++i) {
                double[] dArray = condmu[i];
                int n6 = j2;
                dArray[n6] = dArray[n6] / (double)nc[i];
            }
        }
        double[] wss = new double[p];
        double[] bss = new double[p];
        for (int i = 0; i < n; ++i) {
            int yi = y[i];
            for (int j3 = 0; j3 < p; ++j3) {
                int n7 = j3;
                bss[n7] = bss[n7] + Math.sqr((double)(condmu[yi][j3] - mu[j3]));
                int n8 = j3;
                wss[n8] = wss[n8] + Math.sqr((double)(x[i][j3] - condmu[yi][j3]));
            }
        }
        for (j = 0; j < p; ++j) {
            int n9 = j;
            bss[n9] = bss[n9] / wss[j];
        }
        return bss;
    }
}

