/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.matrix.SparseMatrix;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;

public class LLE {
    private static final Logger logger = LoggerFactory.getLogger(LLE.class);
    private int[] index;
    private double[][] coordinates;
    private Graph graph;

    public LLE(double[][] data, int d, int k) {
        int n = data.length;
        int D = data[0].length;
        double tol = 0.0;
        if (k > D) {
            logger.info("LLE: regularization will be used since K > D.");
            tol = 0.001;
        }
        NearestNeighborSearch knn = null;
        knn = D < 10 ? new KDTree(data, (E[])data) : new CoverTree((E[])data, new EuclideanDistance());
        Comparator<Neighbor<double[], double[]>> comparator = new Comparator<Neighbor<double[], double[]>>(){

            @Override
            public int compare(Neighbor<double[], double[]> o1, Neighbor<double[], double[]> o2) {
                return o1.index - o2.index;
            }
        };
        int[][] N = new int[n][k];
        this.graph = new AdjacencyList(n);
        for (int i = 0; i < n; ++i) {
            Neighbor<double[], V>[] neighbors = knn.knn(data[i], k);
            Arrays.sort(neighbors, comparator);
            for (int j = 0; j < k; ++j) {
                this.graph.setWeight(i, neighbors[j].index, neighbors[j].distance);
                N[i][j] = neighbors[j].index;
            }
        }
        int[][] cc = this.graph.bfs();
        int[] newIndex = new int[n];
        if (cc.length == 1) {
            this.index = new int[n];
            for (int i = 0; i < n; ++i) {
                this.index[i] = i;
                newIndex[i] = i;
            }
        } else {
            int i;
            n = 0;
            int component = 0;
            for (i = 0; i < cc.length; ++i) {
                if (cc[i].length <= n) continue;
                component = i;
                n = cc[i].length;
            }
            logger.info("LLE: {} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            this.index = cc[component];
            this.graph = this.graph.subgraph(this.index);
            for (i = 0; i < this.index.length; ++i) {
                newIndex[this.index[i]] = i;
            }
        }
        int len = n * k;
        double[] w = new double[len];
        int[] rowIndex = new int[len];
        int[] colIndex = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            colIndex[i] = colIndex[i - 1] + k;
        }
        DenseMatrix C = Matrix.zeros((int)k, (int)k);
        double[] b = new double[k];
        int m = 0;
        for (int i : this.index) {
            int p;
            double trace = 0.0;
            for (p = 0; p < k; ++p) {
                for (int q = 0; q < k; ++q) {
                    C.set(p, q, 0.0);
                    for (int l = 0; l < D; ++l) {
                        C.add(p, q, (data[i][l] - data[N[i][p]][l]) * (data[i][l] - data[N[i][q]][l]));
                    }
                }
                trace += C.get(p, p);
            }
            if (tol != 0.0) {
                trace *= tol;
                for (p = 0; p < k; ++p) {
                    C.add(p, p, trace);
                }
            }
            Arrays.fill(b, 1.0);
            LU lu = C.lu(true);
            lu.solve(b);
            double sum = Math.sum((double[])b);
            for (int p2 = 0; p2 < k; ++p2) {
                w[m * k + p2] = b[p2] / sum;
                rowIndex[m * k + p2] = newIndex[N[i][p2]];
            }
            ++m;
        }
        SparseMatrix Wt = new SparseMatrix(n, n, w, rowIndex, colIndex);
        IM im = new IM((Matrix)Wt);
        EVD eigen = im.eigen(Math.min((int)(10 * (d + 1)), (int)(n - 1)));
        DenseMatrix V = eigen.getEigenVectors();
        this.coordinates = new double[n][d];
        for (int j = 0; j < d; ++j) {
            for (int i = 0; i < n; ++i) {
                this.coordinates[i][j] = V.get(i, j + 1);
            }
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public Graph getNearestNeighborGraph() {
        return this.graph;
    }

    private static class IM
    extends Matrix {
        Matrix Wt;
        double[] Wx;
        double[] Wtx;

        public IM(Matrix Wt) {
            this.Wt = Wt;
            this.setSymmetric(true);
            this.Wx = new double[Wt.nrows()];
            this.Wtx = new double[Wt.ncols()];
        }

        public int nrows() {
            return this.Wt.nrows();
        }

        public int ncols() {
            return this.nrows();
        }

        public IM transpose() {
            return this;
        }

        public IM ata() {
            throw new UnsupportedOperationException();
        }

        public IM aat() {
            throw new UnsupportedOperationException();
        }

        public double[] ax(double[] x, double[] y) {
            int i;
            this.Wt.atx(x, this.Wx);
            int n = this.Wt.nrows();
            for (i = 0; i < n; ++i) {
                this.Wtx[i] = x[i] - this.Wx[i];
            }
            this.Wt.ax(this.Wtx, y);
            for (i = 0; i < n; ++i) {
                int n2 = i;
                y[n2] = y[n2] + this.Wx[i];
            }
            return y;
        }

        public double[] atx(double[] x, double[] y) {
            return this.ax(x, y);
        }

        public double[] axpy(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }

        public double[] axpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException();
        }

        public double get(int i, int j) {
            throw new UnsupportedOperationException();
        }

        public double apply(int i, int j) {
            throw new UnsupportedOperationException();
        }

        public double[] atxpy(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }

        public double[] atxpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException();
        }
    }
}

