/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.lang.reflect.Array;
import java.util.List;
import smile.math.distance.Distance;
import smile.neighbor.KNNSearch;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;
import smile.neighbor.SimpleNeighbor;
import smile.sort.HeapSelect;

public class LinearSearch<T>
implements NearestNeighborSearch<T, T>,
KNNSearch<T, T>,
RNNSearch<T, T> {
    private T[] data;
    private Distance<T> distance;
    private boolean identicalExcluded = true;

    public LinearSearch(T[] dataset, Distance<T> distance) {
        this.data = dataset;
        this.distance = distance;
    }

    public String toString() {
        return String.format("Linear Search (%s)", this.distance);
    }

    public LinearSearch<T> setIdenticalExcluded(boolean excluded) {
        this.identicalExcluded = excluded;
        return this;
    }

    public boolean isIdenticalExcluded() {
        return this.identicalExcluded;
    }

    @Override
    public Neighbor<T, T> nearest(T q) {
        Object neighbor = null;
        int index = -1;
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < this.data.length; ++i) {
            double d;
            if (q == this.data[i] && this.identicalExcluded || !((d = this.distance.d(q, this.data[i])) < dist)) continue;
            neighbor = this.data[i];
            index = i;
            dist = d;
        }
        return new SimpleNeighbor<Object>(neighbor, index, dist);
    }

    @Override
    public Neighbor<T, T>[] knn(T q, int k) {
        int i;
        if (k <= 0) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (k > this.data.length) {
            throw new IllegalArgumentException("Neighbor array length is larger than the dataset size");
        }
        SimpleNeighbor<Object> neighbor = new SimpleNeighbor<Object>(null, 0, Double.MAX_VALUE);
        Comparable[] neighbors = (SimpleNeighbor[])Array.newInstance(neighbor.getClass(), k);
        HeapSelect heap = new HeapSelect(neighbors);
        for (i = 0; i < k; ++i) {
            heap.add(neighbor);
            neighbor = new SimpleNeighbor<Object>(null, 0, Double.MAX_VALUE);
        }
        for (i = 0; i < this.data.length; ++i) {
            if (q == this.data[i] && this.identicalExcluded) continue;
            double dist = this.distance.d(q, this.data[i]);
            Neighbor datum = (Neighbor)heap.peek();
            if (!(dist < datum.distance)) continue;
            datum.distance = dist;
            datum.index = i;
            datum.key = this.data[i];
            datum.value = this.data[i];
            heap.heapify();
        }
        heap.sort();
        return neighbors;
    }

    @Override
    public void range(T q, double radius, List<Neighbor<T, T>> neighbors) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        for (int i = 0; i < this.data.length; ++i) {
            double d;
            if (q == this.data[i] && this.identicalExcluded || !((d = this.distance.d(q, this.data[i])) <= radius)) continue;
            neighbors.add(new SimpleNeighbor<T>(this.data[i], i, d));
        }
    }
}

