/*
 * Decompiled with CFR 0.152.
 */
package smile.sampling;

import java.util.ArrayList;
import smile.math.Math;

public class Bagging {
    public int size;
    public int[][] samples;

    public Bagging(int k, int[] y, int[] classWeight, double subsample) {
        int n = y.length;
        int[] sampling = new int[n];
        if (subsample == 1.0) {
            for (int l = 0; l < k; ++l) {
                int nj = 0;
                ArrayList<Integer> cj = new ArrayList<Integer>();
                for (int i = 0; i < n; ++i) {
                    if (y[i] != l) continue;
                    cj.add(i);
                    ++nj;
                }
                int size = nj / classWeight[l];
                for (int i = 0; i < size; ++i) {
                    int xi = Math.randomInt((int)nj);
                    int n2 = (Integer)cj.get(xi);
                    sampling[n2] = sampling[n2] + 1;
                }
            }
        } else {
            int[] perm = new int[n];
            for (int i = 0; i < n; ++i) {
                perm[i] = i;
            }
            Math.permutate((int[])perm);
            int[] nc = new int[k];
            for (int i = 0; i < n; ++i) {
                int n3 = y[i];
                nc[n3] = nc[n3] + 1;
            }
            for (int l = 0; l < k; ++l) {
                int subj = (int)Math.round((double)((double)nc[l] * subsample / (double)classWeight[l]));
                int count = 0;
                for (int i = 0; i < n && count < subj; ++i) {
                    int xi = perm[i];
                    if (y[xi] != l) continue;
                    int n4 = xi;
                    sampling[n4] = sampling[n4] + 1;
                    ++count;
                }
            }
        }
        int m = 0;
        for (int s : sampling) {
            if (s == 0) continue;
            ++m;
            this.size += s;
        }
        this.samples = new int[m][2];
        int l = 0;
        for (int i = 0; i < n; ++i) {
            if (sampling[i] <= 0) continue;
            this.samples[l][0] = i;
            this.samples[l][1] = sampling[i];
            ++l;
        }
    }
}

