/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.util.SimpleDeamonThreadFactory;

public class MulticoreExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MulticoreExecutor.class);
    private static int nprocs = -1;
    private static ThreadPoolExecutor threads = null;

    private MulticoreExecutor() {
    }

    private static void createThreadPool() {
        if (nprocs == -1) {
            int n = -1;
            try {
                String env = System.getProperty("smile.threads");
                if (env != null) {
                    n = Integer.parseInt(env);
                }
            }
            catch (Exception ex) {
                logger.error("Failed to create multi-core execution thread pool", (Throwable)ex);
            }
            nprocs = n < 1 ? Runtime.getRuntime().availableProcessors() : n;
            if (nprocs > 1) {
                threads = (ThreadPoolExecutor)Executors.newFixedThreadPool(nprocs, new SimpleDeamonThreadFactory());
            }
        }
    }

    public static int getThreadPoolSize() {
        MulticoreExecutor.createThreadPool();
        return nprocs;
    }

    public static <T> List<T> run(Collection<? extends Callable<T>> tasks) throws Exception {
        MulticoreExecutor.createThreadPool();
        ArrayList<T> results = new ArrayList<T>();
        if (threads == null) {
            for (Callable<T> task : tasks) {
                results.add(task.call());
            }
        } else if (threads.getActiveCount() < nprocs) {
            List futures = threads.invokeAll(tasks);
            for (Future future : futures) {
                results.add(future.get());
            }
        } else {
            for (Callable<T> task : tasks) {
                results.add(task.call());
            }
        }
        return results;
    }

    public static void shutdown() {
        if (threads != null) {
            threads.shutdown();
        }
    }
}

