/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractNumberVectorDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CorrelationAnalysisSolution;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.text.NumberFormat;
import java.util.Locale;

@Title(value="Dependency Derivator: Deriving numerical inter-dependencies on data")
@Description(value="Derives an equality-system describing dependencies between attributes in a correlation-cluster")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, A. Zimek", title="Deriving Quantitative Dependencies for Correlation Clusters", booktitle="Proc. 12th Int. Conf. on Knowledge Discovery and Data Mining (KDD '06), Philadelphia, PA 2006.", url="http://dx.doi.org/10.1145/1150402.1150408")
public class DependencyDerivator<V extends NumberVector>
extends AbstractNumberVectorDistanceBasedAlgorithm<V, CorrelationAnalysisSolution<V>> {
    private static final Logging LOG = Logging.getLogger(DependencyDerivator.class);
    public static final OptionID DEPENDENCY_DERIVATOR_RANDOM_SAMPLE = new OptionID("derivator.randomSample", "Flag to use random sample (use knn query around centroid, if flag is not set).");
    public static final OptionID OUTPUT_ACCURACY_ID = new OptionID("derivator.accuracy", "Threshold for output accuracy fraction digits.");
    public static final OptionID SAMPLE_SIZE_ID = new OptionID("derivator.sampleSize", "Threshold for the size of the random sample to use. Default value is size of the complete dataset.");
    private final int sampleSize;
    private final PCAFilteredRunner pca;
    private final NumberFormat nf;
    private final boolean randomsample;

    public DependencyDerivator(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, NumberFormat numberFormat, PCAFilteredRunner pCAFilteredRunner, int n, boolean bl) {
        super(numberVectorDistanceFunction);
        this.nf = numberFormat;
        this.pca = pCAFilteredRunner;
        this.sampleSize = n;
        this.randomsample = bl;
    }

    public CorrelationAnalysisSolution<V> run(Database database, Relation<V> relation) {
        DBIDs dBIDs;
        if (LOG.isVerbose()) {
            LOG.verbose("retrieving database objects...");
        }
        Centroid centroid = Centroid.make(relation);
        V v = centroid.toVector(relation);
        if (this.sampleSize > 0) {
            if (this.randomsample) {
                dBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.sampleSize, RandomFactory.DEFAULT);
            } else {
                DistanceQuery<V> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
                KNNList kNNList = database.getKNNQuery(distanceQuery, this.sampleSize).getKNNForObject(v, this.sampleSize);
                dBIDs = DBIDUtil.newHashSet(kNNList);
            }
        } else {
            dBIDs = relation.getDBIDs();
        }
        return this.generateModel(relation, dBIDs, centroid);
    }

    public CorrelationAnalysisSolution<V> generateModel(Relation<V> relation, DBIDs dBIDs) {
        return this.generateModel(relation, dBIDs, Centroid.make(relation, dBIDs));
    }

    public CorrelationAnalysisSolution<V> generateModel(Relation<V> relation, DBIDs dBIDs, Vector vector) {
        CorrelationAnalysisSolution<V> correlationAnalysisSolution;
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("PCA...");
        }
        PCAResult pCAResult = this.pca.processIds(dBIDs, relation);
        Matrix matrix = ((PCAFilteredResult)pCAResult).getWeakEigenvectors();
        Matrix matrix2 = ((PCAFilteredResult)pCAResult).getStrongEigenvectors();
        if (matrix.getColumnDimensionality() == 0) {
            correlationAnalysisSolution = new CorrelationAnalysisSolution<V>(null, relation, matrix2, matrix, ((PCAFilteredResult)pCAResult).similarityMatrix(), vector);
        } else {
            Object object;
            Object object2;
            Matrix matrix3 = matrix.transpose();
            if (LOG.isDebugging()) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Strong Eigenvectors:\n");
                ((StringBuilder)object2).append(FormatUtil.format(pCAResult.getEigenvectors().times(((PCAFilteredResult)pCAResult).selectionMatrixOfStrongEigenvectors()), this.nf)).append('\n');
                ((StringBuilder)object2).append("Transposed weak Eigenvectors:\n");
                ((StringBuilder)object2).append(FormatUtil.format(matrix3, this.nf)).append('\n');
                ((StringBuilder)object2).append("Eigenvalues:\n");
                ((StringBuilder)object2).append(FormatUtil.format(pCAResult.getEigenvalues(), ", ", this.nf));
                LOG.debugFine(((StringBuilder)object2).toString());
            }
            object2 = matrix3.times(vector);
            if (LOG.isDebugging()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Centroid:\n").append(vector).append('\n');
                ((StringBuilder)object).append("tEV * Centroid\n");
                ((StringBuilder)object).append(object2);
                LOG.debugFine(((StringBuilder)object).toString());
            }
            object = new Matrix(matrix3.getRowDimensionality(), matrix3.getColumnDimensionality() + 1);
            ((Matrix)object).setMatrix(0, matrix3.getRowDimensionality() - 1, 0, matrix3.getColumnDimensionality() - 1, matrix3);
            ((Matrix)object).setCol(matrix3.getColumnDimensionality(), (Vector)object2);
            if (LOG.isDebuggingFiner()) {
                LOG.debugFiner("Gauss-Jordan-Elimination of " + FormatUtil.format((Matrix)object, this.nf));
            }
            double[][] dArray = new double[matrix3.getRowDimensionality()][matrix3.getColumnDimensionality()];
            double[][] dArray2 = matrix3.getArrayRef();
            System.arraycopy(dArray2, 0, dArray, 0, matrix3.getRowDimensionality());
            LinearEquationSystem linearEquationSystem = new LinearEquationSystem(dArray, ((Vector)object2).getArrayRef());
            linearEquationSystem.solveByTotalPivotSearch();
            correlationAnalysisSolution = new CorrelationAnalysisSolution<V>(linearEquationSystem, relation, matrix2, ((PCAFilteredResult)pCAResult).getWeakEigenvectors(), ((PCAFilteredResult)pCAResult).similarityMatrix(), vector);
            if (LOG.isDebuggingFine()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Solution:\n");
                stringBuilder.append("Standard deviation ").append(correlationAnalysisSolution.getStandardDeviation());
                stringBuilder.append(linearEquationSystem.equationsToString(this.nf.getMaximumFractionDigits()));
                LOG.debugFine(stringBuilder.toString());
            }
        }
        return correlationAnalysisSolution;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractNumberVectorDistanceBasedAlgorithm.Parameterizer<V> {
        protected int outputAccuracy = 0;
        protected int sampleSize = 0;
        protected boolean randomSample = false;
        protected PCAFilteredRunner pca = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(OUTPUT_ACCURACY_ID, 4);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.outputAccuracy = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(SAMPLE_SIZE_ID);
            intParameter2.setOptional(true);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.sampleSize = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(flag = new Flag(DEPENDENCY_DERIVATOR_RANDOM_SAMPLE))) {
                this.randomSample = (Boolean)flag.getValue();
            }
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(PCAFilteredRunner.class);
            this.pca = (PCAFilteredRunner)parameterization.tryInstantiate(clazz);
        }

        @Override
        protected DependencyDerivator<V> makeInstance() {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(this.outputAccuracy);
            numberFormat.setMinimumFractionDigits(this.outputAccuracy);
            return new DependencyDerivator(this.distanceFunction, numberFormat, this.pca, this.sampleSize, this.randomSample);
        }
    }
}

