/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.AffinityPropagationInitialization;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class DistanceBasedInitializationWithMedian<O>
implements AffinityPropagationInitialization<O> {
    DistanceFunction<? super O> distance;
    double quantile;

    public DistanceBasedInitializationWithMedian(DistanceFunction<? super O> distanceFunction, double d) {
        this.distance = distanceFunction;
        this.quantile = d;
    }

    @Override
    public double[][] getSimilarityMatrix(Database database, Relation<O> relation, ArrayDBIDs arrayDBIDs) {
        int n = arrayDBIDs.size();
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.distance, new Object[0]);
        double[][] dArray = new double[n][n];
        double[] dArray2 = new double[n * (n - 1) >> 1];
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            dBIDArrayIter2.seek(i + 1);
            for (int j = i + 1; j < n; ++j) {
                dArray3[j] = -distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                dArray[j][i] = dArray3[j];
                dArray2[n2] = dArray3[j];
                ++n2;
                dBIDArrayIter2.advance();
            }
            dBIDArrayIter.advance();
        }
        double d = QuickSelect.quantile(dArray2, this.quantile);
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = d;
        }
        return dArray;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ap.distance", "Distance function to use.");
        DistanceFunction<? super O> distance;
        double quantile;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(AffinityPropagationInitialization.QUANTILE_ID, 0.5))) {
                this.quantile = doubleParameter.doubleValue();
            }
        }

        @Override
        protected DistanceBasedInitializationWithMedian<O> makeInstance() {
            return new DistanceBasedInitializationWithMedian<O>(this.distance, this.quantile);
        }
    }
}

