/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.CorrelationClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.GeneralizedOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.DiSHPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.ProjectedCentroid;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Title(value="DiSH: Detecting Subspace cluster Hierarchies")
@Description(value="Algorithm to find hierarchical correlation clusters in subspaces.")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, I. M\u00fcller-Gorman, A. Zimek", title="Detection and Visualization of Subspace Cluster Hierarchies", booktitle="Proc. 12th International Conference on Database Systems for Advanced Applications (DASFAA), Bangkok, Thailand, 2007", url="http://dx.doi.org/10.1007/978-3-540-71703-4_15")
public class DiSH<V extends NumberVector>
extends AbstractAlgorithm<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(DiSH.class);
    private double epsilon;
    private DiSHPreferenceVectorIndex.Factory<V> dishPreprocessor;
    private int mu;

    public DiSH(double d, int n, DiSHPreferenceVectorIndex.Factory<V> factory) {
        this.epsilon = d;
        this.mu = n;
        this.dishPreprocessor = factory;
    }

    public Clustering<SubspaceModel> run(Database database, Relation<V> relation) {
        if (this.mu >= relation.size()) {
            throw new AbortException("Parameter mu is chosen unreasonably large. This won't yield meaningful results.");
        }
        DiSHClusterOrder diSHClusterOrder = new Instance(database, relation).run();
        if (LOG.isVerbose()) {
            LOG.verbose("Compute Clusters.");
        }
        return this.computeClusters(relation, diSHClusterOrder);
    }

    private Clustering<SubspaceModel> computeClusters(Relation<V> relation, DiSHClusterOrder diSHClusterOrder) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n = RelationUtil.dimensionality(relation);
        TCustomHashMap<long[], List<ArrayModifiableDBIDs>> tCustomHashMap = this.extractClusters(relation, diSHClusterOrder);
        if (LOG.isVerbose()) {
            object4 = new StringBuilder("Step 1: extract clusters\n");
            tCustomHashMap.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<long[], List<ArrayModifiableDBIDs>>((StringBuilder)object4, n){
                final /* synthetic */ StringBuilder val$msg;
                final /* synthetic */ int val$dimensionality;
                {
                    this.val$msg = stringBuilder;
                    this.val$dimensionality = n;
                }

                public boolean execute(long[] lArray, List<ArrayModifiableDBIDs> list) {
                    this.val$msg.append(BitsUtil.toStringLow(lArray, this.val$dimensionality)).append(" sizes:");
                    for (ArrayModifiableDBIDs arrayModifiableDBIDs : list) {
                        this.val$msg.append(' ').append(arrayModifiableDBIDs.size());
                    }
                    this.val$msg.append('\n');
                    return true;
                }
            });
            LOG.verbose(((StringBuilder)object4).toString());
        }
        this.checkClusters(relation, tCustomHashMap);
        if (LOG.isVerbose()) {
            object4 = new StringBuilder("Step 2: check clusters\n");
            tCustomHashMap.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<long[], List<ArrayModifiableDBIDs>>((StringBuilder)object4, n){
                final /* synthetic */ StringBuilder val$msg;
                final /* synthetic */ int val$dimensionality;
                {
                    this.val$msg = stringBuilder;
                    this.val$dimensionality = n;
                }

                public boolean execute(long[] lArray, List<ArrayModifiableDBIDs> list) {
                    this.val$msg.append(BitsUtil.toStringLow(lArray, this.val$dimensionality)).append(" sizes:");
                    for (ArrayModifiableDBIDs arrayModifiableDBIDs : list) {
                        this.val$msg.append(' ').append(arrayModifiableDBIDs.size());
                    }
                    this.val$msg.append('\n');
                    return true;
                }
            });
            LOG.verbose(((StringBuilder)object4).toString());
        }
        object4 = this.sortClusters(relation, tCustomHashMap);
        if (LOG.isVerbose()) {
            object3 = new StringBuilder("Step 3: sort clusters");
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (Cluster)object2.next();
                ((StringBuilder)object3).append('\n').append(BitsUtil.toStringLow(((SubspaceModel)((Cluster)object).getModel()).getSubspace().getDimensions(), n)).append(" ids ").append(((Cluster)object).size());
            }
            LOG.verbose(((StringBuilder)object3).toString());
        }
        object3 = new Clustering("DiSH clustering", "dish-clustering");
        this.buildHierarchy(relation, (Clustering<SubspaceModel>)object3, (List<Cluster<SubspaceModel>>)object4, n);
        if (LOG.isVerbose()) {
            object2 = new StringBuilder("Step 4: build hierarchy");
            object = object4.iterator();
            while (object.hasNext()) {
                Cluster cluster = (Cluster)object.next();
                ((StringBuilder)object2).append('\n').append(BitsUtil.toStringLow(((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), n)).append(" ids ").append(cluster.size());
                Hierarchy.Iter<Cluster> iter = ((Clustering)object3).getClusterHierarchy().iterParents(cluster);
                while (iter.valid()) {
                    ((StringBuilder)object2).append("\n   parent ").append(iter.get());
                    iter.advance();
                }
                iter = ((Clustering)object3).getClusterHierarchy().iterChildren(cluster);
                while (iter.valid()) {
                    ((StringBuilder)object2).append("\n   child ").append(iter.get());
                    iter.advance();
                }
            }
            LOG.verbose(((StringBuilder)object2).toString());
        }
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = (Cluster)object2.next();
            if (((Clustering)object3).getClusterHierarchy().numParents(object) != 0) continue;
            ((Clustering)object3).addToplevelCluster(object);
        }
        return object3;
    }

    private TCustomHashMap<long[], List<ArrayModifiableDBIDs>> extractClusters(Relation<V> relation, DiSHClusterOrder diSHClusterOrder) {
        Object object;
        Object object2;
        ArrayList arrayList2;
        Object object3;
        Object object4;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Extract Clusters", relation.size(), LOG) : null;
        TCustomHashMap tCustomHashMap = new TCustomHashMap(BitsUtil.TROVE_HASH_STRATEGY);
        WritableDataStore<Pair> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, Pair.class);
        DBIDRef dBIDRef = diSHClusterOrder.iter();
        while (dBIDRef.valid()) {
            object4 = (NumberVector)relation.get(dBIDRef);
            object3 = diSHClusterOrder.getCommonPreferenceVector(dBIDRef);
            arrayList2 = (ArrayList)tCustomHashMap.get(object3);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
                tCustomHashMap.put(object3, (Object)arrayList2);
            }
            object2 = null;
            for (ArrayModifiableDBIDs arrayModifiableDBIDs : arrayList2) {
                double d;
                long[] lArray;
                object = ProjectedCentroid.make(object3, relation, arrayModifiableDBIDs);
                int n = this.subspaceDimensionality((NumberVector)object4, (NumberVector)object, (long[])object3, (long[])object3, lArray = BitsUtil.andCMin(object3, object3));
                if (n != diSHClusterOrder.getCorrelationValue(dBIDRef) || !((d = DiSH.weightedDistance((NumberVector)object4, (NumberVector)object, lArray)) <= 2.0 * this.epsilon)) continue;
                object2 = arrayModifiableDBIDs;
                break;
            }
            if (object2 == null) {
                object2 = DBIDUtil.newArray();
                arrayList2.add(object2);
            }
            object2.add(dBIDRef);
            writableDataStore.put(dBIDRef, new Pair(object3, object2));
            LOG.incrementProcessed(finiteProgress);
            dBIDRef.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isDebuggingFiner()) {
            int n = RelationUtil.dimensionality(relation);
            object4 = new StringBuilder("Step 0");
            for (ArrayList arrayList2 : tCustomHashMap.entrySet()) {
                for (Object object5 : (List)arrayList2.getValue()) {
                    ((StringBuilder)object4).append('\n').append(BitsUtil.toStringLow((long[])arrayList2.getKey(), n)).append(" ids ").append(object5.size());
                }
            }
            LOG.debugFiner(((StringBuilder)object4).toString());
        }
        dBIDRef = DBIDUtil.newVar();
        object4 = DBIDUtil.newVar();
        object3 = tCustomHashMap.keySet().iterator();
        while (object3.hasNext()) {
            Object object5;
            arrayList2 = (ArrayList)((long[])object3.next());
            object2 = (List)tCustomHashMap.get((Object)arrayList2);
            object5 = object2.iterator();
            while (object5.hasNext()) {
                ArrayModifiableDBIDs arrayModifiableDBIDs;
                arrayModifiableDBIDs = (ArrayModifiableDBIDs)object5.next();
                if (arrayModifiableDBIDs.isEmpty()) continue;
                arrayModifiableDBIDs.assignVar(0, (DBIDVar)dBIDRef);
                diSHClusterOrder.getPredecessor(dBIDRef, (DBIDVar)object4);
                if (!object4.isSet() || DBIDUtil.equal((DBIDRef)object4, dBIDRef) || BitsUtil.equal(diSHClusterOrder.getCommonPreferenceVector((DBIDRef)object4), diSHClusterOrder.getCommonPreferenceVector(dBIDRef)) || diSHClusterOrder.getCorrelationValue((DBIDRef)object4) < diSHClusterOrder.getCorrelationValue(dBIDRef) || diSHClusterOrder.getReachability((DBIDRef)object4) < diSHClusterOrder.getReachability(dBIDRef)) continue;
                object = (Pair)writableDataStore.get((DBIDRef)object4);
                ((ArrayModifiableDBIDs)((Pair)object).second).remove((DBIDRef)object4);
                arrayModifiableDBIDs.add((DBIDRef)object4);
                writableDataStore.put((DBIDRef)object4, new Pair<Object, ArrayModifiableDBIDs>(arrayList2, arrayModifiableDBIDs));
            }
        }
        return tCustomHashMap;
    }

    private List<Cluster<SubspaceModel>> sortClusters(Relation<V> relation, TCustomHashMap<long[], List<ArrayModifiableDBIDs>> tCustomHashMap) {
        int n = RelationUtil.dimensionality(relation);
        ArrayList<Cluster<SubspaceModel>> arrayList = new ArrayList<Cluster<SubspaceModel>>();
        for (long[] lArray : tCustomHashMap.keySet()) {
            List list = (List)tCustomHashMap.get((Object)lArray);
            for (int i = 0; i < list.size(); ++i) {
                ArrayModifiableDBIDs arrayModifiableDBIDs = (ArrayModifiableDBIDs)list.get(i);
                Cluster<SubspaceModel> cluster = new Cluster<SubspaceModel>(arrayModifiableDBIDs);
                cluster.setModel(new SubspaceModel(new Subspace(lArray), Centroid.make(relation, arrayModifiableDBIDs)));
                String string = BitsUtil.toStringLow(((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), n);
                if (list.size() > 1) {
                    cluster.setName("Cluster_" + string + "_" + i);
                } else {
                    cluster.setName("Cluster_" + string);
                }
                arrayList.add(cluster);
            }
        }
        Comparator<Cluster<SubspaceModel>> comparator = new Comparator<Cluster<SubspaceModel>>(){

            @Override
            public int compare(Cluster<SubspaceModel> cluster, Cluster<SubspaceModel> cluster2) {
                return cluster2.getModel().getSubspace().dimensionality() - cluster.getModel().getSubspace().dimensionality();
            }
        };
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private void checkClusters(Relation<V> relation, TCustomHashMap<long[], List<ArrayModifiableDBIDs>> tCustomHashMap) {
        Pair<long[], ArrayModifiableDBIDs> pair;
        int n = RelationUtil.dimensionality(relation);
        ArrayList<Pair<long[], ArrayModifiableDBIDs>> arrayList = new ArrayList<Pair<long[], ArrayModifiableDBIDs>>();
        TCustomHashMap tCustomHashMap2 = new TCustomHashMap(BitsUtil.TROVE_HASH_STRATEGY);
        Pair<long[], ArrayModifiableDBIDs> pair2 = new Pair<long[], ArrayModifiableDBIDs>(BitsUtil.zero(n), DBIDUtil.newArray());
        for (Object object4 : tCustomHashMap.keySet()) {
            Object object2;
            Object object3;
            if (BitsUtil.cardinality(object4) == 0) {
                pair = (List)tCustomHashMap.get(object4);
                object3 = pair.iterator();
                while (object3.hasNext()) {
                    object2 = (ArrayModifiableDBIDs)object3.next();
                    ((ArrayModifiableDBIDs)pair2.second).addDBIDs((DBIDs)object2);
                }
                continue;
            }
            pair = (List)tCustomHashMap.get(object4);
            object3 = new ArrayList(pair.size());
            object2 = pair.iterator();
            while (object2.hasNext()) {
                ArrayModifiableDBIDs arrayModifiableDBIDs = (ArrayModifiableDBIDs)object2.next();
                if (!BitsUtil.isZero(object4) && arrayModifiableDBIDs.size() < this.mu) {
                    arrayList.add(new Pair<long[], ArrayModifiableDBIDs>((long[])object4, arrayModifiableDBIDs));
                    continue;
                }
                object3.add(arrayModifiableDBIDs);
            }
            tCustomHashMap2.put(object4, object3);
        }
        tCustomHashMap.clear();
        tCustomHashMap.putAll((Map)tCustomHashMap2);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Object object4;
            object4 = (Pair)object.next();
            if (((ArrayModifiableDBIDs)object4.second).isEmpty()) continue;
            pair = this.findParent(relation, (Pair<long[], ArrayModifiableDBIDs>)object4, tCustomHashMap);
            if (pair != null) {
                ((ArrayModifiableDBIDs)pair.second).addDBIDs((DBIDs)object4.second);
                continue;
            }
            ((ArrayModifiableDBIDs)pair2.second).addDBIDs((DBIDs)object4.second);
        }
        object = new ArrayList(1);
        object.add(pair2.second);
        tCustomHashMap.put(pair2.first, object);
    }

    private Pair<long[], ArrayModifiableDBIDs> findParent(Relation<V> relation, Pair<long[], ArrayModifiableDBIDs> pair, TCustomHashMap<long[], List<ArrayModifiableDBIDs>> tCustomHashMap) {
        ProjectedCentroid projectedCentroid = ProjectedCentroid.make((long[])pair.first, relation, (DBIDs)pair.second);
        Pair<long[], ArrayModifiableDBIDs> pair2 = null;
        int n = -1;
        long[] lArray = (long[])pair.first;
        int n2 = BitsUtil.cardinality(lArray);
        block0: for (long[] lArray2 : tCustomHashMap.keySet()) {
            long[] lArray3;
            int n3 = BitsUtil.cardinality(lArray2);
            if (n3 >= n2 || n != -1 && n3 <= n || !(lArray3 = BitsUtil.andCMin(lArray, lArray2)).equals(lArray2)) continue;
            List list = (List)tCustomHashMap.get((Object)lArray2);
            for (ArrayModifiableDBIDs arrayModifiableDBIDs : list) {
                ProjectedCentroid projectedCentroid2 = ProjectedCentroid.make(lArray2, relation, arrayModifiableDBIDs);
                double d = DiSH.weightedDistance(projectedCentroid, projectedCentroid2, lArray2);
                if (!(d <= 2.0 * this.epsilon)) continue;
                pair2 = new Pair<long[], ArrayModifiableDBIDs>(lArray2, arrayModifiableDBIDs);
                n = n3;
                continue block0;
            }
        }
        return pair2;
    }

    private void buildHierarchy(Relation<V> relation, Clustering<SubspaceModel> clustering, List<Cluster<SubspaceModel>> list, int n) {
        StringBuilder stringBuilder = LOG.isDebugging() ? new StringBuilder() : null;
        int n2 = RelationUtil.dimensionality(relation);
        Hierarchy<Cluster<SubspaceModel>> hierarchy = clustering.getClusterHierarchy();
        for (int i = 0; i < list.size() - 1; ++i) {
            Cluster<SubspaceModel> cluster = list.get(i);
            Subspace subspace = cluster.getModel().getSubspace();
            int n3 = n - subspace.dimensionality();
            ProjectedCentroid projectedCentroid = ProjectedCentroid.make(subspace.getDimensions(), relation, cluster.getIDs());
            long[] lArray = subspace.getDimensions();
            for (int j = i + 1; j < list.size(); ++j) {
                Cluster<SubspaceModel> cluster2 = list.get(j);
                Subspace subspace2 = cluster2.getModel().getSubspace();
                int n4 = n - subspace2.dimensionality();
                if (n3 >= n4) continue;
                if (stringBuilder != null) {
                    stringBuilder.append("\n l_i=").append(n3).append(" pv_i=[").append(BitsUtil.toStringLow(subspace.getDimensions(), n2)).append(']');
                    stringBuilder.append("\n l_j=").append(n4).append(" pv_j=[").append(BitsUtil.toStringLow(subspace2.getDimensions(), n2)).append(']');
                }
                if (subspace2.dimensionality() == 0) {
                    if (hierarchy.numParents(cluster) != 0) continue;
                    clustering.addChildCluster(cluster2, cluster);
                    if (stringBuilder == null) continue;
                    stringBuilder.append("\n [").append(BitsUtil.toStringLow(subspace2.getDimensions(), n2));
                    stringBuilder.append("] is parent of [").append(BitsUtil.toStringLow(subspace.getDimensions(), n2));
                    stringBuilder.append(']');
                    continue;
                }
                ProjectedCentroid projectedCentroid2 = ProjectedCentroid.make(cluster2.getModel().getDimensions(), relation, cluster2.getIDs());
                long[] lArray2 = subspace2.getDimensions();
                long[] lArray3 = BitsUtil.andCMin(lArray, lArray2);
                int n5 = this.subspaceDimensionality(projectedCentroid, projectedCentroid2, lArray, lArray2, lArray3);
                double d = DiSH.weightedDistance(projectedCentroid, projectedCentroid2, lArray3);
                if (stringBuilder != null) {
                    stringBuilder.append("\n dist = ").append(n5);
                }
                if (n5 != n4) continue;
                if (stringBuilder != null) {
                    stringBuilder.append("\n d = ").append(d);
                }
                if (d <= 2.0 * this.epsilon) {
                    if (hierarchy.numParents(cluster) != 0 && this.isParent(relation, cluster2, hierarchy.iterParents(cluster), n2)) continue;
                    clustering.addChildCluster(cluster2, cluster);
                    if (stringBuilder == null) continue;
                    stringBuilder.append("\n [").append(BitsUtil.toStringLow(subspace2.getDimensions(), n2));
                    stringBuilder.append("] is parent of [");
                    stringBuilder.append(BitsUtil.toStringLow(subspace.getDimensions(), n2));
                    stringBuilder.append(']');
                    continue;
                }
                throw new RuntimeException("Should never happen: d = " + d);
            }
        }
        if (stringBuilder != null) {
            LOG.debug(stringBuilder.toString());
        }
    }

    private boolean isParent(Relation<V> relation, Cluster<SubspaceModel> cluster, Hierarchy.Iter<Cluster<SubspaceModel>> iter, int n) {
        Subspace subspace = cluster.getModel().getSubspace();
        ProjectedCentroid projectedCentroid = ProjectedCentroid.make(subspace.getDimensions(), relation, cluster.getIDs());
        int n2 = n - subspace.dimensionality();
        while (iter.valid()) {
            Cluster<SubspaceModel> cluster2 = iter.get();
            Subspace subspace2 = cluster2.getModel().getSubspace();
            ProjectedCentroid projectedCentroid2 = ProjectedCentroid.make(subspace2.getDimensions(), relation, cluster2.getIDs());
            long[] lArray = BitsUtil.andCMin(subspace.getDimensions(), subspace2.getDimensions());
            int n3 = this.subspaceDimensionality(projectedCentroid, projectedCentroid2, subspace.getDimensions(), subspace2.getDimensions(), lArray);
            if (n3 == n2) {
                return true;
            }
            iter.advance();
        }
        return false;
    }

    private int subspaceDimensionality(NumberVector numberVector, NumberVector numberVector2, long[] lArray, long[] lArray2, long[] lArray3) {
        double d;
        int n = numberVector.getDimensionality() - BitsUtil.cardinality(lArray3);
        if ((BitsUtil.equal(lArray3, lArray) || BitsUtil.equal(lArray3, lArray2)) && (d = DiSH.weightedDistance(numberVector, numberVector2, lArray3)) > 2.0 * this.epsilon) {
            ++n;
        }
        return n;
    }

    protected static double weightedDistance(NumberVector numberVector, NumberVector numberVector2, long[] lArray) {
        double d = 0.0;
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            double d2 = numberVector.doubleValue(n) - numberVector2.doubleValue(n);
            d += d2 * d2;
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return Math.sqrt(d);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID EPSILON_ID = new OptionID("dish.epsilon", "The maximum radius of the neighborhood to be considered in each  dimension for determination of the preference vector.");
        public static final OptionID MU_ID = new OptionID("dish.mu", "The minimum number of points as a smoothing factor to avoid the single-link-effekt.");
        protected double epsilon = 0.0;
        protected int mu = 1;
        protected DiSHPreferenceVectorIndex.Factory<V> dishPreprocessor;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(EPSILON_ID, 0.001);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.epsilon = doubleParameter.doubleValue();
            }
            IntParameter intParameter = new IntParameter(MU_ID, 1);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.mu = intParameter.intValue();
            }
            this.configDiSHPreprocessor(parameterization, this.epsilon, this.mu);
        }

        public void configDiSHPreprocessor(Parameterization parameterization, double d, int n) {
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(DiSHPreferenceVectorIndex.Factory.EPSILON_ID, d);
            listParameterization.addParameter(DiSHPreferenceVectorIndex.Factory.MINPTS_ID, n);
            ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
            chainedParameterization.errorsTo(parameterization);
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(DiSHPreferenceVectorIndex.Factory.class);
            this.dishPreprocessor = (DiSHPreferenceVectorIndex.Factory)chainedParameterization.tryInstantiate(clazz);
        }

        @Override
        protected DiSH<V> makeInstance() {
            return new DiSH<V>(this.epsilon, this.mu, this.dishPreprocessor);
        }
    }

    public static class DiSHClusterOrder
    extends CorrelationClusterOrder {
        private WritableDataStore<long[]> commonPreferenceVectors;

        public DiSHClusterOrder(String string, String string2, ArrayModifiableDBIDs arrayModifiableDBIDs, WritableDoubleDataStore writableDoubleDataStore, WritableDBIDDataStore writableDBIDDataStore, WritableIntegerDataStore writableIntegerDataStore, WritableDataStore<long[]> writableDataStore) {
            super(string, string2, arrayModifiableDBIDs, writableDoubleDataStore, writableDBIDDataStore, writableIntegerDataStore);
            this.commonPreferenceVectors = writableDataStore;
        }

        public long[] getCommonPreferenceVector(DBIDRef dBIDRef) {
            return (long[])this.commonPreferenceVectors.get(dBIDRef);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<V, DiSHClusterOrder> {
        private Relation<V> relation;
        private ArrayModifiableDBIDs clusterOrder;
        private WritableIntegerDataStore correlationValue;
        private WritableDataStore<long[]> commonPreferenceVectors;
        private ArrayModifiableDBIDs tmpIds;
        private WritableIntegerDataStore tmpCorrelation;
        private WritableDoubleDataStore tmpDistance;
        Comparator<DBIDRef> tmpcomp;
        private DiSHPreferenceVectorIndex<V> index;
        private WritableDataStore<long[]> tmpPreferenceVectors;

        public Instance(Database database, Relation<V> relation) {
            super(database, relation);
            this.tmpcomp = new Sorter();
            DBIDs dBIDs = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray(dBIDs.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage(dBIDs, 30, Integer.MAX_VALUE);
            this.commonPreferenceVectors = DataStoreUtil.makeStorage(dBIDs, 3, long[].class);
            this.tmpIds = DBIDUtil.newArray(dBIDs);
            this.tmpCorrelation = DataStoreUtil.makeIntegerStorage(dBIDs, 3);
            this.tmpDistance = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
            this.tmpPreferenceVectors = DataStoreUtil.makeStorage(dBIDs, 3, long[].class);
        }

        @Override
        public DiSHClusterOrder run() {
            this.index = DiSH.this.dishPreprocessor.instantiate(this.relation);
            return (DiSHClusterOrder)super.run();
        }

        @Override
        protected DiSHClusterOrder buildResult() {
            return new DiSHClusterOrder("DiSH Cluster Order", "dish-cluster-order", this.clusterOrder, this.reachability, this.predecessor, this.correlationValue, this.commonPreferenceVectors);
        }

        @Override
        protected void initialDBID(DBIDRef dBIDRef) {
            this.correlationValue.put(dBIDRef, Integer.MAX_VALUE);
            this.commonPreferenceVectors.put(dBIDRef, new long[0]);
        }

        @Override
        protected void expandDBID(DBIDRef dBIDRef) {
            double d;
            int n;
            this.clusterOrder.add(dBIDRef);
            long[] lArray = this.index.getPreferenceVector(dBIDRef);
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
            int n2 = numberVector.getDimensionality();
            long[] lArray2 = BitsUtil.ones(n2);
            long[] lArray3 = BitsUtil.ones(n2);
            DBIDArrayMIter dBIDArrayMIter = this.tmpIds.iter();
            while (dBIDArrayMIter.valid()) {
                long[] lArray4 = this.index.getPreferenceVector(dBIDArrayMIter);
                NumberVector numberVector2 = (NumberVector)this.relation.get(dBIDArrayMIter);
                long[] lArray5 = BitsUtil.andCMin(lArray, lArray4);
                n = n2 - BitsUtil.cardinality(lArray5);
                if ((BitsUtil.equal(lArray5, lArray) || BitsUtil.equal(lArray5, lArray4)) && (d = DiSH.weightedDistance(numberVector, numberVector2, lArray5)) > 2.0 * DiSH.this.epsilon) {
                    ++n;
                }
                System.arraycopy(lArray2, 0, lArray3, 0, lArray2.length);
                BitsUtil.xorI(lArray3, lArray5);
                d = DiSH.weightedDistance(numberVector, numberVector2, lArray3);
                this.tmpCorrelation.put((DBIDRef)dBIDArrayMIter, n);
                this.tmpDistance.put((DBIDRef)dBIDArrayMIter, d);
                this.tmpPreferenceVectors.put(dBIDArrayMIter, lArray5);
                dBIDArrayMIter.advance();
            }
            this.tmpIds.sort(this.tmpcomp);
            double d2 = this.tmpDistance.doubleValue(dBIDArrayMIter.seek(DiSH.this.mu - 1));
            dBIDArrayMIter.seek(0);
            while (dBIDArrayMIter.valid()) {
                int n3;
                if (!this.processedIDs.contains(dBIDArrayMIter) && (n3 = this.correlationValue.intValue(dBIDArrayMIter)) > (n = this.tmpCorrelation.intValue(dBIDArrayMIter))) {
                    double d3;
                    d = MathUtil.max(this.tmpDistance.doubleValue(dBIDArrayMIter), d2);
                    if (n3 != n || !((d3 = this.reachability.doubleValue(dBIDArrayMIter)) <= d)) {
                        this.correlationValue.putInt(dBIDArrayMIter, n);
                        this.reachability.putDouble(dBIDArrayMIter, d);
                        this.predecessor.putDBID(dBIDArrayMIter, dBIDRef);
                        this.commonPreferenceVectors.put(dBIDArrayMIter, (long[])this.tmpPreferenceVectors.get(dBIDArrayMIter));
                        if (n3 == Integer.MAX_VALUE) {
                            this.candidates.add(dBIDArrayMIter);
                        }
                    }
                }
                dBIDArrayMIter.advance();
            }
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            int n;
            int n2 = this.correlationValue.intValue(dBIDRef);
            return n2 < (n = this.correlationValue.intValue(dBIDRef2)) ? -1 : (n2 > n ? 1 : super.compare(dBIDRef, dBIDRef2));
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        private final class Sorter
        implements Comparator<DBIDRef> {
            private Sorter() {
            }

            @Override
            public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
                int n;
                int n2 = Instance.this.tmpCorrelation.intValue(dBIDRef);
                return n2 < (n = Instance.this.tmpCorrelation.intValue(dBIDRef2)) ? -1 : (n2 > n ? 1 : Double.compare(Instance.this.tmpDistance.doubleValue(dBIDRef), Instance.this.tmpDistance.doubleValue(dBIDRef2)));
            }
        }
    }
}

