/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GammaChoiWetteEstimator;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Title(value="COP: Correlation Outlier Probability")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE International Conference on Data Mining (ICDM 2012)", url="http://dx.doi.org/10.1109/ICDM.2012.21")
public class COP<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(COP.class);
    public static final String COP_SCORES = "cop-outlier";
    public static final String COP_DIM = "cop-dim";
    public static final String COP_ERRORVEC = "cop-errorvec";
    private static final NumberArrayAdapter<Double, double[]> SHORTENED_ARRAY = new NumberArrayAdapter<Double, double[]>(){

        @Override
        public int size(double[] dArray) {
            return (int)(0.85 * (double)dArray.length);
        }

        @Override
        public Double get(double[] dArray, int n) throws IndexOutOfBoundsException {
            return dArray[n];
        }

        @Override
        public double getDouble(double[] dArray, int n) throws IndexOutOfBoundsException {
            return dArray[n];
        }

        @Override
        public float getFloat(double[] dArray, int n) throws IndexOutOfBoundsException {
            return (float)dArray[n];
        }

        @Override
        public int getInteger(double[] dArray, int n) throws IndexOutOfBoundsException {
            return (int)dArray[n];
        }

        @Override
        public short getShort(double[] dArray, int n) throws IndexOutOfBoundsException {
            return (short)dArray[n];
        }

        @Override
        public long getLong(double[] dArray, int n) throws IndexOutOfBoundsException {
            return (long)dArray[n];
        }

        @Override
        public byte getByte(double[] dArray, int n) throws IndexOutOfBoundsException {
            return (byte)dArray[n];
        }
    };
    int k;
    private PCARunner pca;
    double expect = 1.0E-4;
    DistanceDist dist = DistanceDist.CHISQUARED;
    boolean models;

    public COP(DistanceFunction<? super V> distanceFunction, int n, PCARunner pCARunner, double d, DistanceDist distanceDist, boolean bl) {
        super(distanceFunction);
        this.k = n;
        this.pca = pCARunner;
        this.expect = d;
        this.dist = distanceDist;
        this.models = bl;
    }

    public OutlierResult run(Relation<V> relation) {
        Object object;
        Object object2;
        DBIDs dBIDs = relation.getDBIDs();
        KNNQuery<V> kNNQuery = QueryUtil.getKNNQuery(relation, this.getDistanceFunction(), this.k + 1);
        int n = RelationUtil.dimensionality(relation);
        if (this.k <= n + 1) {
            LOG.warning("PCA is underspecified with a too low k! k should be at much larger than " + n);
        }
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 6);
        WritableDataStore<Vector> writableDataStore = null;
        WritableIntegerDataStore writableIntegerDataStore = null;
        if (this.models) {
            writableDataStore = DataStoreUtil.makeStorage(dBIDs, 6, Vector.class);
            writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 6, -1);
        }
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Correlation Outlier Probabilities", relation.size(), LOG) : null;
        Object object3 = dBIDs.iter();
        while (object3.valid()) {
            Vector vector;
            int n2;
            double d;
            object2 = kNNQuery.getKNNForDBID((DBIDRef)object3, this.k + 1);
            object = DBIDUtil.newHashSet((DBIDs)object2);
            object.remove((DBIDRef)object3);
            Centroid centroid = Centroid.make(relation, (DBIDs)object);
            Vector vector2 = ((NumberVector)relation.get((DBIDRef)object3)).getColumnVector().minusEquals(centroid);
            PCAResult pCAResult = this.pca.processIds((DBIDs)object, relation);
            Matrix matrix = pCAResult.getEigenvectors();
            Vector vector3 = matrix.transposeTimes(vector2);
            double[] dArray = pCAResult.getEigenvalues();
            double d2 = Double.POSITIVE_INFINITY;
            int n3 = n;
            switch (this.dist) {
                case CHISQUARED: {
                    double d3;
                    d = 0.0;
                    for (n2 = 0; n2 < n; ++n2) {
                        d3 = vector3.get(n2);
                        double d4 = 1.0 - ChiSquaredDistribution.cdf(d += d3 * d3 / dArray[n2], n2 + 1);
                        if (!(d4 < d2)) continue;
                        d2 = d4;
                        n3 = n2 + 1;
                    }
                    break;
                }
                case GAMMA: {
                    double d5;
                    double[][] dArray2 = new double[n][object.size()];
                    vector = new Vector(n);
                    DBIDMIter dBIDMIter = object.iter();
                    for (int i = 0; dBIDMIter.valid() && i < object.size(); ++i) {
                        NumberVector numberVector = (NumberVector)relation.get(dBIDMIter);
                        for (int j = 0; j < n; ++j) {
                            vector.set(j, numberVector.doubleValue(j) - centroid.get(j));
                        }
                        Vector vector4 = matrix.transposeTimes(vector);
                        d5 = 0.0;
                        for (int j = 0; j < n; ++j) {
                            dArray2[j][i] = d5 += vector4.get(j) * vector4.get(j) / dArray[j];
                        }
                        dBIDMIter.advance();
                    }
                    double d3 = 0.0;
                    for (int i = 0; i < n; ++i) {
                        d5 = vector3.get(i);
                        Arrays.sort(dArray2[i]);
                        double d6 = 1.0 - ((GammaDistribution)GammaChoiWetteEstimator.STATIC.estimate(dArray2[i], SHORTENED_ARRAY)).cdf(d3 += d5 * d5 / dArray[i]);
                        if (!(d6 < d2)) continue;
                        d2 = d6;
                        n3 = i + 1;
                    }
                    break;
                }
            }
            d = this.expect * (1.0 - d2) / (this.expect + d2);
            for (n2 = n3; n2 < n; ++n2) {
                vector3.set(n2, 0.0);
            }
            vector = matrix.times(vector3).timesEquals(-1.0 * d);
            writableDoubleDataStore.putDouble((DBIDRef)object3, d);
            if (this.models) {
                writableDataStore.put((DBIDRef)object3, vector);
                writableIntegerDataStore.putInt((DBIDRef)object3, n + 1 - n3);
            }
            LOG.incrementProcessed(finiteProgress);
            object3.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object3 = new MaterializedDoubleRelation("Correlation Outlier Probabilities", COP_SCORES, writableDoubleDataStore, dBIDs);
        object2 = new ProbabilisticOutlierScore();
        object = new OutlierResult((OutlierScoreMeta)object2, (DoubleRelation)object3);
        if (this.models) {
            ((AbstractHierarchicalResult)object).addChildResult(new MaterializedRelation<Integer>("Local Dimensionality", COP_DIM, TypeUtil.INTEGER, writableIntegerDataStore, dBIDs));
            ((AbstractHierarchicalResult)object).addChildResult(new MaterializedRelation<Vector>("Error vectors", COP_ERRORVEC, TypeUtil.VECTOR, writableDataStore, dBIDs));
        }
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("cop.k", "The number of nearest neighbors of an object to be considered for computing its COP_SCORE.");
        public static final OptionID DIST_ID = new OptionID("cop.dist", "The assumed distribution of squared distances. ChiSquared is faster, Gamma expected to be more accurate but could also overfit.");
        public static final OptionID PCARUNNER_ID = new OptionID("cop.pcarunner", "The class to compute (filtered) PCA.");
        public static final OptionID EXPECT_ID = new OptionID("cop.expect", "Expected share of outliers. Only affect score normalization.");
        public static final OptionID MODELS_ID = new OptionID("cop.models", "Include COP models (error vectors) in output. This needs more memory.");
        int k;
        PCARunner pca;
        DistanceDist dist;
        double expect;
        boolean models = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            ObjectParameter objectParameter;
            EnumParameter<DistanceDist> enumParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint((ParameterConstraint)new GreaterConstraint(5));
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(enumParameter = new EnumParameter<DistanceDist>(DIST_ID, DistanceDist.class, DistanceDist.GAMMA))) {
                this.dist = (DistanceDist)((Object)enumParameter.getValue());
            }
            DoubleParameter doubleParameter = new DoubleParameter(EXPECT_ID, 0.001);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.expect = doubleParameter.doubleValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(PCARUNNER_ID, (Class<?>)PCARunner.class, PCARunner.class))) {
                this.pca = (PCARunner)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag = new Flag(MODELS_ID))) {
                this.models = flag.isTrue();
            }
        }

        @Override
        protected COP<V> makeInstance() {
            return new COP(this.distanceFunction, this.k, this.pca, this.expect, this.dist, this.models);
        }
    }

    public static enum DistanceDist {
        CHISQUARED,
        GAMMA;

    }
}

