/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance.parallel;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNOutlier;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.parallel.ParallelExecutor;
import de.lmu.ifi.dbs.elki.parallel.processor.DoubleMinMaxProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.KDistanceProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.KNNProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.WriteDoubleDataStoreProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedObject;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="E. Schubert, A. Zimek, H.-P. Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery, 28(1): 190\u2013237, 2014.", url="http://dx.doi.org/10.1007/s10618-012-0300-z")
public class ParallelKNNOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private int k;
    private static final Logging LOG = Logging.getLogger(ParallelKNNOutlier.class);

    public ParallelKNNOutlier(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        KNNProcessor<O> kNNProcessor = new KNNProcessor<O>(this.k + 1, kNNQuery);
        SharedObject<KNNList> sharedObject = new SharedObject<KNNList>();
        kNNProcessor.connectKNNOutput(sharedObject);
        KDistanceProcessor kDistanceProcessor = new KDistanceProcessor(this.k + 1);
        SharedDouble sharedDouble = new SharedDouble();
        kDistanceProcessor.connectKNNInput(sharedObject);
        kDistanceProcessor.connectOutput(sharedDouble);
        WriteDoubleDataStoreProcessor writeDoubleDataStoreProcessor = new WriteDoubleDataStoreProcessor(writableDoubleDataStore);
        writeDoubleDataStoreProcessor.connectInput(sharedDouble);
        DoubleMinMaxProcessor doubleMinMaxProcessor = new DoubleMinMaxProcessor();
        doubleMinMaxProcessor.connectInput(sharedDouble);
        ParallelExecutor.run(dBIDs, kNNProcessor, kDistanceProcessor, writeDoubleDataStoreProcessor, doubleMinMaxProcessor);
        DoubleMinMax doubleMinMax = doubleMinMaxProcessor.getMinMax();
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("kNN Outlier Score", "knn-outlier", writableDoubleDataStore, dBIDs);
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(basicOutlierScoreMeta, materializedDoubleRelation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(KNNOutlier.Parameterizer.K_ID);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected ParallelKNNOutlier<O> makeInstance() {
            return new ParallelKNNOutlier(this.distanceFunction, this.k);
        }
    }
}

