/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel.LOFProcessor;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel.SimplifiedLRDProcessor;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.parallel.ParallelExecutor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.DoubleMinMaxProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.KNNProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.processor.WriteDataStoreProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.WriteDoubleDataStoreProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedObject;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="E. Schubert, A. Zimek, H.-P. Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery, 28(1): 190\u2013237, 2014.", url="http://dx.doi.org/10.1007/s10618-012-0300-z")
public class ParallelSimplifiedLOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private int k;
    private static final Logging LOG = Logging.getLogger(ParallelSimplifiedLOF.class);

    public ParallelSimplifiedLOF(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        WritableDataStore<KNNList> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 30, KNNList.class);
        Object object = new KNNProcessor<O>(this.k + 1, kNNQuery);
        Object object2 = new SharedObject<KNNList>();
        Object object3 = new WriteDataStoreProcessor<KNNList>(writableDataStore);
        ((KNNProcessor)object).connectKNNOutput((SharedObject<KNNList>)object2);
        ((WriteDataStoreProcessor)object3).connectInput(object2);
        ParallelExecutor.run(dBIDs, new Processor[]{object, object3});
        object = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        object2 = new SimplifiedLRDProcessor(writableDataStore);
        object3 = new SharedDouble();
        Object object4 = new WriteDoubleDataStoreProcessor((WritableDoubleDataStore)object);
        ((AbstractDoubleProcessor)object2).connectOutput((SharedDouble)object3);
        ((WriteDoubleDataStoreProcessor)object4).connectInput((SharedDouble)object3);
        ParallelExecutor.run(dBIDs, new Processor[]{object2, object4});
        object2 = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        object4 = new LOFProcessor(writableDataStore, (DoubleDataStore)object, true);
        Object object5 = new SharedDouble();
        DoubleMinMaxProcessor doubleMinMaxProcessor = new DoubleMinMaxProcessor();
        WriteDoubleDataStoreProcessor writeDoubleDataStoreProcessor = new WriteDoubleDataStoreProcessor((WritableDoubleDataStore)object2);
        ((AbstractDoubleProcessor)object4).connectOutput((SharedDouble)object5);
        doubleMinMaxProcessor.connectInput((SharedDouble)object5);
        writeDoubleDataStoreProcessor.connectInput((SharedDouble)object5);
        ParallelExecutor.run(dBIDs, new Processor[]{object4, writeDoubleDataStoreProcessor, doubleMinMaxProcessor});
        object3 = doubleMinMaxProcessor.getMinMax();
        object4 = new MaterializedDoubleRelation("Simplified Local Outlier Factor", "simplified-lof-outlier", (DoubleDataStore)object2, dBIDs);
        object5 = new BasicOutlierScoreMeta(((DoubleMinMax)object3).getMin(), ((DoubleMinMax)object3).getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult((OutlierScoreMeta)object5, (DoubleRelation)object4);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(LOF.Parameterizer.K_ID);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected ParallelSimplifiedLOF<O> makeInstance() {
            return new ParallelSimplifiedLOF(this.distanceFunction, this.k);
        }
    }
}

