/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.internal;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceLoader;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckELKIServices {
    private static final Logging LOG = Logging.getLogger(CheckELKIServices.class);
    private Pattern strip = Pattern.compile("^[\\s#]*(?:deprecated:\\s*)?(.*?)[\\s]*$");

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 2 && "-update".equals(stringArray[0])) {
            string = stringArray[1];
            LOG.info("Updating service files in folder: " + string);
        } else if (stringArray.length != 0) {
            throw new AbortException("Incorrect command line parameters.");
        }
        new CheckELKIServices().checkServices(string);
    }

    public void checkServices(String string) {
        Enumeration<URL> enumeration;
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            enumeration = this.getClass().getClassLoader().getResources("META-INF/elki/");
        }
        catch (IOException iOException) {
            throw new AbortException("Error enumerating service folders.", iOException);
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                if ("jar".equals(uRL.getProtocol())) {
                    JarURLConnection object = (JarURLConnection)uRL.openConnection();
                    JarFile jarFile = object.getJarFile();
                    Throwable throwable = null;
                    try {
                        Enumeration<JarEntry> throwable2 = jarFile.entries();
                        while (throwable2.hasMoreElements()) {
                            String string2 = throwable2.nextElement().getName();
                            if (string2.startsWith("META-INF/elki/")) {
                                treeSet.add(string2.substring("META-INF/elki/".length()));
                                continue;
                            }
                            if (!string2.startsWith(ELKIServiceLoader.FILENAME_PREFIX)) continue;
                            treeSet.add(string2.substring(ELKIServiceLoader.FILENAME_PREFIX.length()));
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jarFile.close();
                        continue;
                    }
                }
                if (!"file".equals(uRL.getProtocol())) continue;
                treeSet.addAll(Arrays.asList(new File(uRL.toURI()).list()));
            }
            catch (IOException | URISyntaxException exception) {
                throw new AbortException("Error enumerating service folders.", exception);
            }
        }
        for (String string3 : treeSet) {
            if (LOG.isVerbose()) {
                LOG.verbose("Checking property: " + string3);
            }
            this.checkService(string3, string);
        }
    }

    private void checkService(String string, String string2) {
        Object object;
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.warning("Service file name is not a class name: " + string);
            return;
        }
        List<Class<?>> list = ELKIServiceRegistry.findAllImplementations(clazz, false, false);
        HashSet<String> hashSet = new HashSet<String>();
        for (Class<?> object22 : list) {
            hashSet.add(object22.getName());
        }
        Matcher matcher = this.strip.matcher("");
        try {
            Enumeration<URL> iOException = this.getClass().getClassLoader().getResources("META-INF/elki/" + clazz.getName());
            while (iOException.hasMoreElements()) {
                String string3;
                object = iOException.nextElement();
                boolean bl = "jar".equals(((URL)object).getProtocol());
                Iterator iterator = new BufferedReader(new InputStreamReader(((URL)object).openStream(), "utf-8"));
                while ((string3 = ((BufferedReader)((Object)iterator)).readLine()) != null) {
                    matcher.reset(string3);
                    if (!matcher.matches()) {
                        LOG.warning("Line: " + string3 + " didn't match regexp.");
                        continue;
                    }
                    String string4 = matcher.group(1);
                    if (string4.length() <= 0) continue;
                    String[] stringArray = string4.split(" ");
                    if (!hashSet.remove(stringArray[0]) && !bl) {
                        LOG.warning("Name " + stringArray[0] + " found for property " + string + " but no class discovered (or listed twice).");
                    }
                    this.checkAliases(clazz, stringArray[0], stringArray);
                }
            }
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
        if (hashSet.size() > 0) {
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            if (string2 == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Class ").append(string).append(" lacks suggestions:").append(FormatUtil.NEWLINE);
                for (Iterator iterator : arrayList) {
                    ((StringBuilder)object).append("# ").append((String)((Object)iterator)).append(FormatUtil.NEWLINE);
                }
                LOG.warning(((StringBuilder)object).toString());
                return;
            }
            try {
                Files.createDirectories(Paths.get(string2 + File.separator + ELKIServiceLoader.FILENAME_PREFIX, new String[0]), new FileAttribute[0]);
                object = string2 + File.separator + ELKIServiceLoader.FILENAME_PREFIX + string;
                PrintStream printStream = new PrintStream(new FileOutputStream((String)object, true));
                printStream.println();
                printStream.println("### Automatically appended entries:");
                for (String string3 : arrayList) {
                    printStream.println(string3);
                }
                printStream.close();
                LOG.warning("Updated service file: " + (String)object);
            }
            catch (IOException iOException) {
                LOG.exception(iOException);
            }
        }
    }

    private void checkAliases(Class<?> clazz, String string, String[] stringArray) {
        Class<?> clazz2 = ELKIServiceRegistry.findImplementation(clazz, string);
        if (clazz2 == null) {
            return;
        }
        Alias alias = clazz2.getAnnotation(Alias.class);
        if (alias == null) {
            if (stringArray.length > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Class ").append(string);
                stringBuilder.append(" in ").append(clazz.getCanonicalName());
                stringBuilder.append(" has the following extraneous aliases:");
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(' ').append(stringArray[i]);
                }
                LOG.warning(stringBuilder);
            }
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 1; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        StringBuilder stringBuilder = null;
        for (String string2 : alias.value()) {
            if (hashSet.remove(string2)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("Class ").append(string);
                stringBuilder.append(" in ").append(clazz.getCanonicalName());
                stringBuilder.append(" is missing the following aliases:");
            }
            stringBuilder.append(' ').append(string2);
        }
        if (!hashSet.isEmpty()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Class ").append(string);
            stringBuilder.append(" in ").append(clazz.getCanonicalName());
            stringBuilder.append(" has the following extraneous aliases:");
            for (String string3 : hashSet) {
                stringBuilder.append(' ').append(string3);
            }
        }
        if (stringBuilder != null) {
            LOG.warning(stringBuilder);
        }
    }
}

