/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.data.Bit;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.TIntDoubleMap;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BitVector
extends AbstractNumberVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<BitVector> SHORT_SERIALIZER = new ShortSerializer();
    private final long[] bits;
    private int dimensionality;

    public BitVector(long[] lArray, int n) {
        this.bits = lArray;
        this.dimensionality = n;
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int n) {
        this.dimensionality = n;
    }

    public boolean booleanValue(int n) {
        return BitsUtil.get(this.bits, n);
    }

    @Override
    @Deprecated
    public Bit getValue(int n) {
        return new Bit(this.booleanValue(n));
    }

    @Override
    public double doubleValue(int n) {
        return BitsUtil.get(this.bits, n) ? 1.0 : 0.0;
    }

    @Override
    public long longValue(int n) {
        return BitsUtil.get(this.bits, n) ? 1L : 0L;
    }

    @Override
    public int iter() {
        return BitsUtil.nextSetBit(this.bits, 0);
    }

    @Override
    public int iterAdvance(int n) {
        return BitsUtil.nextSetBit(this.bits, n + 1);
    }

    @Override
    public boolean iterValid(int n) {
        return n >= 0;
    }

    @Override
    public int iterDim(int n) {
        return n;
    }

    @Override
    public double iterDoubleValue(int n) {
        return 1.0;
    }

    @Override
    public float iterFloatValue(int n) {
        return 1.0f;
    }

    @Override
    public int iterIntValue(int n) {
        return 1;
    }

    @Override
    public short iterShortValue(int n) {
        return 1;
    }

    @Override
    public long iterLongValue(int n) {
        return 1L;
    }

    @Override
    public byte iterByteValue(int n) {
        return 1;
    }

    @Override
    public Vector getColumnVector() {
        double[] dArray = new double[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            dArray[i] = BitsUtil.get(this.bits, i) ? 1.0 : 0.0;
        }
        return new Vector(dArray);
    }

    public boolean contains(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (i >= this.bits.length && l != 0L) {
                return false;
            }
            if ((l & this.bits[i]) == l) continue;
            return false;
        }
        return true;
    }

    public long[] cloneBits() {
        return (long[])this.bits.clone();
    }

    public int cardinality() {
        return BitsUtil.cardinality(this.bits);
    }

    public double jaccardSimilarity(BitVector bitVector) {
        return (double)BitsUtil.intersectionSize(this.bits, bitVector.bits) / (double)BitsUtil.unionSize(this.bits, bitVector.bits);
    }

    public int hammingDistance(BitVector bitVector) {
        return BitsUtil.hammingDistance(this.bits, bitVector.bits);
    }

    public int intersectionSize(BitVector bitVector) {
        return BitsUtil.intersectionSize(this.bits, bitVector.bits);
    }

    public int unionSize(BitVector bitVector) {
        return BitsUtil.unionSize(this.bits, bitVector.bits);
    }

    public boolean intersect(BitVector bitVector) {
        return BitsUtil.intersect(this.bits, bitVector.bits);
    }

    public void andOnto(long[] lArray) {
        BitsUtil.andI(lArray, this.bits);
    }

    public void orOnto(long[] lArray) {
        BitsUtil.orI(lArray, this.bits);
    }

    public void xorOnto(long[] lArray) {
        BitsUtil.xorI(lArray, this.bits);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.dimensionality; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(BitsUtil.get(this.bits, i) ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof BitVector) {
            BitVector bitVector = (BitVector)object;
            return this.getDimensionality() == bitVector.getDimensionality() && this.bits.equals(bitVector.bits);
        }
        return false;
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<BitVector> {
        @Override
        public BitVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            int n2 = 2 + (n + 7) / 8;
            if (byteBuffer.remaining() < n2) {
                throw new IOException("Not enough data for a bit vector!");
            }
            long[] lArray = BitsUtil.zero(n);
            byte by = 0;
            for (int i = 0; i < n; ++i) {
                byte by2;
                if ((i & 7) == 0) {
                    by = byteBuffer.get();
                }
                if ((by & (by2 = (byte)(1 << (i & 7)))) == 0) continue;
                BitsUtil.setI(lArray, i);
            }
            return new BitVector(lArray, n);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, BitVector bitVector) throws IOException {
            int n = this.getByteSize(bitVector);
            assert (bitVector.getDimensionality() <= Short.MAX_VALUE);
            int n2 = bitVector.getDimensionality();
            if (byteBuffer.remaining() < n) {
                throw new IOException("Not enough space for the bit vector!");
            }
            byteBuffer.putShort((short)n2);
            byte by = 0;
            for (int i = 0; i < n2; ++i) {
                byte by2 = (byte)(1 << (i & 7));
                by = BitsUtil.get(bitVector.bits, i) ? (byte)(by | by2) : (byte)(by & ~by2);
                if ((i & 7) != 7 && i != n2 - 1) continue;
                byteBuffer.put(by);
                by = 0;
            }
        }

        @Override
        public int getByteSize(BitVector bitVector) {
            return 2 + (bitVector.getDimensionality() + 7) / 8;
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<BitVector>
    implements SparseNumberVector.Factory<BitVector> {
        @Override
        public <A> BitVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            long[] lArray = BitsUtil.zero(n);
            for (int i = 0; i < n; ++i) {
                if (!(arrayAdapter.get(a, i).doubleValue() >= 0.5)) continue;
                BitsUtil.setI(lArray, i);
            }
            return new BitVector(lArray, n);
        }

        @Override
        public <A> BitVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            long[] lArray = BitsUtil.zero(n);
            for (int i = 0; i < n; ++i) {
                if (!(numberArrayAdapter.getDouble(a, i) >= 0.5)) continue;
                BitsUtil.setI(lArray, i);
            }
            return new BitVector(lArray, n);
        }

        @Override
        public BitVector newNumberVector(TIntDoubleMap tIntDoubleMap, int n) {
            long[] lArray = BitsUtil.zero(n);
            TIntDoubleIterator tIntDoubleIterator = tIntDoubleMap.iterator();
            while (tIntDoubleIterator.hasNext()) {
                tIntDoubleIterator.advance();
                if (tIntDoubleIterator.value() == 0.0) continue;
                BitsUtil.setI(lArray, tIntDoubleIterator.key());
            }
            return new BitVector(lArray, n);
        }

        @Override
        public ByteBufferSerializer<BitVector> getDefaultSerializer() {
            return SHORT_SERIALIZER;
        }

        @Override
        public Class<? super BitVector> getRestrictionClass() {
            return BitVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

