/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ShortVector
extends AbstractNumberVector {
    public static final Factory STATIC = new Factory();
    public static final ByteBufferSerializer<ShortVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<ShortVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final short[] values;

    private ShortVector(short[] sArray, boolean bl) {
        if (bl) {
            this.values = sArray;
        } else {
            this.values = new short[sArray.length];
            System.arraycopy(sArray, 0, this.values, 0, sArray.length);
        }
    }

    public ShortVector(short[] sArray) {
        this.values = (short[])sArray.clone();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Short getValue(int n) {
        return this.values[n];
    }

    @Override
    public double doubleValue(int n) {
        return this.values[n];
    }

    @Override
    public long longValue(int n) {
        return this.values[n];
    }

    @Override
    public int intValue(int n) {
        return this.values[n];
    }

    @Override
    public short shortValue(int n) {
        return this.values[n];
    }

    public short[] getValues() {
        short[] sArray = new short[this.values.length];
        System.arraycopy(this.values, 0, sArray, 0, this.values.length);
        return sArray;
    }

    @Override
    public Vector getColumnVector() {
        double[] dArray = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            dArray[i] = this.values[i];
        }
        return new Vector(dArray);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<ShortVector> {
        @Override
        public ShortVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            assert (byteBuffer.remaining() >= 4 * n);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)ByteArrayUtil.readSignedVarint(byteBuffer);
            }
            return new ShortVector(sArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, ShortVector shortVector) throws IOException {
            assert (shortVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, shortVector.values.length);
            for (int i = 0; i < shortVector.values.length; ++i) {
                ByteArrayUtil.writeSignedVarint(byteBuffer, shortVector.values[i]);
            }
        }

        @Override
        public int getByteSize(ShortVector shortVector) {
            assert (shortVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            int n = ByteArrayUtil.getUnsignedVarintSize(shortVector.values.length);
            for (int i = 0; i < shortVector.values.length; ++i) {
                n += ByteArrayUtil.getSignedVarintSize(shortVector.values[i]);
            }
            return n;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<ShortVector> {
        @Override
        public ShortVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            assert (byteBuffer.remaining() >= 2 * n);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = byteBuffer.getShort();
            }
            return new ShortVector(sArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, ShortVector shortVector) throws IOException {
            assert (shortVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 2 * shortVector.values.length);
            byteBuffer.putShort((short)shortVector.values.length);
            for (int i = 0; i < shortVector.values.length; ++i) {
                byteBuffer.putShort(shortVector.values[i]);
            }
        }

        @Override
        public int getByteSize(ShortVector shortVector) {
            assert (shortVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 2 * shortVector.getDimensionality();
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<ShortVector> {
        @Override
        public <A> ShortVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = arrayAdapter.get(a, i).shortValue();
            }
            return new ShortVector(sArray, true);
        }

        @Override
        public <A> ShortVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = numberArrayAdapter.getShort(a, i);
            }
            return new ShortVector(sArray, true);
        }

        @Override
        public ByteBufferSerializer<ShortVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super ShortVector> getRestrictionClass() {
            return ShortVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

