/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.iterator.TIntFloatIterator;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.TIntFloatMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseFloatVector
extends AbstractNumberVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseFloatVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] indexes;
    private final float[] values;
    private int dimensionality;

    public SparseFloatVector(int[] nArray, float[] fArray, int n) {
        this.indexes = nArray;
        this.values = fArray;
        this.dimensionality = n;
    }

    public SparseFloatVector(TIntFloatMap tIntFloatMap, int n) throws IllegalArgumentException {
        int n2;
        if (tIntFloatMap.size() > n) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[tIntFloatMap.size()];
        this.values = new float[tIntFloatMap.size()];
        TIntFloatIterator tIntFloatIterator = tIntFloatMap.iterator();
        int n3 = 0;
        while (tIntFloatIterator.hasNext()) {
            tIntFloatIterator.advance();
            this.indexes[n3] = tIntFloatIterator.key();
            ++n3;
        }
        Arrays.sort(this.indexes);
        for (n2 = 0; n2 < tIntFloatMap.size(); ++n2) {
            this.values[n2] = tIntFloatMap.get(this.indexes[n2]);
        }
        this.dimensionality = n;
        n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
    }

    private int getMaxDim() {
        if (this.indexes.length == 0) {
            return 0;
        }
        return this.indexes[this.indexes.length - 1];
    }

    public SparseFloatVector(float[] fArray) throws IllegalArgumentException {
        int n;
        this.dimensionality = fArray.length;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (fArray[n] == 0.0f) continue;
            ++n2;
        }
        this.indexes = new int[n2];
        this.values = new float[n2];
        n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            if (f == 0.0f) continue;
            this.indexes[n] = i;
            this.values[n] = f;
            ++n;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int n) throws IllegalArgumentException {
        int n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
        this.dimensionality = n;
    }

    @Override
    @Deprecated
    public Float getValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return Float.valueOf(this.values[n2]);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    @Deprecated
    public double doubleValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public long longValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return (long)this.values[n2];
        }
        return 0L;
    }

    @Override
    public Vector getColumnVector() {
        return new Vector(this.getValues());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(this.indexes[i]);
            stringBuilder.append(" ");
            stringBuilder.append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    private double[] getValues() {
        double[] dArray = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            dArray[this.indexes[i]] = this.values[i];
        }
        return dArray;
    }

    @Override
    public int iter() {
        return 0;
    }

    @Override
    public int iterDim(int n) {
        return this.indexes[n];
    }

    @Override
    public int iterAdvance(int n) {
        return n + 1;
    }

    @Override
    public boolean iterValid(int n) {
        return n < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int n) {
        return this.values[n];
    }

    @Override
    public float iterFloatValue(int n) {
        return this.values[n];
    }

    @Override
    public int iterIntValue(int n) {
        return (int)this.values[n];
    }

    @Override
    public short iterShortValue(int n) {
        return (short)this.values[n];
    }

    @Override
    public long iterLongValue(int n) {
        return (long)this.values[n];
    }

    @Override
    public byte iterByteValue(int n) {
        return (byte)this.values[n];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseFloatVector> {
        @Override
        public SparseFloatVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int n2 = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int[] nArray = new int[n2];
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = ByteArrayUtil.readUnsignedVarint(byteBuffer);
                fArray[i] = byteBuffer.getFloat();
            }
            return new SparseFloatVector(nArray, fArray, n);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, SparseFloatVector sparseFloatVector) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseFloatVector.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseFloatVector.values.length);
            for (int i = 0; i < sparseFloatVector.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseFloatVector.indexes[i]);
                byteBuffer.putFloat(sparseFloatVector.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseFloatVector sparseFloatVector) {
            int n = 0;
            n += ByteArrayUtil.getUnsignedVarintSize(sparseFloatVector.dimensionality);
            n += ByteArrayUtil.getUnsignedVarintSize(sparseFloatVector.values.length);
            for (int n2 : sparseFloatVector.indexes) {
                n += ByteArrayUtil.getUnsignedVarintSize(n2);
            }
            return n += sparseFloatVector.values.length * 4;
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<SparseFloatVector>
    implements SparseNumberVector.Factory<SparseFloatVector> {
        @Override
        public <A> SparseFloatVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = arrayAdapter.get(a, i).floatValue();
            }
            return new SparseFloatVector(fArray);
        }

        @Override
        public <A> SparseFloatVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = numberArrayAdapter.getFloat(a, i);
            }
            return new SparseFloatVector(fArray);
        }

        @Override
        public SparseFloatVector newNumberVector(TIntDoubleMap tIntDoubleMap, int n) {
            int[] nArray = new int[tIntDoubleMap.size()];
            float[] fArray = new float[tIntDoubleMap.size()];
            TIntDoubleIterator tIntDoubleIterator = tIntDoubleMap.iterator();
            int n2 = 0;
            while (tIntDoubleIterator.hasNext()) {
                tIntDoubleIterator.advance();
                nArray[n2] = tIntDoubleIterator.key();
                ++n2;
            }
            Arrays.sort(nArray);
            for (n2 = 0; n2 < tIntDoubleMap.size(); ++n2) {
                fArray[n2] = (float)tIntDoubleMap.get(nArray[n2]);
            }
            return new SparseFloatVector(nArray, fArray, n);
        }

        @Override
        public ByteBufferSerializer<SparseFloatVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseFloatVector> getRestrictionClass() {
            return SparseFloatVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

