/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.text.NumberFormat;
import java.util.Locale;

public class CorrelationAnalysisSolution<V extends NumberVector>
implements TextWriteable,
Result,
Model {
    private LinearEquationSystem linearEquationSystem;
    private NumberFormat nf;
    private int correlationDimensionality;
    private final double standardDeviation;
    private final Matrix weakEigenvectors;
    private final Matrix strongEigenvectors;
    private final Matrix similarityMatrix;
    private final Vector centroid;

    public CorrelationAnalysisSolution(LinearEquationSystem linearEquationSystem, Relation<V> relation, Matrix matrix, Matrix matrix2, Matrix matrix3, Vector vector) {
        this(linearEquationSystem, relation, matrix, matrix2, matrix3, vector, NumberFormat.getInstance(Locale.US));
    }

    public CorrelationAnalysisSolution(LinearEquationSystem linearEquationSystem, Relation<V> relation, Matrix matrix, Matrix matrix2, Matrix matrix3, Vector vector, NumberFormat numberFormat) {
        this.linearEquationSystem = linearEquationSystem;
        this.correlationDimensionality = matrix.getColumnDimensionality();
        this.strongEigenvectors = matrix;
        this.weakEigenvectors = matrix2;
        this.similarityMatrix = matrix3;
        this.centroid = vector;
        this.nf = numberFormat;
        double d = 0.0;
        DBIDs dBIDs = relation.getDBIDs();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = this.distance(((NumberVector)relation.get(dBIDIter)).getColumnVector());
            d += d2 * d2;
            dBIDIter.advance();
        }
        this.standardDeviation = Math.sqrt(d / (double)dBIDs.size());
    }

    public LinearEquationSystem getNormalizedLinearEquationSystem(Normalization<?> normalization) throws NonNumericFeaturesException {
        if (normalization != null) {
            LinearEquationSystem linearEquationSystem = normalization.transform(this.linearEquationSystem);
            linearEquationSystem.solveByTotalPivotSearch();
            return linearEquationSystem;
        }
        return this.linearEquationSystem;
    }

    public int getCorrelationDimensionality() {
        return this.correlationDimensionality;
    }

    public double distance(V v) {
        return this.distance(v.getColumnVector());
    }

    private double distance(Vector vector) {
        Vector vector2 = vector.minus(this.centroid);
        Vector vector3 = vector2.projection(this.strongEigenvectors);
        return vector2.minus(vector3).euclideanLength();
    }

    public Vector errorVector(V v) {
        return v.getColumnVector().minusEquals(this.centroid).projection(this.weakEigenvectors);
    }

    public Matrix dataProjections(V v) {
        Vector vector = v.getColumnVector().minusEquals(this.centroid);
        Matrix matrix = new Matrix(v.getDimensionality(), this.strongEigenvectors.getColumnDimensionality());
        for (int i = 0; i < this.strongEigenvectors.getColumnDimensionality(); ++i) {
            Vector vector2 = this.strongEigenvectors.getCol(i);
            vector2.timesEquals(vector.transposeTimes(vector2));
            matrix.setCol(i, vector2);
        }
        return matrix;
    }

    public Vector dataVector(V v) {
        return v.getColumnVector().minusEquals(this.centroid).projection(this.strongEigenvectors);
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public Matrix getStrongEigenvectors() {
        return this.strongEigenvectors;
    }

    public Matrix getWeakEigenvectors() {
        return this.weakEigenvectors;
    }

    public Matrix getSimilarityMatrix() {
        return this.similarityMatrix;
    }

    public Vector getCentroid() {
        return this.centroid;
    }

    @Override
    public void writeToText(TextWriterStream textWriterStream, String string) {
        if (string != null) {
            textWriterStream.commentPrintLn(string);
        }
        textWriterStream.commentPrintLn("Model class: " + this.getClass().getName());
        try {
            if (this.getNormalizedLinearEquationSystem(null) != null) {
                LinearEquationSystem linearEquationSystem = this.getNormalizedLinearEquationSystem(null);
                textWriterStream.commentPrint("Linear Equation System: ");
                textWriterStream.commentPrintLn(linearEquationSystem.equationsToString(this.nf));
            }
        }
        catch (NonNumericFeaturesException nonNumericFeaturesException) {
            LoggingUtil.exception(nonNumericFeaturesException);
        }
    }

    @Override
    public String getLongName() {
        return "Correlation Analysis Solution";
    }

    @Override
    public String getShortName() {
        return "correlationanalysissolution";
    }
}

