/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayQuickSort;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import java.util.Arrays;
import java.util.Comparator;

class ArrayModifiableIntegerDBIDs
implements ArrayModifiableDBIDs,
IntegerArrayDBIDs {
    private int[] store;
    private int size;
    public static final int INITIAL_SIZE = 21;

    protected ArrayModifiableIntegerDBIDs(int n) {
        this.store = new int[n < 3 ? 3 : n];
    }

    protected ArrayModifiableIntegerDBIDs() {
        this.store = new int[21];
    }

    protected ArrayModifiableIntegerDBIDs(DBIDs dBIDs) {
        this(dBIDs.size());
        if (dBIDs instanceof IntegerDBIDRange) {
            IntegerDBIDRange integerDBIDRange = (IntegerDBIDRange)dBIDs;
            for (int i = 0; i < integerDBIDRange.len; ++i) {
                this.store[i] = integerDBIDRange.start + i;
            }
            this.size = integerDBIDRange.len;
        } else {
            this.addDBIDs(dBIDs);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public DBID get(int n) {
        return new IntegerDBID(this.store[n]);
    }

    @Override
    public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(this.store[n]);
            return dBIDVar;
        }
        dBIDVar.set(this.get(n));
        return dBIDVar;
    }

    private void ensureSize(int n) {
        if (n <= this.store.length) {
            return;
        }
        int n2 = this.store.length;
        while (n2 < n) {
            n2 = (n2 >>> 1) + n2;
        }
        int[] nArray = this.store;
        this.store = new int[n2];
        System.arraycopy(nArray, 0, this.store, 0, this.size);
    }

    private void grow() {
        int n = this.store.length + (this.store.length >>> 1);
        int[] nArray = this.store;
        this.store = new int[n];
        System.arraycopy(nArray, 0, this.store, 0, this.size);
    }

    @Override
    public boolean addDBIDs(DBIDs dBIDs) {
        this.ensureSize(this.size + dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.store[this.size] = dBIDIter.internalGetIndex();
            ++this.size;
            dBIDIter.advance();
        }
        return true;
    }

    @Override
    public boolean removeDBIDs(DBIDs dBIDs) {
        boolean bl = false;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            int n = dBIDIter.internalGetIndex();
            for (int i = 0; i < this.size; ++i) {
                if (this.store[i] != n) continue;
                --this.size;
                this.store[i] = this.store[this.size];
                bl = true;
                break;
            }
            dBIDIter.advance();
        }
        return bl;
    }

    @Override
    public boolean add(DBIDRef dBIDRef) {
        if (this.size == this.store.length) {
            this.grow();
        }
        this.store[this.size] = dBIDRef.internalGetIndex();
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (this.store[i] != n) continue;
            --this.size;
            this.store[i] = this.store[this.size];
            return true;
        }
        return false;
    }

    @Override
    public void set(int n, DBIDRef dBIDRef) {
        this.store[n] = dBIDRef.internalGetIndex();
    }

    @Override
    public void insert(int n, DBIDRef dBIDRef) {
        if (this.size == this.store.length) {
            this.grow();
        }
        System.arraycopy(this.store, n, this.store, n + 1, this.size - n);
        this.store[n] = dBIDRef.internalGetIndex();
        ++this.size;
    }

    @Override
    public void remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (--this.size > 0) {
            this.store[n] = this.store[this.size];
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int binarySearch(DBIDRef dBIDRef) {
        return Arrays.binarySearch(this.store, 0, this.size, dBIDRef.internalGetIndex());
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (this.store[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sort() {
        Arrays.sort(this.store, 0, this.size);
    }

    @Override
    public void sort(Comparator<? super DBIDRef> comparator) {
        IntegerDBIDArrayQuickSort.sort(this.store, 0, this.size, comparator);
    }

    @Override
    public void sort(int n, int n2, Comparator<? super DBIDRef> comparator) {
        IntegerDBIDArrayQuickSort.sort(this.store, n, n2, comparator);
    }

    @Override
    public void swap(int n, int n2) {
        int n3 = this.store[n2];
        this.store[n2] = this.store[n];
        this.store[n] = n3;
    }

    @Override
    public DBIDVar pop(DBIDVar dBIDVar) {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot pop() from an empty array.");
        }
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(this.store[--this.size]);
        } else {
            dBIDVar.set(this.get(--this.size));
        }
        return dBIDVar;
    }

    @Override
    public Slice slice(int n, int n2) {
        return new Slice(n, n2);
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    private class Slice
    implements IntegerArrayDBIDs {
        final int begin;
        final int end;

        public Slice(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        @Override
        public int size() {
            return this.end - this.begin;
        }

        @Override
        public boolean contains(DBIDRef dBIDRef) {
            int n = dBIDRef.internalGetIndex();
            for (int i = this.begin; i < this.end; ++i) {
                if (ArrayModifiableIntegerDBIDs.this.store[i] != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public DBID get(int n) {
            return ArrayModifiableIntegerDBIDs.this.get(this.begin + n);
        }

        @Override
        public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
            return ArrayModifiableIntegerDBIDs.this.assignVar(this.begin + n, dBIDVar);
        }

        @Override
        public int binarySearch(DBIDRef dBIDRef) {
            return Arrays.binarySearch(ArrayModifiableIntegerDBIDs.this.store, this.begin, this.end, dBIDRef.internalGetIndex()) - this.begin;
        }

        @Override
        public SliceItr iter() {
            return new SliceItr();
        }

        @Override
        public Slice slice(int n, int n2) {
            return new Slice(n + n, n + n2);
        }

        private class SliceItr
        implements IntegerDBIDArrayIter {
            int pos;

            private SliceItr() {
                this.pos = Slice.this.begin;
            }

            @Override
            public int internalGetIndex() {
                return ArrayModifiableIntegerDBIDs.this.store[this.pos];
            }

            @Override
            public boolean valid() {
                return this.pos < Slice.this.end && this.pos >= Slice.this.begin;
            }

            @Override
            public SliceItr advance() {
                ++this.pos;
                return this;
            }

            @Override
            public int getOffset() {
                return this.pos - Slice.this.begin;
            }

            @Override
            public SliceItr advance(int n) {
                this.pos += n;
                return this;
            }

            @Override
            public SliceItr retract() {
                --this.pos;
                return this;
            }

            @Override
            public SliceItr seek(int n) {
                this.pos = n;
                return this;
            }

            public String toString() {
                return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
            }
        }
    }

    private class Itr
    implements IntegerDBIDArrayMIter {
        int pos = 0;

        private Itr() {
        }

        @Override
        public int internalGetIndex() {
            return ArrayModifiableIntegerDBIDs.this.store[this.pos];
        }

        @Override
        public boolean valid() {
            return this.pos < ArrayModifiableIntegerDBIDs.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public void remove() {
            ArrayModifiableIntegerDBIDs.this.remove(this.pos);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
        }
    }
}

