/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;

final class IntegerDBIDRange
implements IntegerDBIDs,
DBIDRange,
SetDBIDs {
    protected final int start;
    protected final int len;

    protected IntegerDBIDRange(int n, int n2) {
        this.start = n;
        this.len = n2;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        if (n < this.start) {
            return false;
        }
        return n < this.start + this.len;
    }

    @Override
    public DBID get(int n) {
        if (n > this.len || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return DBIDFactory.FACTORY.importInteger(this.start + n);
    }

    @Override
    public int getOffset(DBIDRef dBIDRef) {
        return dBIDRef.internalGetIndex() - this.start;
    }

    @Override
    public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(this.start + n);
            return dBIDVar;
        }
        dBIDVar.set(this.get(n));
        return dBIDVar;
    }

    @Override
    public int binarySearch(DBIDRef dBIDRef) {
        int n = DBIDUtil.asInteger(dBIDRef);
        if (n < this.start) {
            return -1;
        }
        int n2 = n - this.start;
        if (n2 < this.len) {
            return n2;
        }
        return -(this.len + 1);
    }

    public String toString() {
        return "[" + this.start + " to " + (this.start + this.len - 1) + "]";
    }

    @Override
    public final int mapDBIDToOffset(DBIDRef dBIDRef) {
        return dBIDRef.internalGetIndex() - this.start;
    }

    @Override
    public ArrayDBIDs slice(int n, int n2) {
        return new IntegerDBIDRange(n + this.start, n2 - n);
    }

    @Override
    public Itr iter() {
        return new Itr(this.start, this.len);
    }

    private static final class Itr
    implements IntegerDBIDArrayIter {
        private int pos;
        private final int len;
        private final int start;

        public Itr(int n, int n2) {
            this.start = n;
            this.len = n2;
        }

        @Override
        public boolean valid() {
            return this.pos < this.len && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return this.start + this.pos;
        }

        @Override
        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }
    }
}

