/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.rknn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.AbstractRKNNQuery;
import java.util.ArrayList;
import java.util.List;

public class LinearScanRKNNQuery<O>
extends AbstractRKNNQuery<O>
implements LinearScanQuery {
    protected final KNNQuery<O> knnQuery;

    public LinearScanRKNNQuery(DistanceQuery<O> distanceQuery, KNNQuery<O> kNNQuery, Integer n) {
        super(distanceQuery);
        this.knnQuery = kNNQuery;
    }

    @Override
    public DoubleDBIDList getRKNNForObject(O o, int n) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        List<KNNList> list = this.knnQuery.getKNNForBulkDBIDs(arrayDBIDs, n);
        int n2 = 0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            KNNList kNNList = list.get(n2);
            int n3 = Math.min(n - 1, kNNList.size() - 1);
            double d = this.distanceQuery.distance(o, dBIDArrayIter);
            if (n3 < n - 1 || d <= kNNList.get(n3).doubleValue()) {
                modifiableDoubleDBIDList.add(d, dBIDArrayIter);
            }
            ++n2;
            dBIDArrayIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public DoubleDBIDList getRKNNForDBID(DBIDRef dBIDRef, int n) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        List<KNNList> list = this.knnQuery.getKNNForBulkDBIDs(arrayDBIDs, n);
        int n2 = 0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            KNNList kNNList = list.get(n2);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (DBIDUtil.equal(doubleDBIDListIter, dBIDRef)) {
                    modifiableDoubleDBIDList.add(doubleDBIDListIter.doubleValue(), dBIDArrayIter);
                }
                doubleDBIDListIter.advance();
            }
            ++n2;
            dBIDArrayIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public List<? extends DoubleDBIDList> getRKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        ArrayList<ModifiableDoubleDBIDList> arrayList = new ArrayList<ModifiableDoubleDBIDList>(arrayDBIDs.size());
        for (int i = 0; i < arrayDBIDs.size(); ++i) {
            arrayList.add(DBIDUtil.newDistanceDBIDList());
        }
        ArrayDBIDs arrayDBIDs2 = DBIDUtil.ensureArray(this.relation.getDBIDs());
        List<KNNList> list = this.knnQuery.getKNNForBulkDBIDs(arrayDBIDs2, n);
        int n2 = 0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs2.iter();
        while (dBIDArrayIter.valid()) {
            KNNList kNNList = list.get(n2);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                int n3 = 0;
                DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
                while (dBIDArrayIter2.valid()) {
                    if (DBIDUtil.equal(doubleDBIDListIter, dBIDArrayIter2)) {
                        ModifiableDoubleDBIDList modifiableDoubleDBIDList = (ModifiableDoubleDBIDList)arrayList.get(n3);
                        modifiableDoubleDBIDList.add(doubleDBIDListIter.doubleValue(), dBIDArrayIter);
                    }
                    ++n3;
                    dBIDArrayIter2.advance();
                }
                doubleDBIDListIter.advance();
            }
            ++n2;
            dBIDArrayIter.advance();
        }
        for (int i = 0; i < arrayDBIDs.size(); ++i) {
            ((ModifiableDoubleDBIDList)arrayList.get(i)).sort();
        }
        return arrayList;
    }
}

