/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.LinearScanRKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.DistanceIndex;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public abstract class AbstractRelation<O>
extends AbstractHierarchicalResult
implements Relation<O> {
    @Override
    public DistanceQuery<O> getDistanceQuery(DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        if (distanceFunction == null) {
            throw new AbortException("Distance query requested for 'null' distance!");
        }
        Object[] objectArray2 = this.getHierarchy().iterChildrenReverse(this);
        while (objectArray2.valid()) {
            Index index;
            if (objectArray2.get() instanceof Index && (index = (Index)objectArray2.get()) instanceof DistanceIndex) {
                DistanceIndex distanceIndex = (DistanceIndex)index;
                DistanceQuery<O> distanceQuery = distanceIndex.getDistanceQuery(distanceFunction, objectArray);
                if (this.getLogger().isDebuggingFinest()) {
                    this.getLogger().debugFinest((distanceQuery != null ? "Using" : "Not using") + " index for distance query: " + index);
                }
                if (distanceQuery != null) {
                    return distanceQuery;
                }
            }
            objectArray2.advance();
        }
        for (Object object : objectArray) {
            if (object != "optimized" || distanceFunction instanceof DBIDDistanceFunction) continue;
            return null;
        }
        return distanceFunction.instantiate(this);
    }

    @Override
    public SimilarityQuery<O> getSimilarityQuery(SimilarityFunction<? super O> similarityFunction, Object ... objectArray) {
        if (similarityFunction == null) {
            throw new AbortException("Similarity query requested for 'null' similarity!");
        }
        return similarityFunction.instantiate(this);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery == null) {
            throw new AbortException("kNN query requested for 'null' distance!");
        }
        Object object = this.getHierarchy().iterChildrenReverse(this);
        while (object.valid()) {
            if (object.get() instanceof KNNIndex) {
                KNNIndex kNNIndex = (KNNIndex)object.get();
                KNNQuery<O> kNNQuery = kNNIndex.getKNNQuery(distanceQuery, objectArray);
                if (this.getLogger().isDebuggingFinest()) {
                    this.getLogger().debugFinest((kNNQuery != null ? "Using" : "Not using") + " index for kNN query: " + kNNIndex);
                }
                if (kNNQuery != null) {
                    return kNNQuery;
                }
            }
            object.advance();
        }
        for (Object object2 : objectArray) {
            if (object2 != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Fallback to linear scan - no index was able to accelerate this query.\n");
            ((StringBuilder)object).append("Distance query: ").append(distanceQuery).append('\n');
            if (objectArray.length > 0) {
                ((StringBuilder)object).append("Hints:");
                for (Object object3 : objectArray) {
                    ((StringBuilder)object).append(' ').append(object3);
                }
            }
            this.getLogger().debugFinest(((StringBuilder)object).toString());
        }
        return QueryUtil.getLinearScanKNNQuery(distanceQuery);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        DistanceQuery<? super O> distanceQuery = this.getDistanceQuery(distanceFunction, objectArray);
        return this.getKNNQuery(distanceQuery, objectArray);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery == null) {
            throw new AbortException("Range query requested for 'null' distance!");
        }
        Object object = this.getHierarchy().iterChildrenReverse(this);
        while (object.valid()) {
            if (object.get() instanceof RangeIndex) {
                RangeIndex rangeIndex = (RangeIndex)object.get();
                RangeQuery<O> rangeQuery = rangeIndex.getRangeQuery(distanceQuery, objectArray);
                if (this.getLogger().isDebuggingFinest()) {
                    this.getLogger().debugFinest((rangeQuery != null ? "Using" : "Not using") + " index for range query: " + rangeIndex);
                }
                if (rangeQuery != null) {
                    return rangeQuery;
                }
            }
            object.advance();
        }
        for (Object object2 : objectArray) {
            if (object2 != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Fallback to linear scan - no index was able to accelerate this query.\n");
            ((StringBuilder)object).append("Distance query: ").append(distanceQuery).append('\n');
            if (objectArray.length > 0) {
                ((StringBuilder)object).append("Hints:");
                for (Object object3 : objectArray) {
                    ((StringBuilder)object).append(' ').append(object3);
                }
            }
            this.getLogger().debugFinest(((StringBuilder)object).toString());
        }
        return QueryUtil.getLinearScanRangeQuery(distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        DistanceQuery<? super O> distanceQuery = this.getDistanceQuery(distanceFunction, objectArray);
        return this.getRangeQuery(distanceQuery, objectArray);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        Object object;
        if (distanceQuery == null) {
            throw new AbortException("RKNN query requested for 'null' distance!");
        }
        Object object2 = this.getHierarchy().iterChildrenReverse(this);
        while (object2.valid()) {
            if (object2.get() instanceof RKNNIndex) {
                object = (RKNNIndex)((Object)object2.get());
                RKNNQuery<O> rKNNQuery = object.getRKNNQuery(distanceQuery, objectArray);
                if (this.getLogger().isDebuggingFinest()) {
                    this.getLogger().debugFinest((rKNNQuery != null ? "Using" : "Not using") + " index for RkNN query: " + object);
                }
                if (rKNNQuery != null) {
                    return rKNNQuery;
                }
            }
            object2.advance();
        }
        object2 = null;
        for (Object object3 : objectArray) {
            if (object3 == "optimized") {
                return null;
            }
            if (!(object3 instanceof Integer)) continue;
            object2 = (Integer)object3;
        }
        if (this.getLogger().isDebuggingFinest()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Fallback to linear scan - no index was able to accelerate this query.\n");
            ((StringBuilder)object).append("Distance query: ").append(distanceQuery).append('\n');
            if (objectArray.length > 0) {
                ((StringBuilder)object).append("Hints:");
                for (Object object4 : objectArray) {
                    ((StringBuilder)object).append(' ').append(object4);
                }
            }
            this.getLogger().debugFinest(((StringBuilder)object).toString());
        }
        object = this.getKNNQuery(distanceQuery, "need_bulk", object2);
        return new LinearScanRKNNQuery<O>(distanceQuery, object, (Integer)object2);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        DistanceQuery<? super O> distanceQuery = this.getDistanceQuery(distanceFunction, objectArray);
        return this.getRKNNQuery(distanceQuery, objectArray);
    }

    protected abstract Logging getLogger();
}

