/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformationSerializer;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class BundleReader
implements BundleStreamSource {
    public static final int MAGIC = -1475200238;
    MappedByteBuffer buffer = null;
    BundleMeta meta = null;
    FileChannel input = null;
    ByteBufferSerializer<?>[] sers;
    Object[] data;
    boolean hasids = false;

    public BundleReader(MappedByteBuffer mappedByteBuffer) {
        this.buffer = mappedByteBuffer;
        this.input = null;
    }

    public BundleReader(FileChannel fileChannel) {
        this.input = fileChannel;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.openBuffer();
            this.readMeta();
        }
        return this.meta;
    }

    void openBuffer() {
        if (this.buffer == null) {
            try {
                this.buffer = this.input.map(FileChannel.MapMode.READ_ONLY, 0L, this.input.size());
            }
            catch (IOException iOException) {
                throw new AbortException("Cannot map input bundle.", iOException);
            }
        }
    }

    void readMeta() {
        int n = this.buffer.getInt();
        if (n != -1475200238) {
            throw new AbortException("File does not start with expected magic.");
        }
        int n2 = this.buffer.getInt();
        assert (n2 > 0) : "Empty bundle?";
        this.meta = new BundleMeta(n2);
        this.sers = new ByteBufferSerializer[n2];
        this.data = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            try {
                SimpleTypeInformation simpleTypeInformation = (SimpleTypeInformation)TypeInformationSerializer.STATIC.fromByteBuffer(this.buffer);
                this.sers[i] = simpleTypeInformation.getSerializer();
                if (i == 0 && TypeUtil.DBID.isAssignableFromType(simpleTypeInformation)) {
                    this.hasids = true;
                    continue;
                }
                this.meta.add(simpleTypeInformation);
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new AbortException("Deserialization failed: " + unsupportedOperationException.getMessage(), unsupportedOperationException);
            }
            catch (IOException iOException) {
                throw new AbortException("IO error", iOException);
            }
        }
    }

    void readObject() {
        for (int i = 0; i < this.sers.length; ++i) {
            try {
                this.data[i] = this.sers[i].fromByteBuffer(this.buffer);
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new AbortException("Deserialization failed.", unsupportedOperationException);
            }
            catch (IOException iOException) {
                throw new AbortException("IO error", iOException);
            }
        }
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.meta == null) {
            return BundleStreamSource.Event.META_CHANGED;
        }
        if (this.buffer.remaining() == 0) {
            ByteArrayUtil.unmapByteBuffer(this.buffer);
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        this.readObject();
        return BundleStreamSource.Event.NEXT_OBJECT;
    }

    @Override
    public Object data(int n) {
        return this.data[!this.hasids ? n : n + 1];
    }

    @Override
    public boolean hasDBIDs() {
        return this.hasids;
    }

    @Override
    public boolean assignDBID(DBIDVar dBIDVar) {
        if (!this.hasids) {
            return false;
        }
        dBIDVar.set((DBID)this.data[0]);
        return true;
    }

    @Override
    public MultipleObjectsBundle asMultipleObjectsBundle() {
        return MultipleObjectsBundle.fromStream(this);
    }
}

