/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.DropNaNFilter"})
public class DropNaNFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(DropNaNFilter.class);
    private long[] densecols = null;

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int n) {
        return this.source.data(n);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event event = this.source.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    return event;
                }
                case META_CHANGED: {
                    this.updateMeta(this.source.getMeta());
                    return event;
                }
                case NEXT_OBJECT: {
                    if (this.densecols == null) {
                        this.updateMeta(this.source.getMeta());
                    }
                    boolean bl = true;
                    int n = BitsUtil.nextSetBit(this.densecols, 0);
                    while (n >= 0) {
                        NumberVector numberVector = (NumberVector)this.source.data(n);
                        if (numberVector == null) {
                            bl = false;
                            break;
                        }
                        for (int i = 0; i < numberVector.getDimensionality(); ++i) {
                            if (!Double.isNaN(numberVector.doubleValue(i))) continue;
                            bl = false;
                            break;
                        }
                        n = BitsUtil.nextSetBit(this.densecols, n + 1);
                    }
                    if (!bl) continue block5;
                    return event;
                }
            }
        }
    }

    private void updateMeta(BundleMeta bundleMeta) {
        int n = bundleMeta.size();
        this.densecols = BitsUtil.zero(n);
        for (int i = 0; i < n; ++i) {
            if (TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)bundleMeta.get(i))) {
                throw new AbortException("Filtering sparse vectors is not yet supported by this filter. Please contribute.");
            }
            if (TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)bundleMeta.get(i))) {
                BitsUtil.setI(this.densecols, i);
                continue;
            }
            if (!TypeUtil.DOUBLE_VECTOR_FIELD.isAssignableFromType((TypeInformation)bundleMeta.get(i))) continue;
            BitsUtil.setI(this.densecols, i);
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        int n;
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("Removing records with NaN values.");
        }
        this.updateMeta(multipleObjectsBundle.meta());
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (n = 0; n < multipleObjectsBundle.metaLength(); ++n) {
            multipleObjectsBundle2.appendColumn(multipleObjectsBundle.meta(n), new ArrayList());
        }
        for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
            Object[] objectArray = multipleObjectsBundle.getRow(n);
            boolean bl = true;
            int n2 = BitsUtil.nextSetBit(this.densecols, 0);
            while (n2 >= 0) {
                NumberVector numberVector = (NumberVector)objectArray[n2];
                if (numberVector == null) {
                    bl = false;
                    break;
                }
                for (int i = 0; i < numberVector.getDimensionality(); ++i) {
                    if (!Double.isNaN(numberVector.doubleValue(i))) continue;
                    bl = false;
                    break;
                }
                n2 = BitsUtil.nextSetBit(this.densecols, n2 + 1);
            }
            if (!bl) continue;
            multipleObjectsBundle2.appendSimple(objectArray);
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected DropNaNFilter makeInstance() {
            return new DropNaNFilter();
        }
    }
}

